/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.zen.address;

import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.zksnark.JLibrustzcash;
import org.tron.common.zksnark.LibrustzcashParam;
import org.tron.core.exception.ZksnarkException;
import org.tron.core.zen.address.DiversifierT;
import org.tron.core.zen.address.PaymentAddress;

public class IncomingViewingKey {
    private static final Logger logger = LoggerFactory.getLogger((String)"shieldTransaction");
    public byte[] value;

    public Optional<PaymentAddress> address(DiversifierT d) throws ZksnarkException {
        byte[] pkD = new byte[32];
        if (JLibrustzcash.librustzcashCheckDiversifier((byte[])d.getData())) {
            if (!JLibrustzcash.librustzcashIvkToPkd((LibrustzcashParam.IvkToPkdParams)new LibrustzcashParam.IvkToPkdParams(this.value, d.getData(), pkD))) {
                throw new ZksnarkException("librustzcashIvkToPkd error");
            }
            return Optional.of(new PaymentAddress(d, pkD));
        }
        return Optional.empty();
    }

    public IncomingViewingKey(byte[] value) {
        this.value = value;
    }

    public void setValue(byte[] value) {
        this.value = value;
    }

    public byte[] getValue() {
        return this.value;
    }
}

