/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.trie;

import org.tron.common.utils.ByteArray;
import org.tron.common.utils.ByteUtil;

public final class TrieKey {
    public static final int ODD_OFFSET_FLAG = 1;
    public static final int TERMINATOR_FLAG = 2;
    private final byte[] key;
    private final int off;
    private final boolean terminal;

    public TrieKey(byte[] key, int off, boolean terminal) {
        this.terminal = terminal;
        this.off = off;
        this.key = key;
    }

    private TrieKey(byte[] key) {
        this(key, 0, true);
    }

    public static TrieKey fromNormal(byte[] key) {
        return new TrieKey(key);
    }

    public static TrieKey fromPacked(byte[] key) {
        return new TrieKey(key, (key[0] >> 4 & 1) != 0 ? 1 : 2, (key[0] >> 4 & 2) != 0);
    }

    public static TrieKey empty(boolean terminal) {
        return new TrieKey(ByteUtil.EMPTY_BYTE_ARRAY, 0, terminal);
    }

    public static TrieKey singleHex(int hex) {
        TrieKey ret = new TrieKey(new byte[1], 1, false);
        ret.setHex(0, hex);
        return ret;
    }

    public byte[] toPacked() {
        int flags = ((this.off & 1) != 0 ? 1 : 0) | (this.terminal ? 2 : 0);
        byte[] ret = new byte[this.getLength() / 2 + 1];
        int toCopy = (flags & 1) != 0 ? ret.length : ret.length - 1;
        System.arraycopy(this.key, this.key.length - toCopy, ret, ret.length - toCopy, toCopy);
        ret[0] = (byte)(ret[0] & 0xF);
        ret[0] = (byte)(ret[0] | flags << 4);
        return ret;
    }

    public byte[] toNormal() {
        if ((this.off & 1) != 0) {
            throw new RuntimeException("Can't convert a key with odd number of hexes to normal: " + this);
        }
        int arrLen = this.key.length - this.off / 2;
        byte[] ret = new byte[arrLen];
        System.arraycopy(this.key, this.key.length - arrLen, ret, 0, arrLen);
        return ret;
    }

    public boolean isTerminal() {
        return this.terminal;
    }

    public boolean isEmpty() {
        return this.getLength() == 0;
    }

    public TrieKey shift(int hexCnt) {
        return new TrieKey(this.key, this.off + hexCnt, this.terminal);
    }

    public TrieKey getCommonPrefix(TrieKey k) {
        int prefixLen;
        int thisLength = this.getLength();
        int kLength = k.getLength();
        for (prefixLen = 0; prefixLen < thisLength && prefixLen < kLength && this.getHex(prefixLen) == k.getHex(prefixLen); ++prefixLen) {
        }
        byte[] prefixKey = new byte[prefixLen + 1 >> 1];
        TrieKey ret = new TrieKey(prefixKey, (prefixLen & 1) == 0 ? 0 : 1, prefixLen == this.getLength() && prefixLen == k.getLength() && this.terminal && k.isTerminal());
        for (int i = 0; i < prefixLen; ++i) {
            ret.setHex(i, k.getHex(i));
        }
        return ret;
    }

    public TrieKey matchAndShift(TrieKey k) {
        int kLen;
        int len = this.getLength();
        if (len < (kLen = k.getLength())) {
            return null;
        }
        if ((this.off & 1) == (k.off & 1)) {
            if ((this.off & 1) == 1 && this.getHex(0) != k.getHex(0)) {
                return null;
            }
            int idx1 = this.off + 1 >> 1;
            int idx2 = k.off + 1 >> 1;
            int l = kLen >> 1;
            int i = 0;
            while (i < l) {
                if (this.key[idx1] != k.key[idx2]) {
                    return null;
                }
                ++i;
                ++idx1;
                ++idx2;
            }
        } else {
            for (int i = 0; i < kLen; ++i) {
                if (this.getHex(i) == k.getHex(i)) continue;
                return null;
            }
        }
        return this.shift(kLen);
    }

    public int getLength() {
        return (this.key.length << 1) - this.off;
    }

    private void setHex(int idx, int hex) {
        int byteIdx = this.off + idx >> 1;
        if ((this.off + idx & 1) == 0) {
            int n = byteIdx;
            this.key[n] = (byte)(this.key[n] & 0xF);
            int n2 = byteIdx;
            this.key[n2] = (byte)(this.key[n2] | hex << 4);
        } else {
            int n = byteIdx;
            this.key[n] = (byte)(this.key[n] & 0xF0);
            int n3 = byteIdx;
            this.key[n3] = (byte)(this.key[n3] | hex);
        }
    }

    public int getHex(int idx) {
        int b = this.key[this.off + idx >> 1];
        return ((this.off + idx & 1) == 0 ? b >> 4 : b) & 0xF;
    }

    public TrieKey concat(TrieKey k) {
        int i;
        if (this.isTerminal()) {
            throw new RuntimeException("Can' append to terminal key: " + this + " + " + k);
        }
        int len = this.getLength();
        int kLen = k.getLength();
        int newLen = len + kLen;
        byte[] newKeyBytes = new byte[newLen + 1 >> 1];
        TrieKey ret = new TrieKey(newKeyBytes, newLen & 1, k.isTerminal());
        for (i = 0; i < len; ++i) {
            ret.setHex(i, this.getHex(i));
        }
        for (i = 0; i < kLen; ++i) {
            ret.setHex(len + i, k.getHex(i));
        }
        return ret;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TrieKey k = (TrieKey)obj;
        int len = this.getLength();
        if (len != k.getLength()) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (this.getHex(i) == k.getHex(i)) continue;
            return false;
        }
        return this.isTerminal() == k.isTerminal();
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return ByteArray.toHexString((byte[])this.key).substring(this.off) + (this.isTerminal() ? "T" : "");
    }
}

