/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.services.ratelimiter.strategy;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Strategy {
    private static final Logger logger = LoggerFactory.getLogger(Strategy.class);
    protected Map<String, ParamItem> mapParams = new HashMap<String, ParamItem>();

    protected Strategy(String paramString) {
        this.parseStrategyParams(paramString);
    }

    public Map<String, ParamItem> parseStrategyParams(String argString) {
        this.mapParams = this.defaultParam();
        try {
            if (!StringUtils.isEmpty((CharSequence)argString)) {
                String pattern = "\\b([^\\s]+)=([^\\s]+)\\b";
                Pattern r = Pattern.compile(pattern);
                Matcher m = r.matcher(argString);
                while (m.find()) {
                    String key = m.group(1);
                    String value = m.group(2);
                    ParamItem item = this.mapParams.get(key);
                    if (item == null) continue;
                    if (item.type == Double.class) {
                        double doubleValue = Double.valueOf(value);
                        if (doubleValue <= 0.0) {
                            throw new IllegalArgumentException();
                        }
                        item.setValue(doubleValue);
                        continue;
                    }
                    if (item.type == String.class) {
                        item.setValue(value);
                        continue;
                    }
                    if (item.type != Integer.class) continue;
                    item.setValue(Integer.valueOf(value));
                }
            }
        }
        catch (Exception e) {
            this.mapParams = this.defaultParam();
            logger.warn("Strategy params parse failure, use the default strategy params.");
        }
        return this.mapParams;
    }

    protected abstract Map<String, ParamItem> defaultParam();

    public Map<String, ParamItem> getMapParams() {
        return this.mapParams;
    }

    class ParamItem<T> {
        protected Class<T> type;
        protected T value;

        ParamItem(Class<T> type, T value) {
            this.type = type;
            this.value = value;
        }

        public void setValue(T value) {
            this.value = value;
        }
    }
}

