/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.services.ratelimiter;

import io.grpc.ForwardingServerCallListener;
import io.grpc.Metadata;
import io.grpc.Server;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.ServerMethodDefinition;
import io.grpc.ServerServiceDefinition;
import io.grpc.Status;
import java.lang.reflect.Constructor;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.common.parameter.RateLimiterInitialization;
import org.tron.core.config.args.Args;
import org.tron.core.metrics.MetricsUtil;
import org.tron.core.services.ratelimiter.GlobalRateLimiter;
import org.tron.core.services.ratelimiter.RateLimiterContainer;
import org.tron.core.services.ratelimiter.RuntimeData;
import org.tron.core.services.ratelimiter.adapter.DefaultBaseQqsAdapter;
import org.tron.core.services.ratelimiter.adapter.GlobalPreemptibleAdapter;
import org.tron.core.services.ratelimiter.adapter.IPQPSRateLimiterAdapter;
import org.tron.core.services.ratelimiter.adapter.IPreemptibleRateLimiter;
import org.tron.core.services.ratelimiter.adapter.IRateLimiter;
import org.tron.core.services.ratelimiter.adapter.QpsRateLimiterAdapter;

@Component
public class RateLimiterInterceptor
implements ServerInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(RateLimiterInterceptor.class);
    private static final String KEY_PREFIX_RPC = "rpc_";
    @Autowired
    private RateLimiterContainer container;

    public void init(Server server) {
        for (ServerServiceDefinition service : server.getServices()) {
            for (ServerMethodDefinition method : service.getMethods()) {
                this.container.add(KEY_PREFIX_RPC, method.getMethodDescriptor().getFullMethodName(), new DefaultBaseQqsAdapter("qps=1000"));
            }
        }
        Map map = Args.getInstance().getRateLimiterInitialization().getRpcMap();
        for (Map.Entry entry : map.entrySet()) {
            RateLimiterInitialization.RpcRateLimiterItem item = (RateLimiterInitialization.RpcRateLimiterItem)entry.getValue();
            String cName = item.getStrategy();
            String component = item.getComponent();
            if ("".equals(cName)) continue;
            String params = item.getParams();
            try {
                switch (cName) {
                    case "GlobalPreemptibleAdapter": {
                        Class cls = GlobalPreemptibleAdapter.class;
                        Constructor constructor = cls.getConstructor(String.class);
                        Object obj = constructor.newInstance(params);
                        this.container.add(KEY_PREFIX_RPC, component, (IRateLimiter)obj);
                        break;
                    }
                    case "QpsRateLimiterAdapter": {
                        Class cls = QpsRateLimiterAdapter.class;
                        Constructor constructor = cls.getConstructor(String.class);
                        Object obj = constructor.newInstance(params);
                        this.container.add(KEY_PREFIX_RPC, component, (IRateLimiter)obj);
                        break;
                    }
                    case "IPQPSRateLimiterAdapter": {
                        Class cls = IPQPSRateLimiterAdapter.class;
                        Constructor constructor = cls.getConstructor(String.class);
                        Object obj = constructor.newInstance(params);
                        this.container.add(KEY_PREFIX_RPC, component, (IRateLimiter)obj);
                        break;
                    }
                    default: {
                        throw new Exception("undefined rate limiter adaptor");
                    }
                }
            }
            catch (Exception e) {
                logger.warn("the rate limiter adaptor {} is undefined.", (Object)cName);
            }
        }
    }

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        String methodMeterName = "net.api.detail.qps." + call.getMethodDescriptor().getFullMethodName();
        MetricsUtil.meterMark("net.api.qps");
        MetricsUtil.meterMark(methodMeterName);
        final IRateLimiter rateLimiter = this.container.get(KEY_PREFIX_RPC, call.getMethodDescriptor().getFullMethodName());
        RuntimeData runtimeData = new RuntimeData(call);
        GlobalRateLimiter.acquire(runtimeData);
        boolean acquireResource = true;
        if (rateLimiter != null) {
            acquireResource = rateLimiter.acquire(runtimeData);
        }
        Object listener = new ServerCall.Listener<ReqT>(){};
        try {
            if (acquireResource) {
                call.setMessageCompression(true);
                ServerCall.Listener delegate = next.startCall(call, headers);
                listener = new ForwardingServerCallListener.SimpleForwardingServerCallListener<ReqT>(delegate){

                    public void onComplete() {
                        if (rateLimiter instanceof IPreemptibleRateLimiter) {
                            ((IPreemptibleRateLimiter)rateLimiter).release();
                        }
                    }

                    public void onCancel() {
                        if (rateLimiter instanceof IPreemptibleRateLimiter) {
                            ((IPreemptibleRateLimiter)rateLimiter).release();
                        }
                    }
                };
            } else {
                call.close(Status.fromCode((Status.Code)Status.Code.RESOURCE_EXHAUSTED), new Metadata());
            }
        }
        catch (Exception e) {
            String grpcFailMeterName = "net.api.detail.failQps." + call.getMethodDescriptor().getFullMethodName();
            MetricsUtil.meterMark("net.api.failQps");
            MetricsUtil.meterMark(grpcFailMeterName);
            logger.error("Rpc Api Error: {}", (Object)e.getMessage());
        }
        return listener;
    }
}

