/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.services.jsonrpc.filters;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.bloom.Bloom;
import org.tron.common.crypto.Hash;
import org.tron.core.exception.JsonRpcTooManyResultException;
import org.tron.core.services.jsonrpc.filters.LogFilter;
import org.tron.core.services.jsonrpc.filters.LogFilterWrapper;
import org.tron.core.store.SectionBloomStore;

public class LogBlockQuery {
    private static final Logger logger = LoggerFactory.getLogger((String)"API");
    public static final int MAX_RESULT = 10000;
    private final LogFilterWrapper logFilterWrapper;
    private final SectionBloomStore sectionBloomStore;
    private final ExecutorService sectionExecutor;
    private final int minSection;
    private final int maxSection;
    private final long minBlock;
    private long maxBlock;
    private final long currentMaxBlockNum;

    public LogBlockQuery(LogFilterWrapper logFilterWrapper, SectionBloomStore sectionBloomStore, long currentMaxBlockNum, ExecutorService executor) {
        this.logFilterWrapper = logFilterWrapper;
        this.sectionBloomStore = sectionBloomStore;
        this.sectionExecutor = executor;
        this.currentMaxBlockNum = currentMaxBlockNum;
        if (logFilterWrapper.getFromBlock() == Long.MAX_VALUE) {
            this.minSection = (int)(currentMaxBlockNum / 2048L);
            this.minBlock = currentMaxBlockNum;
        } else {
            this.minSection = (int)(logFilterWrapper.getFromBlock() / 2048L);
            this.minBlock = logFilterWrapper.getFromBlock();
        }
        if (logFilterWrapper.getToBlock() == Long.MAX_VALUE) {
            this.maxSection = (int)(currentMaxBlockNum / 2048L);
            this.maxBlock = currentMaxBlockNum;
        } else {
            this.maxSection = (int)(logFilterWrapper.getToBlock() / 2048L);
            this.maxBlock = logFilterWrapper.getToBlock();
            if (this.maxBlock > currentMaxBlockNum) {
                this.maxBlock = currentMaxBlockNum;
            }
        }
    }

    public List<Long> getPossibleBlock() throws ExecutionException, InterruptedException, JsonRpcTooManyResultException {
        ArrayList<Long> blockNumList = new ArrayList<Long>();
        if (this.minBlock > this.currentMaxBlockNum) {
            return blockNumList;
        }
        int[][][] allConditionsIndex = this.getConditions();
        int capacity = (this.maxSection - this.minSection + 1) * 2048;
        BitSet blockNumBitSet = new BitSet(capacity);
        blockNumBitSet.set(0, capacity);
        for (int[][] conditionsIndex : allConditionsIndex) {
            BitSet bitSet = this.subMatch(conditionsIndex);
            blockNumBitSet.and(bitSet);
        }
        int i = blockNumBitSet.nextSetBit(0);
        while (i >= 0 && i != Integer.MAX_VALUE) {
            long blockNum = (long)this.minSection * 2048L + (long)i;
            if (this.minBlock <= blockNum && blockNum <= this.maxBlock) {
                blockNumList.add(blockNum);
            }
            i = blockNumBitSet.nextSetBit(i + 1);
        }
        if (blockNumList.size() >= 10000) {
            throw new JsonRpcTooManyResultException("query returned more than 10000 results");
        }
        return blockNumList;
    }

    private BitSet subMatch(int[][] bitIndexes) throws ExecutionException, InterruptedException {
        int capacity = (this.maxSection - this.minSection + 1) * 2048;
        BitSet subBitSet = new BitSet(capacity);
        for (int section = this.minSection; section <= this.maxSection; ++section) {
            BitSet partialBitSet = this.partialMatch(bitIndexes, section);
            int i = partialBitSet.nextSetBit(0);
            while (i >= 0 && i != Integer.MAX_VALUE) {
                int offset = (section - this.minSection) * 2048 + i;
                subBitSet.set(offset);
                i = partialBitSet.nextSetBit(i + 1);
            }
        }
        return subBitSet;
    }

    /*
     * WARNING - void declaration
     */
    private BitSet partialMatch(int[][] bitIndexes, int section) throws ExecutionException, InterruptedException {
        void var6_8;
        ArrayList bitSetList = new ArrayList();
        int[][] nArray = bitIndexes;
        int n = nArray.length;
        boolean bl = false;
        while (var6_8 < n) {
            int[] index = nArray[var6_8];
            ArrayList<Future<BitSet>> futureList = new ArrayList<Future<BitSet>>();
            for (int bitIndex : index) {
                Future<BitSet> bitSetFuture = this.sectionExecutor.submit(() -> this.sectionBloomStore.get(section, bitIndex));
                futureList.add(bitSetFuture);
            }
            bitSetList.add(futureList);
            ++var6_8;
        }
        BitSet bitSet = new BitSet(2048);
        for (List list : bitSetList) {
            BitSet subBitSet = new BitSet(2048);
            subBitSet.set(0, 2048);
            for (Future future : list) {
                BitSet one = (BitSet)future.get();
                if (one == null) {
                    subBitSet.clear();
                    break;
                }
                subBitSet.and(one);
            }
            bitSet.or(subBitSet);
        }
        return bitSet;
    }

    public int[][][] getConditions() {
        LogFilter logFilter = this.logFilterWrapper.getLogFilter();
        ArrayList<byte[][]> conditions = new ArrayList<byte[][]>();
        if (ArrayUtils.isNotEmpty((Object[])logFilter.getContractAddresses())) {
            conditions.add(logFilter.getContractAddresses());
        }
        for (byte[][] topicList : logFilter.getTopics()) {
            if (!ArrayUtils.isNotEmpty((Object[])topicList)) continue;
            conditions.add(topicList);
        }
        int[][][] allConditionsIndex = new int[conditions.size()][][];
        for (int k = 0; k < conditions.size(); ++k) {
            byte[][] conditionByte = (byte[][])conditions.get(k);
            int[][] bitIndexes = new int[conditionByte.length][];
            for (int j = 0; j < conditionByte.length; ++j) {
                byte[] hash = Hash.sha3((byte[])conditionByte[j]);
                Bloom bloom = Bloom.create((byte[])hash);
                BitSet bs = BitSet.valueOf(bloom.getData());
                int[] bitIndex = new int[3];
                int nonZeroCount = 0;
                int i = bs.nextSetBit(0);
                while (i >= 0 && i != Integer.MAX_VALUE) {
                    bitIndex[nonZeroCount++] = i;
                    i = bs.nextSetBit(i + 1);
                }
                bitIndexes[j] = bitIndex;
            }
            allConditionsIndex[k] = bitIndexes;
        }
        return allConditionsIndex;
    }
}

