/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.services.jsonrpc;

import com.alibaba.fastjson.JSON;
import com.google.protobuf.ByteString;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Message;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.api.GrpcAPI;
import org.tron.common.crypto.Hash;
import org.tron.common.logsfilter.ContractEventParser;
import org.tron.common.logsfilter.capsule.BlockFilterCapsule;
import org.tron.common.logsfilter.capsule.LogsFilterCapsule;
import org.tron.common.parameter.CommonParameter;
import org.tron.common.runtime.vm.DataWord;
import org.tron.common.utils.ByteArray;
import org.tron.common.utils.ByteUtil;
import org.tron.core.Wallet;
import org.tron.core.capsule.BlockCapsule;
import org.tron.core.capsule.TransactionCapsule;
import org.tron.core.db.Manager;
import org.tron.core.db2.core.Chainbase;
import org.tron.core.exception.BadItemException;
import org.tron.core.exception.ContractExeException;
import org.tron.core.exception.ContractValidateException;
import org.tron.core.exception.HeaderNotFound;
import org.tron.core.exception.ItemNotFoundException;
import org.tron.core.exception.JsonRpcInternalException;
import org.tron.core.exception.JsonRpcInvalidParamsException;
import org.tron.core.exception.JsonRpcInvalidRequestException;
import org.tron.core.exception.JsonRpcMethodNotFoundException;
import org.tron.core.exception.JsonRpcTooManyResultException;
import org.tron.core.exception.VMIllegalException;
import org.tron.core.services.NodeInfoService;
import org.tron.core.services.http.JsonFormat;
import org.tron.core.services.http.Util;
import org.tron.core.services.jsonrpc.JsonRpcApiUtil;
import org.tron.core.services.jsonrpc.TronJsonRpc;
import org.tron.core.services.jsonrpc.filters.BlockFilterAndResult;
import org.tron.core.services.jsonrpc.filters.LogBlockQuery;
import org.tron.core.services.jsonrpc.filters.LogFilter;
import org.tron.core.services.jsonrpc.filters.LogFilterAndResult;
import org.tron.core.services.jsonrpc.filters.LogFilterWrapper;
import org.tron.core.services.jsonrpc.filters.LogMatch;
import org.tron.core.services.jsonrpc.types.BlockResult;
import org.tron.core.services.jsonrpc.types.BuildArguments;
import org.tron.core.services.jsonrpc.types.CallArguments;
import org.tron.core.services.jsonrpc.types.TransactionReceipt;
import org.tron.core.services.jsonrpc.types.TransactionResult;
import org.tron.core.store.StorageRowStore;
import org.tron.core.vm.program.Storage;
import org.tron.program.Version;
import org.tron.protos.Protocol;
import org.tron.protos.contract.AssetIssueContractOuterClass;
import org.tron.protos.contract.BalanceContract;
import org.tron.protos.contract.SmartContractOuterClass;

public class TronJsonRpcImpl
implements TronJsonRpc {
    private static final Logger logger = LoggerFactory.getLogger((String)"API");
    private static final String FILTER_NOT_FOUND = "filter not found";
    public static final int EXPIRE_SECONDS = 300;
    private static final Map<String, LogFilterAndResult> eventFilter2ResultFull = new ConcurrentHashMap<String, LogFilterAndResult>();
    private static final Map<String, BlockFilterAndResult> blockFilter2ResultFull = new ConcurrentHashMap<String, BlockFilterAndResult>();
    private static final Map<String, LogFilterAndResult> eventFilter2ResultSolidity = new ConcurrentHashMap<String, LogFilterAndResult>();
    private static final Map<String, BlockFilterAndResult> blockFilter2ResultSolidity = new ConcurrentHashMap<String, BlockFilterAndResult>();
    public static final String HASH_REGEX = "(0x)?[a-zA-Z0-9]{64}$";
    public static final String EARLIEST_STR = "earliest";
    public static final String PENDING_STR = "pending";
    public static final String LATEST_STR = "latest";
    private static final String JSON_ERROR = "invalid json request";
    private static final String BLOCK_NUM_ERROR = "invalid block number";
    private static final String TAG_NOT_SUPPORT_ERROR = "TAG [earliest | pending] not supported";
    private static final String QUANTITY_NOT_SUPPORT_ERROR = "QUANTITY not supported, just support TAG as latest";
    private static final String NO_BLOCK_HEADER = "header not found";
    private static final String NO_BLOCK_HEADER_BY_HASH = "header for hash not found";
    private static final String ERROR_SELECTOR = "08c379a0";
    private final ExecutorService sectionExecutor;
    private final NodeInfoService nodeInfoService;
    private final Wallet wallet;
    private final Manager manager;

    public TronJsonRpcImpl(NodeInfoService nodeInfoService, Wallet wallet, Manager manager) {
        this.nodeInfoService = nodeInfoService;
        this.wallet = wallet;
        this.manager = manager;
        this.sectionExecutor = Executors.newFixedThreadPool(5);
    }

    public static void handleBLockFilter(BlockFilterCapsule blockFilterCapsule) {
        Iterator<Map.Entry<String, BlockFilterAndResult>> it = blockFilterCapsule.isSolidified() ? TronJsonRpcImpl.getBlockFilter2ResultSolidity().entrySet().iterator() : TronJsonRpcImpl.getBlockFilter2ResultFull().entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, BlockFilterAndResult> entry = it.next();
            if (entry.getValue().isExpire()) {
                it.remove();
                continue;
            }
            entry.getValue().getResult().add(ByteArray.toJsonHex((String)blockFilterCapsule.getBlockHash()));
        }
    }

    public static void handleLogsFilter(LogsFilterCapsule logsFilterCapsule) {
        Iterator<Map.Entry<String, LogFilterAndResult>> it = logsFilterCapsule.isSolidified() ? TronJsonRpcImpl.getEventFilter2ResultSolidity().entrySet().iterator() : TronJsonRpcImpl.getEventFilter2ResultFull().entrySet().iterator();
        while (it.hasNext()) {
            LogFilter logFilter;
            List<TronJsonRpc.LogFilterElement> elements;
            Map.Entry<String, LogFilterAndResult> entry = it.next();
            if (entry.getValue().isExpire()) {
                it.remove();
                continue;
            }
            LogFilterAndResult logFilterAndResult = entry.getValue();
            long fromBlock = logFilterAndResult.getLogFilterWrapper().getFromBlock();
            long toBlock = logFilterAndResult.getLogFilterWrapper().getToBlock();
            if (fromBlock > logsFilterCapsule.getBlockNumber() || logsFilterCapsule.getBlockNumber() > toBlock || logsFilterCapsule.getBloom() != null && !logFilterAndResult.getLogFilterWrapper().getLogFilter().matchBloom(logsFilterCapsule.getBloom()) || !CollectionUtils.isNotEmpty(elements = LogMatch.matchBlock(logFilter = logFilterAndResult.getLogFilterWrapper().getLogFilter(), logsFilterCapsule.getBlockNumber(), logsFilterCapsule.getBlockHash(), logsFilterCapsule.getTxInfoList(), logsFilterCapsule.isRemoved()))) continue;
            logFilterAndResult.getResult().addAll(elements);
        }
    }

    @Override
    public String web3ClientVersion() {
        Pattern shortVersion = Pattern.compile("(\\d\\.\\d).*");
        Matcher matcher = shortVersion.matcher(System.getProperty("java.version"));
        matcher.matches();
        return String.join((CharSequence)"/", java.util.Arrays.asList("TRON", "v" + Version.getVersion(), System.getProperty("os.name"), "Java" + matcher.group(1)));
    }

    @Override
    public String web3Sha3(String data) throws JsonRpcInvalidParamsException {
        byte[] input;
        try {
            input = ByteArray.fromHexString((String)data);
        }
        catch (Exception e) {
            throw new JsonRpcInvalidParamsException("invalid input value");
        }
        byte[] result = Hash.sha3((byte[])input);
        return ByteArray.toJsonHex((byte[])result);
    }

    @Override
    public String ethGetBlockTransactionCountByHash(String blockHash) throws JsonRpcInvalidParamsException {
        Protocol.Block b = this.getBlockByJsonHash(blockHash);
        if (b == null) {
            return null;
        }
        long n = b.getTransactionsList().size();
        return ByteArray.toJsonHex((Long)n);
    }

    @Override
    public String ethGetBlockTransactionCountByNumber(String blockNumOrTag) throws JsonRpcInvalidParamsException {
        List<Protocol.Transaction> list = this.wallet.getTransactionsByJsonBlockId(blockNumOrTag);
        if (list == null) {
            return null;
        }
        long n = list.size();
        return ByteArray.toJsonHex((Long)n);
    }

    @Override
    public BlockResult ethGetBlockByHash(String blockHash, Boolean fullTransactionObjects) throws JsonRpcInvalidParamsException {
        Protocol.Block b = this.getBlockByJsonHash(blockHash);
        return this.getBlockResult(b, fullTransactionObjects);
    }

    @Override
    public BlockResult ethGetBlockByNumber(String blockNumOrTag, Boolean fullTransactionObjects) throws JsonRpcInvalidParamsException {
        Protocol.Block b = this.wallet.getByJsonBlockId(blockNumOrTag);
        return b == null ? null : this.getBlockResult(b, fullTransactionObjects);
    }

    private byte[] hashToByteArray(String hash) throws JsonRpcInvalidParamsException {
        byte[] bHash;
        if (!Pattern.matches(HASH_REGEX, hash)) {
            throw new JsonRpcInvalidParamsException("invalid hash value");
        }
        try {
            bHash = ByteArray.fromHexString((String)hash);
        }
        catch (Exception e) {
            throw new JsonRpcInvalidParamsException(e.getMessage());
        }
        return bHash;
    }

    private Protocol.Block getBlockByJsonHash(String blockHash) throws JsonRpcInvalidParamsException {
        byte[] bHash = this.hashToByteArray(blockHash);
        return this.wallet.getBlockById(ByteString.copyFrom((byte[])bHash));
    }

    private BlockResult getBlockResult(Protocol.Block block, boolean fullTx) {
        if (block == null) {
            return null;
        }
        return new BlockResult(block, fullTx, this.wallet);
    }

    @Override
    public String getNetVersion() throws JsonRpcInternalException {
        return this.ethChainId();
    }

    @Override
    public String ethChainId() throws JsonRpcInternalException {
        try {
            byte[] chainId = this.wallet.getBlockCapsuleByNum(0L).getBlockId().getBytes();
            return ByteArray.toJsonHex((byte[])java.util.Arrays.copyOfRange(chainId, chainId.length - 4, chainId.length));
        }
        catch (Exception e) {
            throw new JsonRpcInternalException(e.getMessage());
        }
    }

    @Override
    public boolean isListening() {
        int activeConnectCount = this.nodeInfoService.getNodeInfo().getActiveConnectCount();
        return activeConnectCount >= 1;
    }

    @Override
    public String getProtocolVersion() {
        return ByteArray.toJsonHex((int)this.wallet.getNowBlock().getBlockHeader().getRawData().getVersion());
    }

    @Override
    public String getLatestBlockNum() {
        return ByteArray.toJsonHex((Long)this.wallet.getNowBlock().getBlockHeader().getRawData().getNumber());
    }

    @Override
    public String getTrxBalance(String address, String blockNumOrTag) throws JsonRpcInvalidParamsException {
        if (EARLIEST_STR.equalsIgnoreCase(blockNumOrTag) || PENDING_STR.equalsIgnoreCase(blockNumOrTag)) {
            throw new JsonRpcInvalidParamsException(TAG_NOT_SUPPORT_ERROR);
        }
        if (LATEST_STR.equalsIgnoreCase(blockNumOrTag)) {
            byte[] addressData = JsonRpcApiUtil.addressCompatibleToByteArray(address);
            Protocol.Account account = Protocol.Account.newBuilder().setAddress(ByteString.copyFrom((byte[])addressData)).build();
            Protocol.Account reply = this.wallet.getAccount(account);
            long balance = 0L;
            if (reply != null) {
                balance = reply.getBalance();
            }
            return ByteArray.toJsonHex((Long)balance);
        }
        try {
            ByteArray.hexToBigInteger((String)blockNumOrTag);
        }
        catch (Exception e) {
            throw new JsonRpcInvalidParamsException(BLOCK_NUM_ERROR);
        }
        throw new JsonRpcInvalidParamsException(QUANTITY_NOT_SUPPORT_ERROR);
    }

    private void callTriggerConstantContract(byte[] ownerAddressByte, byte[] contractAddressByte, long value, byte[] data, GrpcAPI.TransactionExtention.Builder trxExtBuilder, GrpcAPI.Return.Builder retBuilder) throws ContractValidateException, ContractExeException, HeaderNotFound, VMIllegalException {
        SmartContractOuterClass.TriggerSmartContract triggerContract = JsonRpcApiUtil.triggerCallContract(ownerAddressByte, contractAddressByte, value, data, 0L, null);
        TransactionCapsule trxCap = this.wallet.createTransactionCapsule((Message)triggerContract, Protocol.Transaction.Contract.ContractType.TriggerSmartContract);
        Protocol.Transaction trx = this.wallet.triggerConstantContract(triggerContract, trxCap, trxExtBuilder, retBuilder);
        trxExtBuilder.setTransaction(trx);
        trxExtBuilder.setTxid(trxCap.getTransactionId().getByteString());
        trxExtBuilder.setResult(retBuilder);
        retBuilder.setResult(true).setCode(GrpcAPI.Return.response_code.SUCCESS);
    }

    private void estimateEnergy(byte[] ownerAddressByte, byte[] contractAddressByte, long value, byte[] data, GrpcAPI.TransactionExtention.Builder trxExtBuilder, GrpcAPI.Return.Builder retBuilder, GrpcAPI.EstimateEnergyMessage.Builder estimateBuilder) throws ContractValidateException, ContractExeException, HeaderNotFound, VMIllegalException {
        SmartContractOuterClass.TriggerSmartContract triggerContract = JsonRpcApiUtil.triggerCallContract(ownerAddressByte, contractAddressByte, value, data, 0L, null);
        TransactionCapsule trxCap = this.wallet.createTransactionCapsule((Message)triggerContract, Protocol.Transaction.Contract.ContractType.TriggerSmartContract);
        Protocol.Transaction trx = this.wallet.estimateEnergy(triggerContract, trxCap, trxExtBuilder, retBuilder, estimateBuilder);
        trxExtBuilder.setTransaction(trx);
        trxExtBuilder.setTxid(trxCap.getTransactionId().getByteString());
        trxExtBuilder.setResult(retBuilder);
        retBuilder.setResult(true).setCode(GrpcAPI.Return.response_code.SUCCESS);
        estimateBuilder.setResult(retBuilder);
    }

    private String call(byte[] ownerAddressByte, byte[] contractAddressByte, long value, byte[] data) throws JsonRpcInvalidRequestException, JsonRpcInternalException {
        byte[] listBytes;
        GrpcAPI.TransactionExtention.Builder trxExtBuilder = GrpcAPI.TransactionExtention.newBuilder();
        GrpcAPI.Return.Builder retBuilder = GrpcAPI.Return.newBuilder();
        try {
            this.callTriggerConstantContract(ownerAddressByte, contractAddressByte, value, data, trxExtBuilder, retBuilder);
        }
        catch (ContractValidateException | VMIllegalException e) {
            String errString = "Contract validate error : ";
            if (e.getMessage() != null) {
                errString = e.getMessage();
            }
            throw new JsonRpcInvalidRequestException(errString);
        }
        catch (Exception e) {
            String errString = JSON_ERROR;
            if (e.getMessage() != null) {
                errString = e.getMessage().replaceAll("[\"]", "'");
            }
            throw new JsonRpcInternalException(errString);
        }
        finally {
            GrpcAPI.TransactionExtention trxExt = trxExtBuilder.build();
        }
        if (trxExtBuilder.getTransaction().getRet(0).getRet().equals((Object)Protocol.Transaction.Result.code.SUCESS)) {
            GrpcAPI.TransactionExtention trxExt;
            List list = trxExt.getConstantResultList();
            listBytes = new byte[]{};
            for (ByteString bs : list) {
                listBytes = ByteUtil.merge((byte[][])new byte[][]{listBytes, bs.toByteArray()});
            }
        } else {
            logger.error("trigger contract failed.");
            String errMsg = retBuilder.getMessage().toStringUtf8();
            byte[] resData = trxExtBuilder.getConstantResult(0).toByteArray();
            if (resData.length > 4 && Hex.toHexString((byte[])resData).startsWith(ERROR_SELECTOR)) {
                String msg = ContractEventParser.parseDataBytes(Arrays.copyOfRange((byte[])resData, (int)4, (int)resData.length), "string", 0);
                errMsg = errMsg + ": " + msg;
            }
            throw new JsonRpcInternalException(errMsg);
        }
        String result = ByteArray.toJsonHex((byte[])listBytes);
        return result;
    }

    @Override
    public String getStorageAt(String address, String storageIdx, String blockNumOrTag) throws JsonRpcInvalidParamsException {
        if (EARLIEST_STR.equalsIgnoreCase(blockNumOrTag) || PENDING_STR.equalsIgnoreCase(blockNumOrTag)) {
            throw new JsonRpcInvalidParamsException(TAG_NOT_SUPPORT_ERROR);
        }
        if (LATEST_STR.equalsIgnoreCase(blockNumOrTag)) {
            byte[] addressByte = JsonRpcApiUtil.addressCompatibleToByteArray(address);
            GrpcAPI.BytesMessage.Builder build = GrpcAPI.BytesMessage.newBuilder();
            GrpcAPI.BytesMessage bytesMessage = build.setValue(ByteString.copyFrom((byte[])addressByte)).build();
            SmartContractOuterClass.SmartContract smartContract = this.wallet.getContract(bytesMessage);
            if (smartContract == null) {
                return ByteArray.toJsonHex((byte[])new byte[32]);
            }
            StorageRowStore store = this.manager.getStorageRowStore();
            Storage storage = new Storage(addressByte, store);
            storage.setContractVersion(smartContract.getVersion());
            storage.generateAddrHash(smartContract.getTrxHash().toByteArray());
            DataWord value = storage.getValue(new DataWord(ByteArray.fromHexString((String)storageIdx)));
            return ByteArray.toJsonHex((byte[])(value == null ? new byte[32] : value.getData()));
        }
        try {
            ByteArray.hexToBigInteger((String)blockNumOrTag);
        }
        catch (Exception e) {
            throw new JsonRpcInvalidParamsException(BLOCK_NUM_ERROR);
        }
        throw new JsonRpcInvalidParamsException(QUANTITY_NOT_SUPPORT_ERROR);
    }

    @Override
    public String getABIOfSmartContract(String contractAddress, String blockNumOrTag) throws JsonRpcInvalidParamsException {
        if (EARLIEST_STR.equalsIgnoreCase(blockNumOrTag) || PENDING_STR.equalsIgnoreCase(blockNumOrTag)) {
            throw new JsonRpcInvalidParamsException(TAG_NOT_SUPPORT_ERROR);
        }
        if (LATEST_STR.equalsIgnoreCase(blockNumOrTag)) {
            byte[] addressData = JsonRpcApiUtil.addressCompatibleToByteArray(contractAddress);
            GrpcAPI.BytesMessage.Builder build = GrpcAPI.BytesMessage.newBuilder();
            GrpcAPI.BytesMessage bytesMessage = build.setValue(ByteString.copyFrom((byte[])addressData)).build();
            SmartContractOuterClass.SmartContractDataWrapper contractDataWrapper = this.wallet.getContractInfo(bytesMessage);
            if (contractDataWrapper != null) {
                return ByteArray.toJsonHex((byte[])contractDataWrapper.getRuntimecode().toByteArray());
            }
            return "0x";
        }
        try {
            ByteArray.hexToBigInteger((String)blockNumOrTag);
        }
        catch (Exception e) {
            throw new JsonRpcInvalidParamsException(BLOCK_NUM_ERROR);
        }
        throw new JsonRpcInvalidParamsException(QUANTITY_NOT_SUPPORT_ERROR);
    }

    @Override
    public String getCoinbase() throws JsonRpcInternalException {
        String address = this.wallet.getCoinbase();
        if (StringUtils.isEmpty((CharSequence)address)) {
            throw new JsonRpcInternalException("etherbase must be explicitly specified");
        }
        return address;
    }

    @Override
    public String gasPrice() {
        return ByteArray.toJsonHex((Long)this.wallet.getEnergyFee());
    }

    @Override
    public String estimateGas(CallArguments args) throws JsonRpcInvalidRequestException, JsonRpcInvalidParamsException, JsonRpcInternalException {
        byte[] ownerAddress = JsonRpcApiUtil.addressCompatibleToByteArray(args.getFrom());
        Protocol.Transaction.Contract.ContractType contractType = args.getContractType(this.wallet);
        if (contractType == Protocol.Transaction.Contract.ContractType.TransferContract) {
            this.buildTransferContractTransaction(ownerAddress, new BuildArguments(args));
            return "0x0";
        }
        boolean supportEstimateEnergy = CommonParameter.getInstance().isEstimateEnergy();
        GrpcAPI.TransactionExtention.Builder trxExtBuilder = GrpcAPI.TransactionExtention.newBuilder();
        GrpcAPI.Return.Builder retBuilder = GrpcAPI.Return.newBuilder();
        GrpcAPI.EstimateEnergyMessage.Builder estimateBuilder = GrpcAPI.EstimateEnergyMessage.newBuilder();
        try {
            byte[] contractAddress = contractType == Protocol.Transaction.Contract.ContractType.TriggerSmartContract ? JsonRpcApiUtil.addressCompatibleToByteArray(args.getTo()) : new byte[]{};
            if (supportEstimateEnergy) {
                this.estimateEnergy(ownerAddress, contractAddress, args.parseValue(), ByteArray.fromHexString((String)args.getData()), trxExtBuilder, retBuilder, estimateBuilder);
            } else {
                this.callTriggerConstantContract(ownerAddress, contractAddress, args.parseValue(), ByteArray.fromHexString((String)args.getData()), trxExtBuilder, retBuilder);
            }
        }
        catch (ContractValidateException e) {
            String errString = "invalid contract";
            if (e.getMessage() != null) {
                errString = e.getMessage();
            }
            throw new JsonRpcInvalidRequestException(errString);
        }
        catch (Exception e) {
            String errString = JSON_ERROR;
            if (e.getMessage() != null) {
                errString = e.getMessage().replaceAll("[\"]", "'");
            }
            throw new JsonRpcInternalException(errString);
        }
        if (trxExtBuilder.getTransaction().getRet(0).getRet().equals((Object)Protocol.Transaction.Result.code.FAILED)) {
            String errMsg = retBuilder.getMessage().toStringUtf8();
            byte[] data = trxExtBuilder.getConstantResult(0).toByteArray();
            if (data.length > 4 && Hex.toHexString((byte[])data).startsWith(ERROR_SELECTOR)) {
                String msg = ContractEventParser.parseDataBytes(Arrays.copyOfRange((byte[])data, (int)4, (int)data.length), "string", 0);
                errMsg = errMsg + ": " + msg;
            }
            throw new JsonRpcInternalException(errMsg);
        }
        if (supportEstimateEnergy) {
            return ByteArray.toJsonHex((Long)estimateBuilder.getEnergyRequired());
        }
        return ByteArray.toJsonHex((Long)trxExtBuilder.getEnergyUsed());
    }

    @Override
    public TransactionResult getTransactionByHash(String txId) throws JsonRpcInvalidParamsException {
        ByteString transactionId = ByteString.copyFrom((byte[])this.hashToByteArray(txId));
        Protocol.TransactionInfo transactionInfo = this.wallet.getTransactionInfoById(transactionId);
        if (transactionInfo == null) {
            TransactionCapsule transactionCapsule = this.wallet.getTransactionCapsuleById(transactionId);
            if (transactionCapsule == null) {
                return null;
            }
            BlockCapsule blockCapsule = this.wallet.getBlockCapsuleByNum(transactionCapsule.getBlockNum());
            if (blockCapsule == null) {
                return new TransactionResult(transactionCapsule.getInstance(), this.wallet);
            }
            int transactionIndex = JsonRpcApiUtil.getTransactionIndex(ByteArray.toHexString((byte[])transactionCapsule.getTransactionId().getBytes()), blockCapsule.getInstance().getTransactionsList());
            if (transactionIndex == -1) {
                return null;
            }
            long energyUsageTotal = 0L;
            return new TransactionResult(blockCapsule, transactionIndex, transactionCapsule.getInstance(), energyUsageTotal, this.wallet.getEnergyFee(blockCapsule.getTimeStamp()), this.wallet);
        }
        Protocol.Block block = this.wallet.getBlockByNum(transactionInfo.getBlockNumber());
        if (block == null) {
            return null;
        }
        return this.formatTransactionResult(transactionInfo, block);
    }

    private TransactionResult formatTransactionResult(Protocol.TransactionInfo transactioninfo, Protocol.Block block) {
        String txId = ByteArray.toHexString((byte[])transactioninfo.getId().toByteArray());
        Protocol.Transaction transaction = null;
        int transactionIndex = -1;
        List txList = block.getTransactionsList();
        for (int index = 0; index < txList.size(); ++index) {
            transaction = (Protocol.Transaction)txList.get(index);
            if (!JsonRpcApiUtil.getTxID(transaction).equals(txId)) continue;
            transactionIndex = index;
            break;
        }
        if (transactionIndex == -1) {
            return null;
        }
        long energyUsageTotal = transactioninfo.getReceipt().getEnergyUsageTotal();
        BlockCapsule blockCapsule = new BlockCapsule(block);
        return new TransactionResult(blockCapsule, transactionIndex, transaction, energyUsageTotal, this.wallet.getEnergyFee(blockCapsule.getTimeStamp()), this.wallet);
    }

    private TransactionResult getTransactionByBlockAndIndex(Protocol.Block block, String index) throws JsonRpcInvalidParamsException {
        int txIndex;
        try {
            txIndex = ByteArray.jsonHexToInt((String)index);
        }
        catch (Exception e) {
            throw new JsonRpcInvalidParamsException("invalid index value");
        }
        if (txIndex >= block.getTransactionsCount()) {
            return null;
        }
        Protocol.Transaction transaction = block.getTransactions(txIndex);
        long energyUsageTotal = JsonRpcApiUtil.getEnergyUsageTotal(transaction, this.wallet);
        BlockCapsule blockCapsule = new BlockCapsule(block);
        return new TransactionResult(blockCapsule, txIndex, transaction, energyUsageTotal, this.wallet.getEnergyFee(blockCapsule.getTimeStamp()), this.wallet);
    }

    @Override
    public TransactionResult getTransactionByBlockHashAndIndex(String blockHash, String index) throws JsonRpcInvalidParamsException {
        Protocol.Block block = this.getBlockByJsonHash(blockHash);
        if (block == null) {
            return null;
        }
        return this.getTransactionByBlockAndIndex(block, index);
    }

    @Override
    public TransactionResult getTransactionByBlockNumberAndIndex(String blockNumOrTag, String index) throws JsonRpcInvalidParamsException {
        Protocol.Block block = this.wallet.getByJsonBlockId(blockNumOrTag);
        if (block == null) {
            return null;
        }
        return this.getTransactionByBlockAndIndex(block, index);
    }

    @Override
    public TransactionReceipt getTransactionReceipt(String txId) throws JsonRpcInvalidParamsException {
        Protocol.TransactionInfo transactionInfo = this.wallet.getTransactionInfoById(ByteString.copyFrom((byte[])this.hashToByteArray(txId)));
        if (transactionInfo == null) {
            return null;
        }
        Protocol.Block block = this.wallet.getBlockByNum(transactionInfo.getBlockNumber());
        if (block == null) {
            return null;
        }
        return new TransactionReceipt(block, transactionInfo, this.wallet);
    }

    @Override
    public String getCall(CallArguments transactionCall, Object blockParamObj) throws JsonRpcInvalidParamsException, JsonRpcInvalidRequestException, JsonRpcInternalException {
        String blockNumOrTag;
        if (blockParamObj instanceof HashMap) {
            HashMap paramMap = (HashMap)blockParamObj;
            if (paramMap.containsKey("blockNumber")) {
                long blockNumber;
                try {
                    blockNumOrTag = (String)paramMap.get("blockNumber");
                }
                catch (ClassCastException e) {
                    throw new JsonRpcInvalidParamsException(JSON_ERROR);
                }
                try {
                    blockNumber = ByteArray.hexToBigInteger((String)blockNumOrTag).longValue();
                }
                catch (Exception e) {
                    throw new JsonRpcInvalidParamsException(BLOCK_NUM_ERROR);
                }
                if (this.wallet.getBlockByNum(blockNumber) == null) {
                    throw new JsonRpcInternalException(NO_BLOCK_HEADER);
                }
            } else if (paramMap.containsKey("blockHash")) {
                try {
                    blockNumOrTag = (String)paramMap.get("blockHash");
                }
                catch (ClassCastException e) {
                    throw new JsonRpcInvalidParamsException(JSON_ERROR);
                }
                if (this.getBlockByJsonHash(blockNumOrTag) == null) {
                    throw new JsonRpcInternalException(NO_BLOCK_HEADER_BY_HASH);
                }
            } else {
                throw new JsonRpcInvalidRequestException(JSON_ERROR);
            }
            blockNumOrTag = LATEST_STR;
        } else if (blockParamObj instanceof String) {
            blockNumOrTag = (String)blockParamObj;
        } else {
            throw new JsonRpcInvalidRequestException(JSON_ERROR);
        }
        if (EARLIEST_STR.equalsIgnoreCase(blockNumOrTag) || PENDING_STR.equalsIgnoreCase(blockNumOrTag)) {
            throw new JsonRpcInvalidParamsException(TAG_NOT_SUPPORT_ERROR);
        }
        if (LATEST_STR.equalsIgnoreCase(blockNumOrTag)) {
            byte[] addressData = JsonRpcApiUtil.addressCompatibleToByteArray(transactionCall.getFrom());
            byte[] contractAddressData = JsonRpcApiUtil.addressCompatibleToByteArray(transactionCall.getTo());
            return this.call(addressData, contractAddressData, transactionCall.parseValue(), ByteArray.fromHexString((String)transactionCall.getData()));
        }
        try {
            ByteArray.hexToBigInteger((String)blockNumOrTag);
        }
        catch (Exception e) {
            throw new JsonRpcInvalidParamsException(BLOCK_NUM_ERROR);
        }
        throw new JsonRpcInvalidParamsException(QUANTITY_NOT_SUPPORT_ERROR);
    }

    @Override
    public String getPeerCount() {
        return ByteArray.toJsonHex((int)this.nodeInfoService.getNodeInfo().getPeerList().size());
    }

    @Override
    public Object getSyncingStatus() {
        if (this.nodeInfoService.getNodeInfo().getPeerList().isEmpty()) {
            return false;
        }
        long startingBlockNum = this.nodeInfoService.getNodeInfo().getBeginSyncNum();
        Protocol.Block nowBlock = this.wallet.getNowBlock();
        long currentBlockNum = nowBlock.getBlockHeader().getRawData().getNumber();
        long diff = (System.currentTimeMillis() - nowBlock.getBlockHeader().getRawData().getTimestamp()) / 3000L;
        diff = diff > 0L ? diff : 0L;
        long highestBlockNum = currentBlockNum + diff;
        return new TronJsonRpc.SyncingResult(ByteArray.toJsonHex((Long)startingBlockNum), ByteArray.toJsonHex((Long)currentBlockNum), ByteArray.toJsonHex((Long)highestBlockNum));
    }

    @Override
    public BlockResult getUncleByBlockHashAndIndex(String blockHash, String index) {
        return null;
    }

    @Override
    public BlockResult getUncleByBlockNumberAndIndex(String blockNumOrTag, String index) {
        return null;
    }

    @Override
    public String getUncleCountByBlockHash(String blockHash) {
        return "0x0";
    }

    @Override
    public String getUncleCountByBlockNumber(String blockNumOrTag) {
        return "0x0";
    }

    @Override
    public List<Object> ethGetWork() {
        Protocol.Block block = this.wallet.getNowBlock();
        String blockHash = null;
        if (block != null) {
            blockHash = ByteArray.toJsonHex((byte[])new BlockCapsule(block).getBlockId().getBytes());
        }
        return java.util.Arrays.asList(blockHash, null, null);
    }

    @Override
    public String getHashRate() {
        return "0x0";
    }

    @Override
    public boolean isMining() {
        return this.wallet.isMining();
    }

    @Override
    public String[] getAccounts() {
        return new String[0];
    }

    private TronJsonRpc.TransactionJson buildCreateSmartContractTransaction(byte[] ownerAddress, BuildArguments args) throws JsonRpcInvalidParamsException, JsonRpcInvalidRequestException, JsonRpcInternalException {
        try {
            SmartContractOuterClass.CreateSmartContract.Builder build = SmartContractOuterClass.CreateSmartContract.newBuilder();
            build.setOwnerAddress(ByteString.copyFrom((byte[])ownerAddress));
            build.setCallTokenValue(args.getTokenValue().longValue()).setTokenId(args.getTokenId().longValue());
            SmartContractOuterClass.SmartContract.ABI.Builder abiBuilder = SmartContractOuterClass.SmartContract.ABI.newBuilder();
            if (StringUtils.isNotEmpty((CharSequence)args.getAbi())) {
                String abiStr = "{\"entrys\":" + args.getAbi() + "}";
                JsonFormat.merge(abiStr, (Message.Builder)abiBuilder, args.isVisible());
            }
            SmartContractOuterClass.SmartContract.Builder smartBuilder = SmartContractOuterClass.SmartContract.newBuilder();
            smartBuilder.setAbi(abiBuilder).setCallValue(args.parseValue()).setConsumeUserResourcePercent(args.getConsumeUserResourcePercent().longValue()).setOriginEnergyLimit(args.getOriginEnergyLimit().longValue());
            smartBuilder.setOriginAddress(ByteString.copyFrom((byte[])ownerAddress));
            smartBuilder.setBytecode(ByteString.copyFrom((byte[])ByteArray.fromHexString((String)args.getData())));
            if (StringUtils.isNotEmpty((CharSequence)args.getName())) {
                smartBuilder.setName(args.getName());
            }
            build.setNewContract(smartBuilder);
            Protocol.Transaction tx = this.wallet.createTransactionCapsule((Message)build.build(), Protocol.Transaction.Contract.ContractType.CreateSmartContract).getInstance();
            Protocol.Transaction.Builder txBuilder = tx.toBuilder();
            Protocol.Transaction.raw.Builder rawBuilder = tx.getRawData().toBuilder();
            rawBuilder.setFeeLimit(args.parseGas() * this.wallet.getEnergyFee());
            txBuilder.setRawData(rawBuilder);
            tx = Util.setTransactionPermissionId(args.getPermissionId(), txBuilder.build());
            TronJsonRpc.TransactionJson transactionJson = new TronJsonRpc.TransactionJson();
            transactionJson.setTransaction(JSON.parseObject((String)Util.printCreateTransaction(tx, false)));
            return transactionJson;
        }
        catch (JsonRpcInvalidParamsException e) {
            throw new JsonRpcInvalidParamsException(e.getMessage());
        }
        catch (ContractValidateException e) {
            throw new JsonRpcInvalidRequestException(e.getMessage());
        }
        catch (Exception e) {
            throw new JsonRpcInternalException(e.getMessage());
        }
    }

    private TronJsonRpc.TransactionJson buildTriggerSmartContractTransaction(byte[] ownerAddress, BuildArguments args) throws JsonRpcInvalidParamsException, JsonRpcInvalidRequestException, JsonRpcInternalException {
        byte[] contractAddress = JsonRpcApiUtil.addressCompatibleToByteArray(args.getTo());
        SmartContractOuterClass.TriggerSmartContract.Builder build = SmartContractOuterClass.TriggerSmartContract.newBuilder();
        GrpcAPI.TransactionExtention.Builder trxExtBuilder = GrpcAPI.TransactionExtention.newBuilder();
        GrpcAPI.Return.Builder retBuilder = GrpcAPI.Return.newBuilder();
        try {
            build.setOwnerAddress(ByteString.copyFrom((byte[])ownerAddress)).setContractAddress(ByteString.copyFrom((byte[])contractAddress));
            if (StringUtils.isNotEmpty((CharSequence)args.getData())) {
                build.setData(ByteString.copyFrom((byte[])ByteArray.fromHexString((String)args.getData())));
            } else {
                build.setData(ByteString.copyFrom((byte[])new byte[0]));
            }
            build.setCallTokenValue(args.getTokenValue().longValue()).setTokenId(args.getTokenId().longValue()).setCallValue(args.parseValue());
            Protocol.Transaction tx = this.wallet.createTransactionCapsule((Message)build.build(), Protocol.Transaction.Contract.ContractType.TriggerSmartContract).getInstance();
            Protocol.Transaction.Builder txBuilder = tx.toBuilder();
            Protocol.Transaction.raw.Builder rawBuilder = tx.getRawData().toBuilder();
            rawBuilder.setFeeLimit(args.parseGas() * this.wallet.getEnergyFee());
            txBuilder.setRawData(rawBuilder);
            Protocol.Transaction trx = this.wallet.triggerContract(build.build(), new TransactionCapsule(txBuilder.build()), trxExtBuilder, retBuilder);
            trx = Util.setTransactionPermissionId(args.getPermissionId(), trx);
            trxExtBuilder.setTransaction(trx);
        }
        catch (JsonRpcInvalidParamsException e) {
            throw new JsonRpcInvalidParamsException(e.getMessage());
        }
        catch (ContractValidateException e) {
            throw new JsonRpcInvalidRequestException(e.getMessage());
        }
        catch (Exception e) {
            String errString = JSON_ERROR;
            if (e.getMessage() != null) {
                errString = e.getMessage().replaceAll("[\"]", "'");
            }
            throw new JsonRpcInternalException(errString);
        }
        String jsonString = Util.printTransaction(trxExtBuilder.build().getTransaction(), args.isVisible());
        TronJsonRpc.TransactionJson transactionJson = new TronJsonRpc.TransactionJson();
        transactionJson.setTransaction(JSON.parseObject((String)jsonString));
        return transactionJson;
    }

    private TronJsonRpc.TransactionJson createTransactionJson(GeneratedMessageV3.Builder<?> build, Protocol.Transaction.Contract.ContractType contractTyp, BuildArguments args) throws JsonRpcInvalidRequestException, JsonRpcInternalException {
        try {
            Protocol.Transaction tx = this.wallet.createTransactionCapsule(build.build(), contractTyp).getInstance();
            tx = Util.setTransactionPermissionId(args.getPermissionId(), tx);
            tx = Util.setTransactionExtraData(args.getExtraData(), tx, args.isVisible());
            TronJsonRpc.TransactionJson transactionJson = new TronJsonRpc.TransactionJson();
            transactionJson.setTransaction(JSON.parseObject((String)Util.printCreateTransaction(tx, args.isVisible())));
            return transactionJson;
        }
        catch (ContractValidateException e) {
            throw new JsonRpcInvalidRequestException(e.getMessage());
        }
        catch (Exception e) {
            throw new JsonRpcInternalException(e.getMessage());
        }
    }

    private TronJsonRpc.TransactionJson buildTransferContractTransaction(byte[] ownerAddress, BuildArguments args) throws JsonRpcInvalidParamsException, JsonRpcInvalidRequestException, JsonRpcInternalException {
        long amount = args.parseValue();
        BalanceContract.TransferContract.Builder build = BalanceContract.TransferContract.newBuilder();
        build.setOwnerAddress(ByteString.copyFrom((byte[])ownerAddress)).setToAddress(ByteString.copyFrom((byte[])JsonRpcApiUtil.addressCompatibleToByteArray(args.getTo()))).setAmount(amount);
        return this.createTransactionJson((GeneratedMessageV3.Builder<?>)build, Protocol.Transaction.Contract.ContractType.TransferContract, args);
    }

    private TronJsonRpc.TransactionJson buildTransferAssetContractTransaction(byte[] ownerAddress, BuildArguments args) throws JsonRpcInvalidParamsException, JsonRpcInvalidRequestException, JsonRpcInternalException {
        byte[] tokenIdArr = ByteArray.fromString((String)String.valueOf(args.getTokenId()));
        if (tokenIdArr == null) {
            throw new JsonRpcInvalidParamsException("invalid param value: invalid tokenId");
        }
        AssetIssueContractOuterClass.TransferAssetContract.Builder build = AssetIssueContractOuterClass.TransferAssetContract.newBuilder();
        build.setOwnerAddress(ByteString.copyFrom((byte[])ownerAddress)).setToAddress(ByteString.copyFrom((byte[])JsonRpcApiUtil.addressCompatibleToByteArray(args.getTo()))).setAssetName(ByteString.copyFrom((byte[])tokenIdArr)).setAmount(args.getTokenValue().longValue());
        return this.createTransactionJson((GeneratedMessageV3.Builder<?>)build, Protocol.Transaction.Contract.ContractType.TransferAssetContract, args);
    }

    public RequestSource getSource() {
        Chainbase.Cursor cursor = this.wallet.getCursor();
        switch (cursor) {
            case SOLIDITY: {
                return RequestSource.SOLIDITY;
            }
            case PBFT: {
                return RequestSource.PBFT;
            }
        }
        return RequestSource.FULLNODE;
    }

    public void disableInPBFT(String method) throws JsonRpcMethodNotFoundException {
        if (this.getSource() == RequestSource.PBFT) {
            String msg = String.format("the method %s does not exist/is not available in PBFT", method);
            throw new JsonRpcMethodNotFoundException(msg);
        }
    }

    @Override
    public TronJsonRpc.TransactionJson buildTransaction(BuildArguments args) throws JsonRpcInvalidParamsException, JsonRpcInvalidRequestException, JsonRpcInternalException, JsonRpcMethodNotFoundException {
        byte[] fromAddressData;
        if (this.getSource() != RequestSource.FULLNODE) {
            String msg = String.format("the method buildTransaction does not exist/is not available in %s", this.getSource().toString());
            throw new JsonRpcMethodNotFoundException(msg);
        }
        try {
            fromAddressData = JsonRpcApiUtil.addressCompatibleToByteArray(args.getFrom());
        }
        catch (JsonRpcInvalidParamsException e) {
            throw new JsonRpcInvalidRequestException(JSON_ERROR);
        }
        Protocol.Transaction.Contract.ContractType contractType = args.getContractType(this.wallet);
        switch (contractType.getNumber()) {
            case 30: {
                return this.buildCreateSmartContractTransaction(fromAddressData, args);
            }
            case 31: {
                return this.buildTriggerSmartContractTransaction(fromAddressData, args);
            }
            case 1: {
                return this.buildTransferContractTransaction(fromAddressData, args);
            }
            case 2: {
                return this.buildTransferAssetContractTransaction(fromAddressData, args);
            }
        }
        return null;
    }

    @Override
    public boolean ethSubmitWork(String nonceHex, String headerHex, String digestHex) throws JsonRpcMethodNotFoundException {
        throw new JsonRpcMethodNotFoundException("the method eth_submitWork does not exist/is not available");
    }

    @Override
    public String ethSendRawTransaction(String rawData) throws JsonRpcMethodNotFoundException {
        throw new JsonRpcMethodNotFoundException("the method eth_sendRawTransaction does not exist/is not available");
    }

    @Override
    public String ethSendTransaction(CallArguments args) throws JsonRpcMethodNotFoundException {
        throw new JsonRpcMethodNotFoundException("the method eth_sendTransaction does not exist/is not available");
    }

    @Override
    public String ethSign(String address, String msg) throws JsonRpcMethodNotFoundException {
        throw new JsonRpcMethodNotFoundException("the method eth_sign does not exist/is not available");
    }

    @Override
    public String ethSignTransaction(CallArguments transactionArgs) throws JsonRpcMethodNotFoundException {
        throw new JsonRpcMethodNotFoundException("the method eth_signTransaction does not exist/is not available");
    }

    @Override
    public String parityNextNonce(String address) throws JsonRpcMethodNotFoundException {
        throw new JsonRpcMethodNotFoundException("the method parity_nextNonce does not exist/is not available");
    }

    @Override
    public String getSendTransactionCountOfAddress(String address, String blockNumOrTag) throws JsonRpcMethodNotFoundException {
        throw new JsonRpcMethodNotFoundException("the method eth_getTransactionCount does not exist/is not available");
    }

    @Override
    public String[] getCompilers() throws JsonRpcMethodNotFoundException {
        throw new JsonRpcMethodNotFoundException("the method eth_getCompilers does not exist/is not available");
    }

    @Override
    public TronJsonRpc.CompilationResult ethCompileSolidity(String contract) throws JsonRpcMethodNotFoundException {
        throw new JsonRpcMethodNotFoundException("the method eth_compileSolidity does not exist/is not available");
    }

    @Override
    public TronJsonRpc.CompilationResult ethCompileLLL(String contract) throws JsonRpcMethodNotFoundException {
        throw new JsonRpcMethodNotFoundException("the method eth_compileLLL does not exist/is not available");
    }

    @Override
    public TronJsonRpc.CompilationResult ethCompileSerpent(String contract) throws JsonRpcMethodNotFoundException {
        throw new JsonRpcMethodNotFoundException("the method eth_compileSerpent does not exist/is not available");
    }

    @Override
    public TronJsonRpc.CompilationResult ethSubmitHashrate(String hashrate, String id) throws JsonRpcMethodNotFoundException {
        throw new JsonRpcMethodNotFoundException("the method eth_submitHashrate does not exist/is not available");
    }

    @Override
    public String newFilter(TronJsonRpc.FilterRequest fr) throws JsonRpcInvalidParamsException, JsonRpcMethodNotFoundException {
        this.disableInPBFT("eth_newFilter");
        Map<String, LogFilterAndResult> eventFilter2Result = this.getSource() == RequestSource.FULLNODE ? eventFilter2ResultFull : eventFilter2ResultSolidity;
        long currentMaxFullNum = this.wallet.getNowBlock().getBlockHeader().getRawData().getNumber();
        LogFilterAndResult logFilterAndResult = new LogFilterAndResult(fr, currentMaxFullNum, this.wallet);
        String filterID = JsonRpcApiUtil.generateFilterId();
        eventFilter2Result.put(filterID, logFilterAndResult);
        return ByteArray.toJsonHex((String)filterID);
    }

    @Override
    public String newBlockFilter() throws JsonRpcMethodNotFoundException {
        this.disableInPBFT("eth_newBlockFilter");
        Map<String, BlockFilterAndResult> blockFilter2Result = this.getSource() == RequestSource.FULLNODE ? blockFilter2ResultFull : blockFilter2ResultSolidity;
        BlockFilterAndResult filterAndResult = new BlockFilterAndResult();
        String filterID = JsonRpcApiUtil.generateFilterId();
        blockFilter2Result.put(filterID, filterAndResult);
        return ByteArray.toJsonHex((String)filterID);
    }

    @Override
    public boolean uninstallFilter(String filterId) throws ItemNotFoundException, JsonRpcMethodNotFoundException {
        Map<String, LogFilterAndResult> eventFilter2Result;
        Map<String, BlockFilterAndResult> blockFilter2Result;
        this.disableInPBFT("eth_uninstallFilter");
        if (this.getSource() == RequestSource.FULLNODE) {
            blockFilter2Result = blockFilter2ResultFull;
            eventFilter2Result = eventFilter2ResultFull;
        } else {
            blockFilter2Result = blockFilter2ResultSolidity;
            eventFilter2Result = eventFilter2ResultSolidity;
        }
        filterId = ByteArray.fromHex((String)filterId);
        if (eventFilter2Result.containsKey(filterId)) {
            eventFilter2Result.remove(filterId);
        } else if (blockFilter2Result.containsKey(filterId)) {
            blockFilter2Result.remove(filterId);
        } else {
            throw new ItemNotFoundException(FILTER_NOT_FOUND);
        }
        return true;
    }

    @Override
    public Object[] getFilterChanges(String filterId) throws ItemNotFoundException, JsonRpcMethodNotFoundException {
        Map<String, LogFilterAndResult> eventFilter2Result;
        Map<String, BlockFilterAndResult> blockFilter2Result;
        this.disableInPBFT("eth_getFilterChanges");
        if (this.getSource() == RequestSource.FULLNODE) {
            blockFilter2Result = blockFilter2ResultFull;
            eventFilter2Result = eventFilter2ResultFull;
        } else {
            blockFilter2Result = blockFilter2ResultSolidity;
            eventFilter2Result = eventFilter2ResultSolidity;
        }
        filterId = ByteArray.fromHex((String)filterId);
        return TronJsonRpcImpl.getFilterResult(filterId, blockFilter2Result, eventFilter2Result);
    }

    @Override
    public TronJsonRpc.LogFilterElement[] getLogs(TronJsonRpc.FilterRequest fr) throws JsonRpcInvalidParamsException, ExecutionException, InterruptedException, BadItemException, ItemNotFoundException, JsonRpcMethodNotFoundException, JsonRpcTooManyResultException {
        this.disableInPBFT("eth_getLogs");
        long currentMaxBlockNum = this.wallet.getNowBlock().getBlockHeader().getRawData().getNumber();
        LogFilterWrapper logFilterWrapper = new LogFilterWrapper(fr, currentMaxBlockNum, this.wallet);
        return this.getLogsByLogFilterWrapper(logFilterWrapper, currentMaxBlockNum);
    }

    @Override
    public TronJsonRpc.LogFilterElement[] getFilterLogs(String filterId) throws ExecutionException, InterruptedException, BadItemException, ItemNotFoundException, JsonRpcMethodNotFoundException, JsonRpcTooManyResultException {
        this.disableInPBFT("eth_getFilterLogs");
        Map<String, LogFilterAndResult> eventFilter2Result = this.getSource() == RequestSource.FULLNODE ? eventFilter2ResultFull : eventFilter2ResultSolidity;
        filterId = ByteArray.fromHex((String)filterId);
        if (!eventFilter2Result.containsKey(filterId)) {
            throw new ItemNotFoundException(FILTER_NOT_FOUND);
        }
        LogFilterWrapper logFilterWrapper = eventFilter2Result.get(filterId).getLogFilterWrapper();
        long currentMaxBlockNum = this.wallet.getNowBlock().getBlockHeader().getRawData().getNumber();
        return this.getLogsByLogFilterWrapper(logFilterWrapper, currentMaxBlockNum);
    }

    private TronJsonRpc.LogFilterElement[] getLogsByLogFilterWrapper(LogFilterWrapper logFilterWrapper, long currentMaxBlockNum) throws JsonRpcTooManyResultException, ExecutionException, InterruptedException, BadItemException, ItemNotFoundException {
        LogBlockQuery logBlockQuery = new LogBlockQuery(logFilterWrapper, this.manager.getChainBaseManager().getSectionBloomStore(), currentMaxBlockNum, this.sectionExecutor);
        List<Long> possibleBlockList = logBlockQuery.getPossibleBlock();
        LogMatch logMatch = new LogMatch(logFilterWrapper, possibleBlockList, this.manager);
        return logMatch.matchBlockOneByOne();
    }

    public static Object[] getFilterResult(String filterId, Map<String, BlockFilterAndResult> blockFilter2Result, Map<String, LogFilterAndResult> eventFilter2Result) throws ItemNotFoundException {
        Object[] result;
        if (blockFilter2Result.containsKey(filterId)) {
            List<String> blockHashList = blockFilter2Result.get(filterId).popAll();
            result = blockHashList.toArray(new String[blockHashList.size()]);
            blockFilter2Result.get(filterId).updateExpireTime();
        } else if (eventFilter2Result.containsKey(filterId)) {
            List<TronJsonRpc.LogFilterElement> logElementList = eventFilter2Result.get(filterId).popAll();
            result = logElementList.toArray(new TronJsonRpc.LogFilterElement[0]);
            eventFilter2Result.get(filterId).updateExpireTime();
        } else {
            throw new ItemNotFoundException(FILTER_NOT_FOUND);
        }
        return result;
    }

    public static Map<String, LogFilterAndResult> getEventFilter2ResultFull() {
        return eventFilter2ResultFull;
    }

    public static Map<String, BlockFilterAndResult> getBlockFilter2ResultFull() {
        return blockFilter2ResultFull;
    }

    public static Map<String, LogFilterAndResult> getEventFilter2ResultSolidity() {
        return eventFilter2ResultSolidity;
    }

    public static Map<String, BlockFilterAndResult> getBlockFilter2ResultSolidity() {
        return blockFilter2ResultSolidity;
    }

    public static enum RequestSource {
        FULLNODE,
        SOLIDITY,
        PBFT;

    }
}

