/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.services.jsonrpc;

import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.googlecode.jsonrpc4j.JsonRpcError;
import com.googlecode.jsonrpc4j.JsonRpcErrors;
import com.googlecode.jsonrpc4j.JsonRpcMethod;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.springframework.stereotype.Component;
import org.tron.common.runtime.vm.DataWord;
import org.tron.common.utils.ByteArray;
import org.tron.core.exception.BadItemException;
import org.tron.core.exception.ItemNotFoundException;
import org.tron.core.exception.JsonRpcInternalException;
import org.tron.core.exception.JsonRpcInvalidParamsException;
import org.tron.core.exception.JsonRpcInvalidRequestException;
import org.tron.core.exception.JsonRpcMethodNotFoundException;
import org.tron.core.exception.JsonRpcTooManyResultException;
import org.tron.core.services.jsonrpc.types.BlockResult;
import org.tron.core.services.jsonrpc.types.BuildArguments;
import org.tron.core.services.jsonrpc.types.CallArguments;
import org.tron.core.services.jsonrpc.types.TransactionReceipt;
import org.tron.core.services.jsonrpc.types.TransactionResult;

@Component
public interface TronJsonRpc {
    @JsonRpcMethod(value="web3_clientVersion")
    public String web3ClientVersion();

    @JsonRpcMethod(value="web3_sha3")
    @JsonRpcErrors(value={@JsonRpcError(exception=JsonRpcInvalidParamsException.class, code=-32602, data="{}")})
    public String web3Sha3(String var1) throws JsonRpcInvalidParamsException;

    @JsonRpcMethod(value="eth_getBlockTransactionCountByHash")
    @JsonRpcErrors(value={@JsonRpcError(exception=JsonRpcInvalidParamsException.class, code=-32602, data="{}")})
    public String ethGetBlockTransactionCountByHash(String var1) throws JsonRpcInvalidParamsException;

    @JsonRpcMethod(value="eth_getBlockTransactionCountByNumber")
    @JsonRpcErrors(value={@JsonRpcError(exception=JsonRpcInvalidParamsException.class, code=-32602, data="{}")})
    public String ethGetBlockTransactionCountByNumber(String var1) throws JsonRpcInvalidParamsException;

    @JsonRpcMethod(value="eth_getBlockByHash")
    @JsonRpcErrors(value={@JsonRpcError(exception=JsonRpcInvalidParamsException.class, code=-32602, data="{}")})
    public BlockResult ethGetBlockByHash(String var1, Boolean var2) throws JsonRpcInvalidParamsException;

    @JsonRpcMethod(value="eth_getBlockByNumber")
    @JsonRpcErrors(value={@JsonRpcError(exception=JsonRpcInvalidParamsException.class, code=-32602, data="{}")})
    public BlockResult ethGetBlockByNumber(String var1, Boolean var2) throws JsonRpcInvalidParamsException;

    @JsonRpcMethod(value="net_version")
    public String getNetVersion() throws JsonRpcInternalException;

    @JsonRpcMethod(value="eth_chainId")
    public String ethChainId() throws JsonRpcInternalException;

    @JsonRpcMethod(value="net_listening")
    public boolean isListening();

    @JsonRpcMethod(value="eth_protocolVersion")
    public String getProtocolVersion();

    @JsonRpcMethod(value="eth_blockNumber")
    public String getLatestBlockNum();

    @JsonRpcMethod(value="eth_getBalance")
    @JsonRpcErrors(value={@JsonRpcError(exception=JsonRpcInvalidParamsException.class, code=-32602, data="{}")})
    public String getTrxBalance(String var1, String var2) throws JsonRpcInvalidParamsException;

    @JsonRpcMethod(value="eth_getStorageAt")
    @JsonRpcErrors(value={@JsonRpcError(exception=JsonRpcInvalidParamsException.class, code=-32602, data="{}")})
    public String getStorageAt(String var1, String var2, String var3) throws JsonRpcInvalidParamsException;

    @JsonRpcMethod(value="eth_getCode")
    @JsonRpcErrors(value={@JsonRpcError(exception=JsonRpcInvalidParamsException.class, code=-32602, data="{}")})
    public String getABIOfSmartContract(String var1, String var2) throws JsonRpcInvalidParamsException;

    @JsonRpcMethod(value="eth_coinbase")
    @JsonRpcErrors(value={@JsonRpcError(exception=JsonRpcInternalException.class, code=-32000, data="{}")})
    public String getCoinbase() throws JsonRpcInternalException;

    @JsonRpcMethod(value="eth_gasPrice")
    public String gasPrice();

    @JsonRpcMethod(value="eth_estimateGas")
    @JsonRpcErrors(value={@JsonRpcError(exception=JsonRpcInvalidRequestException.class, code=-32600, data="{}"), @JsonRpcError(exception=JsonRpcInvalidParamsException.class, code=-32602, data="{}"), @JsonRpcError(exception=JsonRpcInternalException.class, code=-32000, data="{}")})
    public String estimateGas(CallArguments var1) throws JsonRpcInvalidRequestException, JsonRpcInvalidParamsException, JsonRpcInternalException;

    @JsonRpcMethod(value="eth_getTransactionByHash")
    @JsonRpcErrors(value={@JsonRpcError(exception=JsonRpcInvalidParamsException.class, code=-32602, data="{}")})
    public TransactionResult getTransactionByHash(String var1) throws JsonRpcInvalidParamsException;

    @JsonRpcMethod(value="eth_getTransactionByBlockHashAndIndex")
    @JsonRpcErrors(value={@JsonRpcError(exception=JsonRpcInvalidParamsException.class, code=-32602, data="{}")})
    public TransactionResult getTransactionByBlockHashAndIndex(String var1, String var2) throws JsonRpcInvalidParamsException;

    @JsonRpcMethod(value="eth_getTransactionByBlockNumberAndIndex")
    @JsonRpcErrors(value={@JsonRpcError(exception=JsonRpcInvalidParamsException.class, code=-32602, data="{}")})
    public TransactionResult getTransactionByBlockNumberAndIndex(String var1, String var2) throws JsonRpcInvalidParamsException;

    @JsonRpcMethod(value="eth_getTransactionReceipt")
    @JsonRpcErrors(value={@JsonRpcError(exception=JsonRpcInvalidParamsException.class, code=-32602, data="{}")})
    public TransactionReceipt getTransactionReceipt(String var1) throws JsonRpcInvalidParamsException;

    @JsonRpcMethod(value="eth_call")
    @JsonRpcErrors(value={@JsonRpcError(exception=JsonRpcInvalidRequestException.class, code=-32600, data="{}"), @JsonRpcError(exception=JsonRpcInvalidParamsException.class, code=-32602, data="{}"), @JsonRpcError(exception=JsonRpcInternalException.class, code=-32000, data="{}")})
    public String getCall(CallArguments var1, Object var2) throws JsonRpcInvalidParamsException, JsonRpcInvalidRequestException, JsonRpcInternalException;

    @JsonRpcMethod(value="net_peerCount")
    public String getPeerCount();

    @JsonRpcMethod(value="eth_syncing")
    public Object getSyncingStatus();

    @JsonRpcMethod(value="eth_getUncleByBlockHashAndIndex")
    public BlockResult getUncleByBlockHashAndIndex(String var1, String var2);

    @JsonRpcMethod(value="eth_getUncleByBlockNumberAndIndex")
    public BlockResult getUncleByBlockNumberAndIndex(String var1, String var2);

    @JsonRpcMethod(value="eth_getUncleCountByBlockHash")
    public String getUncleCountByBlockHash(String var1);

    @JsonRpcMethod(value="eth_getUncleCountByBlockNumber")
    public String getUncleCountByBlockNumber(String var1);

    @JsonRpcMethod(value="eth_getWork")
    public List<Object> ethGetWork();

    @JsonRpcMethod(value="eth_hashrate")
    public String getHashRate();

    @JsonRpcMethod(value="eth_mining")
    public boolean isMining();

    @JsonRpcMethod(value="eth_accounts")
    public String[] getAccounts();

    @JsonRpcMethod(value="buildTransaction")
    @JsonRpcErrors(value={@JsonRpcError(exception=JsonRpcInvalidRequestException.class, code=-32600, data="{}"), @JsonRpcError(exception=JsonRpcMethodNotFoundException.class, code=-32601, data="{}"), @JsonRpcError(exception=JsonRpcInvalidParamsException.class, code=-32602, data="{}"), @JsonRpcError(exception=JsonRpcInternalException.class, code=-32000, data="{}")})
    public TransactionJson buildTransaction(BuildArguments var1) throws JsonRpcInvalidParamsException, JsonRpcInvalidRequestException, JsonRpcInternalException, JsonRpcMethodNotFoundException;

    @JsonRpcMethod(value="eth_submitWork")
    @JsonRpcErrors(value={@JsonRpcError(exception=JsonRpcMethodNotFoundException.class, code=-32601, data="{}")})
    public boolean ethSubmitWork(String var1, String var2, String var3) throws JsonRpcMethodNotFoundException;

    @JsonRpcMethod(value="eth_sendRawTransaction")
    @JsonRpcErrors(value={@JsonRpcError(exception=JsonRpcMethodNotFoundException.class, code=-32601, data="{}")})
    public String ethSendRawTransaction(String var1) throws JsonRpcMethodNotFoundException;

    @JsonRpcMethod(value="eth_sendTransaction")
    @JsonRpcErrors(value={@JsonRpcError(exception=JsonRpcMethodNotFoundException.class, code=-32601, data="{}")})
    public String ethSendTransaction(CallArguments var1) throws JsonRpcMethodNotFoundException;

    @JsonRpcMethod(value="eth_sign")
    @JsonRpcErrors(value={@JsonRpcError(exception=JsonRpcMethodNotFoundException.class, code=-32601, data="{}")})
    public String ethSign(String var1, String var2) throws JsonRpcMethodNotFoundException;

    @JsonRpcMethod(value="eth_signTransaction")
    @JsonRpcErrors(value={@JsonRpcError(exception=JsonRpcMethodNotFoundException.class, code=-32601, data="{}")})
    public String ethSignTransaction(CallArguments var1) throws JsonRpcMethodNotFoundException;

    @JsonRpcMethod(value="parity_nextNonce")
    @JsonRpcErrors(value={@JsonRpcError(exception=JsonRpcMethodNotFoundException.class, code=-32601, data="{}")})
    public String parityNextNonce(String var1) throws JsonRpcMethodNotFoundException;

    @JsonRpcMethod(value="eth_getTransactionCount")
    @JsonRpcErrors(value={@JsonRpcError(exception=JsonRpcMethodNotFoundException.class, code=-32601, data="{}")})
    public String getSendTransactionCountOfAddress(String var1, String var2) throws JsonRpcMethodNotFoundException;

    @JsonRpcMethod(value="eth_getCompilers")
    @JsonRpcErrors(value={@JsonRpcError(exception=JsonRpcMethodNotFoundException.class, code=-32601, data="{}")})
    public String[] getCompilers() throws JsonRpcMethodNotFoundException;

    @JsonRpcMethod(value="eth_compileSolidity")
    @JsonRpcErrors(value={@JsonRpcError(exception=JsonRpcMethodNotFoundException.class, code=-32601, data="{}")})
    public CompilationResult ethCompileSolidity(String var1) throws JsonRpcMethodNotFoundException;

    @JsonRpcMethod(value="eth_compileLLL")
    @JsonRpcErrors(value={@JsonRpcError(exception=JsonRpcMethodNotFoundException.class, code=-32601, data="{}")})
    public CompilationResult ethCompileLLL(String var1) throws JsonRpcMethodNotFoundException;

    @JsonRpcMethod(value="eth_compileSerpent")
    @JsonRpcErrors(value={@JsonRpcError(exception=JsonRpcMethodNotFoundException.class, code=-32601, data="{}")})
    public CompilationResult ethCompileSerpent(String var1) throws JsonRpcMethodNotFoundException;

    @JsonRpcMethod(value="eth_submitHashrate")
    @JsonRpcErrors(value={@JsonRpcError(exception=JsonRpcMethodNotFoundException.class, code=-32601, data="{}")})
    public CompilationResult ethSubmitHashrate(String var1, String var2) throws JsonRpcMethodNotFoundException;

    @JsonRpcMethod(value="eth_newFilter")
    @JsonRpcErrors(value={@JsonRpcError(exception=JsonRpcMethodNotFoundException.class, code=-32601, data="{}"), @JsonRpcError(exception=JsonRpcInvalidParamsException.class, code=-32602, data="{}")})
    public String newFilter(FilterRequest var1) throws JsonRpcInvalidParamsException, JsonRpcMethodNotFoundException;

    @JsonRpcMethod(value="eth_newBlockFilter")
    @JsonRpcErrors(value={@JsonRpcError(exception=JsonRpcMethodNotFoundException.class, code=-32601, data="{}")})
    public String newBlockFilter() throws JsonRpcMethodNotFoundException;

    @JsonRpcMethod(value="eth_uninstallFilter")
    @JsonRpcErrors(value={@JsonRpcError(exception=JsonRpcMethodNotFoundException.class, code=-32601, data="{}"), @JsonRpcError(exception=JsonRpcInvalidParamsException.class, code=-32602, data="{}"), @JsonRpcError(exception=ItemNotFoundException.class, code=-32000, data="{}")})
    public boolean uninstallFilter(String var1) throws JsonRpcInvalidParamsException, JsonRpcMethodNotFoundException, ItemNotFoundException;

    @JsonRpcMethod(value="eth_getFilterChanges")
    @JsonRpcErrors(value={@JsonRpcError(exception=JsonRpcMethodNotFoundException.class, code=-32601, data="{}"), @JsonRpcError(exception=JsonRpcInvalidParamsException.class, code=-32602, data="{}"), @JsonRpcError(exception=ItemNotFoundException.class, code=-32000, data="{}")})
    public Object[] getFilterChanges(String var1) throws JsonRpcInvalidParamsException, IOException, ExecutionException, InterruptedException, JsonRpcMethodNotFoundException, ItemNotFoundException;

    @JsonRpcMethod(value="eth_getLogs")
    @JsonRpcErrors(value={@JsonRpcError(exception=JsonRpcInvalidParamsException.class, code=-32602, data="{}"), @JsonRpcError(exception=JsonRpcMethodNotFoundException.class, code=-32601, data="{}"), @JsonRpcError(exception=JsonRpcTooManyResultException.class, code=-32005, data="{}"), @JsonRpcError(exception=BadItemException.class, code=-32000, data="{}"), @JsonRpcError(exception=ExecutionException.class, code=-32000, data="{}"), @JsonRpcError(exception=InterruptedException.class, code=-32000, data="{}"), @JsonRpcError(exception=ItemNotFoundException.class, code=-32000, data="{}")})
    public LogFilterElement[] getLogs(FilterRequest var1) throws JsonRpcInvalidParamsException, ExecutionException, InterruptedException, BadItemException, ItemNotFoundException, JsonRpcMethodNotFoundException, JsonRpcTooManyResultException;

    @JsonRpcMethod(value="eth_getFilterLogs")
    @JsonRpcErrors(value={@JsonRpcError(exception=JsonRpcInvalidParamsException.class, code=-32602, data="{}"), @JsonRpcError(exception=JsonRpcMethodNotFoundException.class, code=-32601, data="{}"), @JsonRpcError(exception=JsonRpcTooManyResultException.class, code=-32005, data="{}"), @JsonRpcError(exception=BadItemException.class, code=-32000, data="{}"), @JsonRpcError(exception=ExecutionException.class, code=-32000, data="{}"), @JsonRpcError(exception=InterruptedException.class, code=-32000, data="{}"), @JsonRpcError(exception=ItemNotFoundException.class, code=-32000, data="{}")})
    public LogFilterElement[] getFilterLogs(String var1) throws JsonRpcInvalidParamsException, ExecutionException, InterruptedException, BadItemException, ItemNotFoundException, JsonRpcMethodNotFoundException, JsonRpcTooManyResultException;

    @JsonPropertyOrder(alphabetic=true)
    public static class LogFilterElement {
        private final String logIndex;
        private final String transactionIndex;
        private final String transactionHash;
        private final String blockHash;
        private final String blockNumber;
        private final String address;
        private final String data;
        private final String[] topics;
        private final boolean removed;

        public LogFilterElement(String blockHash, Long blockNum, String txId, Integer txIndex, String contractAddress, List<DataWord> topicList, String logData, int logIdx, boolean removed) {
            this.logIndex = ByteArray.toJsonHex((int)logIdx);
            this.blockNumber = blockNum == null ? null : ByteArray.toJsonHex((Long)blockNum);
            this.blockHash = blockHash == null ? null : ByteArray.toJsonHex((String)blockHash);
            this.transactionIndex = txIndex == null ? null : ByteArray.toJsonHex((int)txIndex);
            this.transactionHash = ByteArray.toJsonHex((String)txId);
            this.address = ByteArray.toJsonHex((String)contractAddress);
            this.data = logData == null ? "0x" : ByteArray.toJsonHex((String)logData);
            this.topics = new String[topicList.size()];
            for (int i = 0; i < this.topics.length; ++i) {
                this.topics[i] = ByteArray.toJsonHex((byte[])topicList.get(i).getData());
            }
            this.removed = removed;
        }

        public String getLogIndex() {
            return this.logIndex;
        }

        public String getTransactionIndex() {
            return this.transactionIndex;
        }

        public String getTransactionHash() {
            return this.transactionHash;
        }

        public String getBlockHash() {
            return this.blockHash;
        }

        public String getBlockNumber() {
            return this.blockNumber;
        }

        public String getAddress() {
            return this.address;
        }

        public String getData() {
            return this.data;
        }

        public String[] getTopics() {
            return this.topics;
        }

        public boolean isRemoved() {
            return this.removed;
        }
    }

    public static class FilterRequest {
        private String fromBlock;
        private String toBlock;
        private Object address;
        private Object[] topics;
        private String blockHash;

        public FilterRequest() {
        }

        public FilterRequest(String fromBlock, String toBlock, Object address, Object[] topics, String blockHash) {
            this.fromBlock = fromBlock;
            this.toBlock = toBlock;
            this.address = address;
            this.topics = topics;
            this.blockHash = blockHash;
        }

        public String getFromBlock() {
            return this.fromBlock;
        }

        public void setFromBlock(String fromBlock) {
            this.fromBlock = fromBlock;
        }

        public String getToBlock() {
            return this.toBlock;
        }

        public void setToBlock(String toBlock) {
            this.toBlock = toBlock;
        }

        public Object getAddress() {
            return this.address;
        }

        public void setAddress(Object address) {
            this.address = address;
        }

        public Object[] getTopics() {
            return this.topics;
        }

        public void setTopics(Object[] topics) {
            this.topics = topics;
        }

        public String getBlockHash() {
            return this.blockHash;
        }

        public void setBlockHash(String blockHash) {
            this.blockHash = blockHash;
        }
    }

    public static class TransactionJson {
        private JSONObject transaction;

        public JSONObject getTransaction() {
            return this.transaction;
        }

        public void setTransaction(JSONObject transaction) {
            this.transaction = transaction;
        }
    }

    public static class CompilationInfo {
        private String source;
        private String language;
        private String languageVersion;
        private String compilerVersion;
        private String userDoc;
        private String developerDoc;

        public String toString() {
            return "TronJsonRpc.CompilationInfo(source=" + this.getSource() + ", language=" + this.getLanguage() + ", languageVersion=" + this.getLanguageVersion() + ", compilerVersion=" + this.getCompilerVersion() + ", userDoc=" + this.getUserDoc() + ", developerDoc=" + this.getDeveloperDoc() + ")";
        }

        public String getSource() {
            return this.source;
        }

        public String getLanguage() {
            return this.language;
        }

        public String getLanguageVersion() {
            return this.languageVersion;
        }

        public String getCompilerVersion() {
            return this.compilerVersion;
        }

        public String getUserDoc() {
            return this.userDoc;
        }

        public String getDeveloperDoc() {
            return this.developerDoc;
        }
    }

    public static class CompilationResult {
        private String code;
        private CompilationInfo info;

        public String toString() {
            return "TronJsonRpc.CompilationResult(code=" + this.getCode() + ", info=" + this.getInfo() + ")";
        }

        public String getCode() {
            return this.code;
        }

        public CompilationInfo getInfo() {
            return this.info;
        }
    }

    public static class SyncingResult {
        private final String startingBlock;
        private final String currentBlock;
        private final String highestBlock;

        public SyncingResult(String startingBlock, String currentBlock, String highestBlock) {
            this.startingBlock = startingBlock;
            this.currentBlock = currentBlock;
            this.highestBlock = highestBlock;
        }

        public String toString() {
            return "TronJsonRpc.SyncingResult(startingBlock=" + this.getStartingBlock() + ", currentBlock=" + this.getCurrentBlock() + ", highestBlock=" + this.getHighestBlock() + ")";
        }

        public String getStartingBlock() {
            return this.startingBlock;
        }

        public String getCurrentBlock() {
            return this.currentBlock;
        }

        public String getHighestBlock() {
            return this.highestBlock;
        }
    }
}

