/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.services.jsonrpc;

import java.util.EnumSet;
import javax.servlet.DispatcherType;
import javax.servlet.Servlet;
import org.eclipse.jetty.server.ConnectionLimit;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.common.application.Service;
import org.tron.common.parameter.CommonParameter;
import org.tron.core.services.filter.HttpInterceptor;
import org.tron.core.services.jsonrpc.JsonRpcServlet;

@Component
public class FullNodeJsonRpcHttpService
implements Service {
    private static final Logger logger = LoggerFactory.getLogger((String)"API");
    private final int port = CommonParameter.getInstance().getJsonRpcHttpFullNodePort();
    private Server server;
    @Autowired
    private JsonRpcServlet jsonRpcServlet;

    @Override
    public void init() {
    }

    @Override
    public void init(CommonParameter args) {
    }

    @Override
    public void start() {
        try {
            this.server = new Server(this.port);
            ServletContextHandler context = new ServletContextHandler(1);
            context.setContextPath("/");
            this.server.setHandler((Handler)context);
            context.addServlet(new ServletHolder((Servlet)this.jsonRpcServlet), "/jsonrpc");
            int maxHttpConnectNumber = CommonParameter.getInstance().getMaxHttpConnectNumber();
            if (maxHttpConnectNumber > 0) {
                this.server.addBean((Object)new ConnectionLimit(maxHttpConnectNumber, this.server));
            }
            ServletHandler handler = new ServletHandler();
            FilterHolder fh = handler.addFilterWithMapping(HttpInterceptor.class, "/*", EnumSet.of(DispatcherType.REQUEST));
            context.addFilter(fh, "/*", EnumSet.of(DispatcherType.REQUEST));
            this.server.start();
        }
        catch (Exception e) {
            logger.debug("IOException: {}", (Object)e.getMessage());
        }
    }

    @Override
    public void stop() {
        try {
            this.server.stop();
        }
        catch (Exception e) {
            logger.debug("IOException: {}", (Object)e.getMessage());
        }
    }
}

