/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.services.http.solidity;

import java.util.EnumSet;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.eclipse.jetty.server.ConnectionLimit;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.common.application.Service;
import org.tron.common.parameter.CommonParameter;
import org.tron.core.config.args.Args;
import org.tron.core.services.filter.HttpApiAccessFilter;
import org.tron.core.services.http.EstimateEnergyServlet;
import org.tron.core.services.http.FullNodeHttpApiService;
import org.tron.core.services.http.GetAccountByIdServlet;
import org.tron.core.services.http.GetAccountServlet;
import org.tron.core.services.http.GetAssetIssueByIdServlet;
import org.tron.core.services.http.GetAssetIssueByNameServlet;
import org.tron.core.services.http.GetAssetIssueListByNameServlet;
import org.tron.core.services.http.GetAssetIssueListServlet;
import org.tron.core.services.http.GetAvailableUnfreezeCountServlet;
import org.tron.core.services.http.GetBlockByIdServlet;
import org.tron.core.services.http.GetBlockByLatestNumServlet;
import org.tron.core.services.http.GetBlockByLimitNextServlet;
import org.tron.core.services.http.GetBlockByNumServlet;
import org.tron.core.services.http.GetBlockServlet;
import org.tron.core.services.http.GetBrokerageServlet;
import org.tron.core.services.http.GetBurnTrxServlet;
import org.tron.core.services.http.GetCanDelegatedMaxSizeServlet;
import org.tron.core.services.http.GetCanWithdrawUnfreezeAmountServlet;
import org.tron.core.services.http.GetDelegatedResourceAccountIndexServlet;
import org.tron.core.services.http.GetDelegatedResourceAccountIndexV2Servlet;
import org.tron.core.services.http.GetDelegatedResourceServlet;
import org.tron.core.services.http.GetDelegatedResourceV2Servlet;
import org.tron.core.services.http.GetExchangeByIdServlet;
import org.tron.core.services.http.GetMarketOrderByAccountServlet;
import org.tron.core.services.http.GetMarketOrderByIdServlet;
import org.tron.core.services.http.GetMarketOrderListByPairServlet;
import org.tron.core.services.http.GetMarketPairListServlet;
import org.tron.core.services.http.GetMarketPriceByPairServlet;
import org.tron.core.services.http.GetMerkleTreeVoucherInfoServlet;
import org.tron.core.services.http.GetNodeInfoServlet;
import org.tron.core.services.http.GetNowBlockServlet;
import org.tron.core.services.http.GetPaginatedAssetIssueListServlet;
import org.tron.core.services.http.GetRewardServlet;
import org.tron.core.services.http.GetTransactionCountByBlockNumServlet;
import org.tron.core.services.http.GetTransactionInfoByBlockNumServlet;
import org.tron.core.services.http.IsShieldedTRC20ContractNoteSpentServlet;
import org.tron.core.services.http.IsSpendServlet;
import org.tron.core.services.http.ListExchangesServlet;
import org.tron.core.services.http.ListWitnessesServlet;
import org.tron.core.services.http.ScanAndMarkNoteByIvkServlet;
import org.tron.core.services.http.ScanNoteByIvkServlet;
import org.tron.core.services.http.ScanNoteByOvkServlet;
import org.tron.core.services.http.ScanShieldedTRC20NotesByIvkServlet;
import org.tron.core.services.http.ScanShieldedTRC20NotesByOvkServlet;
import org.tron.core.services.http.TriggerConstantContractServlet;
import org.tron.core.services.http.solidity.GetTransactionByIdSolidityServlet;
import org.tron.core.services.http.solidity.GetTransactionInfoByIdSolidityServlet;

@Component
public class SolidityNodeHttpApiService
implements Service {
    private static final Logger logger = LoggerFactory.getLogger((String)"API");
    private int port = Args.getInstance().getSolidityHttpPort();
    private Server server;
    @Autowired
    private GetAccountServlet getAccountServlet;
    @Autowired
    private GetTransactionByIdSolidityServlet getTransactionByIdServlet;
    @Autowired
    private GetTransactionInfoByIdSolidityServlet getTransactionInfoByIdServlet;
    @Autowired
    private GetTransactionCountByBlockNumServlet getTransactionCountByBlockNumServlet;
    @Autowired
    private GetDelegatedResourceServlet getDelegatedResourceServlet;
    @Autowired
    private GetDelegatedResourceV2Servlet getDelegatedResourceV2Servlet;
    @Autowired
    private GetCanDelegatedMaxSizeServlet getCanDelegatedMaxSizeServlet;
    @Autowired
    private GetAvailableUnfreezeCountServlet getAvailableUnfreezeCountServlet;
    @Autowired
    private GetCanWithdrawUnfreezeAmountServlet getCanWithdrawUnfreezeAmountServlet;
    @Autowired
    private GetDelegatedResourceAccountIndexServlet getDelegatedResourceAccountIndexServlet;
    @Autowired
    private GetDelegatedResourceAccountIndexV2Servlet getDelegatedResourceAccountIndexV2Servlet;
    @Autowired
    private GetExchangeByIdServlet getExchangeByIdServlet;
    @Autowired
    private ListExchangesServlet listExchangesServlet;
    @Autowired
    private ListWitnessesServlet listWitnessesServlet;
    @Autowired
    private GetAssetIssueListServlet getAssetIssueListServlet;
    @Autowired
    private GetPaginatedAssetIssueListServlet getPaginatedAssetIssueListServlet;
    @Autowired
    private GetAssetIssueByNameServlet getAssetIssueByNameServlet;
    @Autowired
    private GetAssetIssueByIdServlet getAssetIssueByIdServlet;
    @Autowired
    private GetAssetIssueListByNameServlet getAssetIssueListByNameServlet;
    @Autowired
    private GetNowBlockServlet getNowBlockServlet;
    @Autowired
    private GetBlockByNumServlet getBlockByNumServlet;
    @Autowired
    private GetNodeInfoServlet getNodeInfoServlet;
    @Autowired
    private GetAccountByIdServlet getAccountByIdServlet;
    @Autowired
    private GetBlockByIdServlet getBlockByIdServlet;
    @Autowired
    private GetBlockByLimitNextServlet getBlockByLimitNextServlet;
    @Autowired
    private GetBlockByLatestNumServlet getBlockByLatestNumServlet;
    @Autowired
    private ScanAndMarkNoteByIvkServlet scanAndMarkNoteByIvkServlet;
    @Autowired
    private ScanNoteByIvkServlet scanNoteByIvkServlet;
    @Autowired
    private ScanNoteByOvkServlet scanNoteByOvkServlet;
    @Autowired
    private GetMerkleTreeVoucherInfoServlet getMerkleTreeVoucherInfoServlet;
    @Autowired
    private IsSpendServlet isSpendServlet;
    @Autowired
    private ScanShieldedTRC20NotesByIvkServlet scanShieldedTRC20NotesByIvkServlet;
    @Autowired
    private ScanShieldedTRC20NotesByOvkServlet scanShieldedTRC20NotesByOvkServlet;
    @Autowired
    private IsShieldedTRC20ContractNoteSpentServlet isShieldedTRC20ContractNoteSpentServlet;
    @Autowired
    private GetMarketOrderByAccountServlet getMarketOrderByAccountServlet;
    @Autowired
    private GetMarketOrderByIdServlet getMarketOrderByIdServlet;
    @Autowired
    private GetMarketPriceByPairServlet getMarketPriceByPairServlet;
    @Autowired
    private GetMarketOrderListByPairServlet getMarketOrderListByPairServlet;
    @Autowired
    private GetMarketPairListServlet getMarketPairListServlet;
    @Autowired
    private GetBurnTrxServlet getBurnTrxServlet;
    @Autowired
    private GetBrokerageServlet getBrokerageServlet;
    @Autowired
    private GetRewardServlet getRewardServlet;
    @Autowired
    private TriggerConstantContractServlet triggerConstantContractServlet;
    @Autowired
    private EstimateEnergyServlet estimateEnergyServlet;
    @Autowired
    private GetTransactionInfoByBlockNumServlet getTransactionInfoByBlockNumServlet;
    @Autowired
    private HttpApiAccessFilter httpApiAccessFilter;
    @Autowired
    private GetBlockServlet getBlockServlet;

    @Override
    public void init() {
    }

    @Override
    public void init(CommonParameter args) {
        FullNodeHttpApiService.librustzcashInitZksnarkParams();
    }

    @Override
    public void start() {
        try {
            this.server = new Server(this.port);
            ServletContextHandler context = new ServletContextHandler(1);
            context.setContextPath("/");
            this.server.setHandler((Handler)context);
            context.addServlet(new ServletHolder((Servlet)this.getAccountServlet), "/walletsolidity/getaccount");
            context.addServlet(new ServletHolder((Servlet)this.listWitnessesServlet), "/walletsolidity/listwitnesses");
            context.addServlet(new ServletHolder((Servlet)this.getAssetIssueListServlet), "/walletsolidity/getassetissuelist");
            context.addServlet(new ServletHolder((Servlet)this.getPaginatedAssetIssueListServlet), "/walletsolidity/getpaginatedassetissuelist");
            context.addServlet(new ServletHolder((Servlet)this.getAssetIssueByNameServlet), "/walletsolidity/getassetissuebyname");
            context.addServlet(new ServletHolder((Servlet)this.getAssetIssueByIdServlet), "/walletsolidity/getassetissuebyid");
            context.addServlet(new ServletHolder((Servlet)this.getAssetIssueListByNameServlet), "/walletsolidity/getassetissuelistbyname");
            context.addServlet(new ServletHolder((Servlet)this.getNowBlockServlet), "/walletsolidity/getnowblock");
            context.addServlet(new ServletHolder((Servlet)this.getBlockByNumServlet), "/walletsolidity/getblockbynum");
            context.addServlet(new ServletHolder((Servlet)this.getDelegatedResourceServlet), "/walletsolidity/getdelegatedresource");
            context.addServlet(new ServletHolder((Servlet)this.getDelegatedResourceV2Servlet), "/walletsolidity/getdelegatedresourcev2");
            context.addServlet(new ServletHolder((Servlet)this.getCanDelegatedMaxSizeServlet), "/walletsolidity/getcandelegatedmaxsize");
            context.addServlet(new ServletHolder((Servlet)this.getAvailableUnfreezeCountServlet), "/walletsolidity/getavailableunfreezecount");
            context.addServlet(new ServletHolder((Servlet)this.getCanWithdrawUnfreezeAmountServlet), "/walletsolidity/getcanwithdrawunfreezeamount");
            context.addServlet(new ServletHolder((Servlet)this.getDelegatedResourceAccountIndexServlet), "/walletsolidity/getdelegatedresourceaccountindex");
            context.addServlet(new ServletHolder((Servlet)this.getDelegatedResourceAccountIndexV2Servlet), "/walletsolidity/getdelegatedresourceaccountindexv2");
            context.addServlet(new ServletHolder((Servlet)this.getExchangeByIdServlet), "/walletsolidity/getexchangebyid");
            context.addServlet(new ServletHolder((Servlet)this.listExchangesServlet), "/walletsolidity/listexchanges");
            context.addServlet(new ServletHolder((Servlet)this.getAccountByIdServlet), "/walletsolidity/getaccountbyid");
            context.addServlet(new ServletHolder((Servlet)this.getBlockByIdServlet), "/walletsolidity/getblockbyid");
            context.addServlet(new ServletHolder((Servlet)this.getBlockByLimitNextServlet), "/walletsolidity/getblockbylimitnext");
            context.addServlet(new ServletHolder((Servlet)this.getBlockByLatestNumServlet), "/walletsolidity/getblockbylatestnum");
            context.addServlet(new ServletHolder((Servlet)this.scanShieldedTRC20NotesByIvkServlet), "/walletsolidity/scanshieldedtrc20notesbyivk");
            context.addServlet(new ServletHolder((Servlet)this.scanShieldedTRC20NotesByOvkServlet), "/walletsolidity/scanshieldedtrc20notesbyovk");
            context.addServlet(new ServletHolder((Servlet)this.isShieldedTRC20ContractNoteSpentServlet), "/walletsolidity/isshieldedtrc20contractnotespent");
            context.addServlet(new ServletHolder((Servlet)this.getTransactionInfoByBlockNumServlet), "/walletsolidity/gettransactioninfobyblocknum");
            context.addServlet(new ServletHolder((Servlet)this.getMarketOrderByAccountServlet), "/walletsolidity/getmarketorderbyaccount");
            context.addServlet(new ServletHolder((Servlet)this.getMarketOrderByIdServlet), "/walletsolidity/getmarketorderbyid");
            context.addServlet(new ServletHolder((Servlet)this.getMarketPriceByPairServlet), "/walletsolidity/getmarketpricebypair");
            context.addServlet(new ServletHolder((Servlet)this.getMarketOrderListByPairServlet), "/walletsolidity/getmarketorderlistbypair");
            context.addServlet(new ServletHolder((Servlet)this.getMarketPairListServlet), "/walletsolidity/getmarketpairlist");
            context.addServlet(new ServletHolder((Servlet)this.getTransactionByIdServlet), "/walletsolidity/gettransactionbyid");
            context.addServlet(new ServletHolder((Servlet)this.getTransactionInfoByIdServlet), "/walletsolidity/gettransactioninfobyid");
            context.addServlet(new ServletHolder((Servlet)this.getTransactionCountByBlockNumServlet), "/walletsolidity/gettransactioncountbyblocknum");
            context.addServlet(new ServletHolder((Servlet)this.triggerConstantContractServlet), "/walletsolidity/triggerconstantcontract");
            context.addServlet(new ServletHolder((Servlet)this.estimateEnergyServlet), "/walletsolidity/estimateenergy");
            context.addServlet(new ServletHolder((Servlet)this.getNodeInfoServlet), "/wallet/getnodeinfo");
            context.addServlet(new ServletHolder((Servlet)this.getNodeInfoServlet), "/walletsolidity/getnodeinfo");
            context.addServlet(new ServletHolder((Servlet)this.getBrokerageServlet), "/walletsolidity/getBrokerage");
            context.addServlet(new ServletHolder((Servlet)this.getRewardServlet), "/walletsolidity/getReward");
            context.addServlet(new ServletHolder((Servlet)this.getBurnTrxServlet), "/walletsolidity/getburntrx");
            context.addServlet(new ServletHolder((Servlet)this.getBlockServlet), "/walletsolidity/getblock");
            context.addFilter(new FilterHolder((Filter)this.httpApiAccessFilter), "/walletsolidity/*", EnumSet.allOf(DispatcherType.class));
            context.getServletHandler().getFilterMappings()[0].setPathSpecs(new String[]{"/walletsolidity/*", "/wallet/getnodeinfo"});
            int maxHttpConnectNumber = Args.getInstance().getMaxHttpConnectNumber();
            if (maxHttpConnectNumber > 0) {
                this.server.addBean((Object)new ConnectionLimit(maxHttpConnectNumber, this.server));
            }
            this.server.start();
        }
        catch (Exception e) {
            logger.debug("IOException: {}", (Object)e.getMessage());
        }
    }

    @Override
    public void stop() {
        try {
            this.server.stop();
        }
        catch (Exception e) {
            logger.debug("Exception: {}", (Object)e.getMessage());
        }
    }
}

