/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.services.http;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.util.encoders.Hex;
import org.eclipse.jetty.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.api.GrpcAPI;
import org.tron.common.crypto.Hash;
import org.tron.common.parameter.CommonParameter;
import org.tron.common.utils.ByteArray;
import org.tron.common.utils.Commons;
import org.tron.common.utils.Sha256Hash;
import org.tron.core.actuator.TransactionFactory;
import org.tron.core.capsule.BlockCapsule;
import org.tron.core.capsule.TransactionCapsule;
import org.tron.core.config.args.Args;
import org.tron.core.db.TransactionTrace;
import org.tron.core.services.http.JsonFormat;
import org.tron.protos.Protocol;
import org.tron.protos.contract.SmartContractOuterClass;

public class Util {
    private static final Logger logger = LoggerFactory.getLogger((String)"API");
    public static final String PERMISSION_ID = "Permission_id";
    public static final String VISIBLE = "visible";
    public static final String TRANSACTION = "transaction";
    public static final String TRANSACTION_EXTENSION = "transactionExtension";
    public static final String VALUE = "value";
    public static final String CONTRACT_TYPE = "contractType";
    public static final String EXTRA_DATA = "extra_data";
    public static final String PARAMETER = "parameter";
    public static final String OWNER_ADDRESS = "owner_address";
    public static final String CONTRACT_ADDRESS = "contract_address";
    public static final String FUNCTION_SELECTOR = "function_selector";
    public static final String FUNCTION_PARAMETER = "parameter";
    public static final String CALL_DATA = "data";

    public static String printTransactionFee(String transactionFee) {
        JSONObject jsonObject = new JSONObject();
        JSONObject receipt = JSONObject.parseObject((String)transactionFee);
        jsonObject.put("Receipt", receipt.get((Object)"receipt"));
        return jsonObject.toJSONString();
    }

    public static String printErrorMsg(Exception e) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("Error", (Object)(e.getClass() + " : " + e.getMessage()));
        return jsonObject.toJSONString();
    }

    public static String printBlockList(GrpcAPI.BlockList list, boolean selfType) {
        List blocks = list.getBlockList();
        JSONObject jsonObject = JSONObject.parseObject((String)JsonFormat.printToString((Message)list, selfType));
        JSONArray jsonArray = new JSONArray();
        blocks.stream().forEach(block -> jsonArray.add((Object)Util.printBlockToJSON(block, selfType)));
        jsonObject.put("block", (Object)jsonArray);
        return jsonObject.toJSONString();
    }

    public static String printBlock(Protocol.Block block, boolean selfType) {
        return Util.printBlockToJSON(block, selfType).toJSONString();
    }

    public static JSONObject printBlockToJSON(Protocol.Block block, boolean selfType) {
        BlockCapsule blockCapsule = new BlockCapsule(block);
        String blockID = ByteArray.toHexString((byte[])blockCapsule.getBlockId().getBytes());
        JSONObject jsonObject = JSONObject.parseObject((String)JsonFormat.printToString((Message)block, selfType));
        jsonObject.put("blockID", (Object)blockID);
        if (!blockCapsule.getTransactions().isEmpty()) {
            jsonObject.put("transactions", (Object)Util.printTransactionListToJSON(blockCapsule.getTransactions(), selfType));
        }
        return jsonObject;
    }

    public static String printTransactionList(GrpcAPI.TransactionList list, boolean selfType) {
        List transactions = list.getTransactionList();
        JSONObject jsonObject = JSONObject.parseObject((String)JsonFormat.printToString((Message)list, selfType));
        JSONArray jsonArray = new JSONArray();
        transactions.stream().forEach(transaction -> jsonArray.add((Object)Util.printTransactionToJSON(transaction, selfType)));
        jsonObject.put(TRANSACTION, (Object)jsonArray);
        return jsonObject.toJSONString();
    }

    public static String printTransactionIdList(GrpcAPI.TransactionIdList list, boolean selfType) {
        JSONObject jsonObject = JSONObject.parseObject((String)JsonFormat.printToString((Message)list, selfType));
        return jsonObject.toJSONString();
    }

    public static JSONArray printTransactionListToJSON(List<TransactionCapsule> list, boolean selfType) {
        JSONArray transactions = new JSONArray();
        list.stream().forEach(transactionCapsule -> transactions.add((Object)Util.printTransactionToJSON(transactionCapsule.getInstance(), selfType)));
        return transactions;
    }

    public static String printTransaction(Protocol.Transaction transaction, boolean selfType) {
        return Util.printTransactionToJSON(transaction, selfType).toJSONString();
    }

    public static String printTransaction(Protocol.Transaction transaction) {
        return Util.printTransactionToJSON(transaction, true).toJSONString();
    }

    public static String printCreateTransaction(Protocol.Transaction transaction, boolean selfType) {
        JSONObject jsonObject = Util.printTransactionToJSON(transaction, selfType);
        jsonObject.put(VISIBLE, (Object)selfType);
        return jsonObject.toJSONString();
    }

    public static String printTransactionExtention(GrpcAPI.TransactionExtention transactionExtention, boolean selfType) {
        String string = JsonFormat.printToString((Message)transactionExtention, selfType);
        JSONObject jsonObject = JSONObject.parseObject((String)string);
        if (transactionExtention.getResult().getResult()) {
            JSONObject transactionObject = Util.printTransactionToJSON(transactionExtention.getTransaction(), selfType);
            transactionObject.put(VISIBLE, (Object)selfType);
            jsonObject.put(TRANSACTION, (Object)transactionObject);
        }
        return jsonObject.toJSONString();
    }

    public static String printEstimateEnergyMessage(GrpcAPI.EstimateEnergyMessage message, boolean selfType) {
        return JsonFormat.printToString((Message)message, selfType);
    }

    public static String printTransactionSignWeight(GrpcAPI.TransactionSignWeight transactionSignWeight, boolean selfType) {
        String string = JsonFormat.printToString((Message)transactionSignWeight, selfType);
        JSONObject jsonObject = JSONObject.parseObject((String)string);
        JSONObject jsonObjectExt = jsonObject.getJSONObject(TRANSACTION);
        jsonObjectExt.put(TRANSACTION, (Object)Util.printTransactionToJSON(transactionSignWeight.getTransaction().getTransaction(), selfType));
        jsonObject.put(TRANSACTION, (Object)jsonObjectExt);
        return jsonObject.toJSONString();
    }

    public static String printTransactionApprovedList(GrpcAPI.TransactionApprovedList transactionApprovedList, boolean selfType) {
        String string = JsonFormat.printToString((Message)transactionApprovedList, selfType);
        JSONObject jsonObject = JSONObject.parseObject((String)string);
        JSONObject jsonObjectExt = jsonObject.getJSONObject(TRANSACTION);
        jsonObjectExt.put(TRANSACTION, (Object)Util.printTransactionToJSON(transactionApprovedList.getTransaction().getTransaction(), selfType));
        jsonObject.put(TRANSACTION, (Object)jsonObjectExt);
        return jsonObject.toJSONString();
    }

    public static byte[] generateContractAddress(Protocol.Transaction trx, byte[] ownerAddress) {
        byte[] txRawDataHash = Sha256Hash.of((boolean)CommonParameter.getInstance().isECKeyCryptoEngine(), (byte[])trx.getRawData().toByteArray()).getBytes();
        byte[] combined = new byte[txRawDataHash.length + ownerAddress.length];
        System.arraycopy(txRawDataHash, 0, combined, 0, txRawDataHash.length);
        System.arraycopy(ownerAddress, 0, combined, txRawDataHash.length, ownerAddress.length);
        return Hash.sha3omit12((byte[])combined);
    }

    public static JSONObject printTransactionToJSON(Protocol.Transaction transaction, boolean selfType) {
        JSONObject jsonTransaction = JSONObject.parseObject((String)JsonFormat.printToString((Message)transaction, selfType));
        JSONArray contracts = new JSONArray();
        transaction.getRawData().getContractList().stream().forEach(contract -> {
            try {
                JSONObject contractJson = null;
                Any contractParameter = contract.getParameter();
                switch (contract.getType()) {
                    case CreateSmartContract: {
                        SmartContractOuterClass.CreateSmartContract deployContract = (SmartContractOuterClass.CreateSmartContract)contractParameter.unpack(SmartContractOuterClass.CreateSmartContract.class);
                        contractJson = JSONObject.parseObject((String)JsonFormat.printToString((Message)deployContract, selfType));
                        byte[] ownerAddress = deployContract.getOwnerAddress().toByteArray();
                        byte[] contractAddress = Util.generateContractAddress(transaction, ownerAddress);
                        jsonTransaction.put(CONTRACT_ADDRESS, (Object)ByteArray.toHexString((byte[])contractAddress));
                        break;
                    }
                    default: {
                        Class clazz = TransactionFactory.getContract((Protocol.Transaction.Contract.ContractType)contract.getType());
                        if (clazz == null) break;
                        contractJson = JSONObject.parseObject((String)JsonFormat.printToString(contractParameter.unpack(clazz), selfType));
                    }
                }
                JSONObject parameter = new JSONObject();
                parameter.put(VALUE, (Object)contractJson);
                parameter.put("type_url", (Object)contract.getParameterOrBuilder().getTypeUrl());
                JSONObject jsonContract = new JSONObject();
                jsonContract.put("parameter", (Object)parameter);
                jsonContract.put("type", (Object)contract.getType());
                if (contract.getPermissionId() > 0) {
                    jsonContract.put(PERMISSION_ID, (Object)contract.getPermissionId());
                }
                contracts.add((Object)jsonContract);
            }
            catch (InvalidProtocolBufferException e) {
                logger.debug("InvalidProtocolBufferException: {}", (Object)e.getMessage());
            }
        });
        JSONObject rawData = JSONObject.parseObject((String)jsonTransaction.get((Object)"raw_data").toString());
        rawData.put("contract", (Object)contracts);
        jsonTransaction.put("raw_data", (Object)rawData);
        String rawDataHex = ByteArray.toHexString((byte[])transaction.getRawData().toByteArray());
        jsonTransaction.put("raw_data_hex", (Object)rawDataHex);
        String txID = ByteArray.toHexString((byte[])Sha256Hash.hash((boolean)CommonParameter.getInstance().isECKeyCryptoEngine(), (byte[])transaction.getRawData().toByteArray()));
        jsonTransaction.put("txID", (Object)txID);
        return jsonTransaction;
    }

    public static Protocol.Transaction packTransaction(String strTransaction, boolean selfType) {
        JSONObject jsonTransaction = JSON.parseObject((String)strTransaction);
        JSONObject rawData = jsonTransaction.getJSONObject("raw_data");
        JSONArray contracts = new JSONArray();
        JSONArray rawContractArray = rawData.getJSONArray("contract");
        String contractType = null;
        for (int i = 0; i < rawContractArray.size(); ++i) {
            try {
                JSONObject contract = rawContractArray.getJSONObject(i);
                JSONObject parameter = contract.getJSONObject("parameter");
                contractType = contract.getString("type");
                if (StringUtils.isEmpty((CharSequence)contractType)) {
                    logger.debug("no type in the transaction, ignore");
                    continue;
                }
                Any any = null;
                Class clazz = TransactionFactory.getContract((Protocol.Transaction.Contract.ContractType)Protocol.Transaction.Contract.ContractType.valueOf((String)contractType));
                if (clazz != null) {
                    Constructor constructor = clazz.getDeclaredConstructor(new Class[0]);
                    constructor.setAccessible(true);
                    GeneratedMessageV3 generatedMessageV3 = (GeneratedMessageV3)constructor.newInstance(new Object[0]);
                    Message.Builder builder = generatedMessageV3.toBuilder();
                    JsonFormat.merge(parameter.getJSONObject(VALUE).toJSONString(), builder, selfType);
                    any = Any.pack((Message)builder.build());
                }
                if (any == null) continue;
                String value = ByteArray.toHexString((byte[])any.getValue().toByteArray());
                parameter.put(VALUE, (Object)value);
                contract.put("parameter", (Object)parameter);
                contracts.add((Object)contract);
                continue;
            }
            catch (IllegalArgumentException e) {
                logger.debug("invalid contractType: {}", contractType);
                continue;
            }
            catch (JsonFormat.ParseException e) {
                logger.debug("ParseException: {}", (Object)e.getMessage());
                continue;
            }
            catch (ClassCastException e) {
                logger.debug("ClassCastException: {}", (Object)e.getMessage());
                continue;
            }
            catch (JSONException e) {
                logger.debug("JSONException: {}", (Object)e.getMessage());
                continue;
            }
            catch (Exception e) {
                logger.warn("{}", contractType, (Object)e);
            }
        }
        rawData.put("contract", (Object)contracts);
        jsonTransaction.put("raw_data", (Object)rawData);
        Protocol.Transaction.Builder transactionBuilder = Protocol.Transaction.newBuilder();
        try {
            JsonFormat.merge(jsonTransaction.toJSONString(), (Message.Builder)transactionBuilder, selfType);
            return transactionBuilder.build();
        }
        catch (JsonFormat.ParseException e) {
            logger.debug("ParseException: {}", (Object)e.getMessage());
            return null;
        }
    }

    public static void checkBodySize(String body) throws Exception {
        CommonParameter parameter = Args.getInstance();
        if (body.getBytes().length > parameter.getMaxMessageSize()) {
            throw new Exception("body size is too big, the limit is " + parameter.getMaxMessageSize());
        }
    }

    public static boolean getVisible(HttpServletRequest request) {
        boolean visible = false;
        if (StringUtil.isNotBlank((String)request.getParameter(VISIBLE))) {
            visible = Boolean.valueOf(request.getParameter(VISIBLE));
        }
        return visible;
    }

    public static boolean getVisiblePost(String input) {
        JSONObject jsonObject;
        boolean visible = false;
        if (StringUtil.isNotBlank((String)input) && (jsonObject = JSON.parseObject((String)input)).containsKey((Object)VISIBLE)) {
            visible = jsonObject.getBoolean(VISIBLE);
        }
        return visible;
    }

    public static String getContractType(String input) {
        String contractType = null;
        JSONObject jsonObject = JSON.parseObject((String)input);
        if (jsonObject.containsKey((Object)CONTRACT_TYPE)) {
            contractType = jsonObject.getString(CONTRACT_TYPE);
        }
        return contractType;
    }

    public static String getHexAddress(String address) {
        if (address != null) {
            byte[] addressByte = Commons.decodeFromBase58Check((String)address);
            return ByteArray.toHexString((byte[])addressByte);
        }
        return null;
    }

    public static String getHexString(String string) {
        return ByteArray.toHexString((byte[])ByteString.copyFromUtf8((String)string).toByteArray());
    }

    public static Protocol.Transaction setTransactionPermissionId(JSONObject jsonObject, Protocol.Transaction transaction) {
        if (jsonObject.containsKey((Object)PERMISSION_ID)) {
            int permissionId = jsonObject.getInteger(PERMISSION_ID);
            return Util.setTransactionPermissionId(permissionId, transaction);
        }
        return transaction;
    }

    public static Protocol.Transaction setTransactionPermissionId(int permissionId, Protocol.Transaction transaction) {
        if (permissionId > 0) {
            Protocol.Transaction.raw.Builder raw2 = transaction.getRawData().toBuilder();
            Protocol.Transaction.Contract.Builder contract = raw2.getContract(0).toBuilder().setPermissionId(permissionId);
            raw2.clearContract();
            raw2.addContract(contract);
            return transaction.toBuilder().setRawData(raw2).build();
        }
        return transaction;
    }

    public static Protocol.Transaction setTransactionExtraData(JSONObject jsonObject, Protocol.Transaction transaction, boolean visible) {
        if (jsonObject.containsKey((Object)EXTRA_DATA)) {
            String data = jsonObject.getString(EXTRA_DATA);
            return Util.setTransactionExtraData(data, transaction, visible);
        }
        return transaction;
    }

    public static Protocol.Transaction setTransactionExtraData(String data, Protocol.Transaction transaction, boolean visible) {
        if (data.length() > 0) {
            Protocol.Transaction.raw.Builder raw2 = transaction.getRawData().toBuilder();
            if (visible) {
                raw2.setData(ByteString.copyFrom((byte[])data.getBytes()));
            } else {
                raw2.setData(ByteString.copyFrom((byte[])ByteArray.fromHexString((String)data)));
            }
            return transaction.toBuilder().setRawData(raw2).build();
        }
        return transaction;
    }

    public static boolean getVisibleOnlyForSign(JSONObject jsonObject) {
        boolean visible = false;
        if (jsonObject.containsKey((Object)VISIBLE)) {
            visible = jsonObject.getBoolean(VISIBLE);
        } else if (jsonObject.getJSONObject(TRANSACTION).containsKey((Object)VISIBLE)) {
            visible = jsonObject.getJSONObject(TRANSACTION).getBoolean(VISIBLE);
        }
        return visible;
    }

    public static String parseMethod(String methodSign, String input) {
        byte[] selector = new byte[4];
        System.arraycopy(Hash.sha3((byte[])methodSign.getBytes()), 0, selector, 0, 4);
        if (StringUtils.isEmpty((CharSequence)input)) {
            return Hex.toHexString((byte[])selector);
        }
        return Hex.toHexString((byte[])selector) + input;
    }

    public static long getJsonLongValue(JSONObject jsonObject, String key) {
        return Util.getJsonLongValue(jsonObject, key, false);
    }

    public static long getJsonLongValue(JSONObject jsonObject, String key, boolean required) {
        BigDecimal bigDecimal = jsonObject.getBigDecimal(key);
        if (required && bigDecimal == null) {
            throw new InvalidParameterException("key [" + key + "] does not exist");
        }
        return bigDecimal == null ? 0L : bigDecimal.longValueExact();
    }

    public static String getMemo(byte[] memo) {
        int index;
        for (index = memo.length; index > 0 && memo[index - 1] == 0; --index) {
        }
        byte[] inputCheck = new byte[index];
        System.arraycopy(memo, 0, inputCheck, 0, index);
        return new String(inputCheck, Charset.forName("UTF-8"));
    }

    public static void processError(Exception e, HttpServletResponse response) {
        logger.debug("Exception: {}", (Object)e.getMessage());
        try {
            response.getWriter().println(Util.printErrorMsg(e));
        }
        catch (IOException ioe) {
            logger.debug("IOException: {}", (Object)ioe.getMessage());
        }
    }

    public static String convertOutput(Protocol.Account account) {
        if (account.getAssetIssuedID().isEmpty()) {
            return JsonFormat.printToString((Message)account, false);
        }
        JSONObject accountJson = JSONObject.parseObject((String)JsonFormat.printToString((Message)account, false));
        String assetId = accountJson.get((Object)"asset_issued_ID").toString();
        accountJson.put("asset_issued_ID", (Object)ByteString.copyFrom((byte[])ByteArray.fromHexString((String)assetId)).toStringUtf8());
        return accountJson.toJSONString();
    }

    public static void printAccount(Protocol.Account reply, HttpServletResponse response, Boolean visible) throws IOException {
        if (reply != null) {
            if (visible.booleanValue()) {
                response.getWriter().println(JsonFormat.printToString((Message)reply, true));
            } else {
                response.getWriter().println(Util.convertOutput(reply));
            }
        } else {
            response.getWriter().println("{}");
        }
    }

    public static byte[] getAddress(HttpServletRequest request) throws Exception {
        byte[] address = null;
        String addressParam = "address";
        String addressStr = request.getParameter(addressParam);
        if (StringUtils.isBlank((CharSequence)addressStr)) {
            String input = request.getReader().lines().collect(Collectors.joining(System.lineSeparator()));
            Util.checkBodySize(input);
            JSONObject jsonObject = JSON.parseObject((String)input);
            if (jsonObject != null) {
                addressStr = jsonObject.getString(addressParam);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)addressStr)) {
            address = StringUtils.startsWith((CharSequence)addressStr, (CharSequence)"41") ? Hex.decode((String)addressStr) : Commons.decodeFromBase58Check((String)addressStr);
        }
        return address;
    }

    public static List<Protocol.TransactionInfo.Log> convertLogAddressToTronAddress(Protocol.TransactionInfo transactionInfo) {
        ArrayList<Protocol.TransactionInfo.Log> newLogList = new ArrayList<Protocol.TransactionInfo.Log>();
        for (Protocol.TransactionInfo.Log log : transactionInfo.getLogList()) {
            Protocol.TransactionInfo.Log.Builder logBuilder = Protocol.TransactionInfo.Log.newBuilder();
            logBuilder.setData(log.getData());
            logBuilder.addAllTopics((Iterable)log.getTopicsList());
            byte[] oldAddress = log.getAddress().toByteArray();
            if (oldAddress.length == 0 || oldAddress.length > 20) {
                logBuilder.setAddress(log.getAddress());
            } else {
                byte[] newAddress = new byte[20];
                int start = 20 - oldAddress.length;
                System.arraycopy(oldAddress, 0, newAddress, start, oldAddress.length);
                logBuilder.setAddress(ByteString.copyFrom((byte[])TransactionTrace.convertToTronAddress((byte[])newAddress)));
            }
            newLogList.add(logBuilder.build());
        }
        return newLogList;
    }

    public static void validateParameter(String contract) throws InvalidParameterException {
        JSONObject jsonObject = JSONObject.parseObject((String)contract);
        if (StringUtils.isEmpty((CharSequence)jsonObject.getString(OWNER_ADDRESS))) {
            throw new InvalidParameterException("owner_address isn't set.");
        }
        if (StringUtils.isEmpty((CharSequence)jsonObject.getString(CONTRACT_ADDRESS)) && StringUtils.isEmpty((CharSequence)jsonObject.getString(CALL_DATA))) {
            throw new InvalidParameterException("At least one of contract_address and data must be set.");
        }
        if (StringUtils.isEmpty((CharSequence)jsonObject.getString(CONTRACT_ADDRESS)) && !StringUtils.isEmpty((CharSequence)jsonObject.getString(FUNCTION_SELECTOR)) && !StringUtils.isEmpty((CharSequence)jsonObject.getString(CALL_DATA))) {
            throw new InvalidParameterException("While trying to deploy, function_selector and data can not be both set.");
        }
    }
}

