/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.services.http;

import com.google.common.base.Strings;
import io.prometheus.client.Histogram;
import java.io.IOException;
import java.lang.reflect.Constructor;
import javax.annotation.PostConstruct;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.tron.common.parameter.RateLimiterInitialization;
import org.tron.common.prometheus.Metrics;
import org.tron.core.config.args.Args;
import org.tron.core.services.http.Util;
import org.tron.core.services.ratelimiter.GlobalRateLimiter;
import org.tron.core.services.ratelimiter.RateLimiterContainer;
import org.tron.core.services.ratelimiter.RuntimeData;
import org.tron.core.services.ratelimiter.adapter.DefaultBaseQqsAdapter;
import org.tron.core.services.ratelimiter.adapter.GlobalPreemptibleAdapter;
import org.tron.core.services.ratelimiter.adapter.IPQPSRateLimiterAdapter;
import org.tron.core.services.ratelimiter.adapter.IPreemptibleRateLimiter;
import org.tron.core.services.ratelimiter.adapter.IRateLimiter;
import org.tron.core.services.ratelimiter.adapter.QpsRateLimiterAdapter;

public abstract class RateLimiterServlet
extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(RateLimiterServlet.class);
    private static final String KEY_PREFIX_HTTP = "http_";
    private static final String ADAPTER_PREFIX = "org.tron.core.services.ratelimiter.adapter.";
    @Autowired
    private RateLimiterContainer container;

    @PostConstruct
    private void addRateContainer() {
        RateLimiterInitialization.HttpRateLimiterItem item = (RateLimiterInitialization.HttpRateLimiterItem)Args.getInstance().getRateLimiterInitialization().getHttpMap().get(((Object)((Object)this)).getClass().getSimpleName());
        boolean success = false;
        if (item != null) {
            String cName = "";
            String params = "";
            try {
                cName = item.getStrategy();
                params = item.getParams();
                Class<?> c = Class.forName(ADAPTER_PREFIX + cName);
                if (c == GlobalPreemptibleAdapter.class || c == QpsRateLimiterAdapter.class || c == IPQPSRateLimiterAdapter.class) {
                    Constructor<?> constructor = c.getConstructor(String.class);
                    Object obj = constructor.newInstance(params);
                    this.container.add(KEY_PREFIX_HTTP, ((Object)((Object)this)).getClass().getSimpleName(), (IRateLimiter)obj);
                } else {
                    Constructor<?> constructor = c.getConstructor(new Class[0]);
                    Object obj = constructor.newInstance(new Object[0]);
                    this.container.add(KEY_PREFIX_HTTP, ((Object)((Object)this)).getClass().getSimpleName(), (IRateLimiter)obj);
                }
                success = true;
            }
            catch (Exception e) {
                logger.warn("failure to add the rate limiter strategy. servlet = {}, strategy name = {}, params = \"{}\".", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), cName, params});
            }
        }
        if (!success) {
            try {
                DefaultBaseQqsAdapter rateLimiter = new DefaultBaseQqsAdapter("qps=1000");
                this.container.add(KEY_PREFIX_HTTP, ((Object)((Object)this)).getClass().getSimpleName(), rateLimiter);
            }
            catch (Exception e) {
                logger.warn("failure to add the default rate limiter strategy. servlet = {}.", (Object)((Object)((Object)this)).getClass().getSimpleName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        RuntimeData runtimeData = new RuntimeData(req);
        GlobalRateLimiter.acquire(runtimeData);
        IRateLimiter rateLimiter = this.container.get(KEY_PREFIX_HTTP, ((Object)((Object)this)).getClass().getSimpleName());
        boolean acquireResource = true;
        if (rateLimiter != null) {
            acquireResource = rateLimiter.acquire(runtimeData);
        }
        String url = Strings.isNullOrEmpty((String)req.getRequestURI()) ? "undefined" : req.getRequestURI();
        try {
            resp.setContentType("application/json; charset=utf-8");
            if (acquireResource) {
                Histogram.Timer requestTimer = Metrics.histogramStartTimer((String)"tron:http_service_latency_seconds", (String[])new String[]{url});
                super.service(req, resp);
                Metrics.histogramObserve((Histogram.Timer)requestTimer);
            } else {
                resp.getWriter().println(Util.printErrorMsg(new IllegalAccessException("lack of computing resources")));
            }
        }
        catch (IOException | ServletException e) {
            throw e;
        }
        catch (Exception unexpected) {
            logger.error("Http Api {}, Method:{}. Error\uff1a", new Object[]{url, req.getMethod(), unexpected});
        }
        finally {
            if (rateLimiter instanceof IPreemptibleRateLimiter && acquireResource) {
                ((IPreemptibleRateLimiter)rateLimiter).release();
            }
        }
    }
}

