/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.services.http;

import com.alibaba.fastjson.JSONObject;
import com.google.protobuf.Message;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.core.Wallet;
import org.tron.core.services.http.JsonFormat;
import org.tron.core.services.http.RateLimiterServlet;
import org.tron.core.services.http.Util;
import org.tron.protos.Protocol;
import org.tron.protos.contract.MarketContract;

@Component
public class MarketSellAssetServlet
extends RateLimiterServlet {
    private static final Logger logger = LoggerFactory.getLogger((String)"API");
    @Autowired
    private Wallet wallet;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        try {
            String contract = request.getReader().lines().collect(Collectors.joining(System.lineSeparator()));
            Util.checkBodySize(contract);
            boolean visible = Util.getVisiblePost(contract);
            MarketContract.MarketSellAssetContract.Builder build = MarketContract.MarketSellAssetContract.newBuilder();
            JsonFormat.merge(contract, (Message.Builder)build, visible);
            Protocol.Transaction tx = this.wallet.createTransactionCapsule((Message)build.build(), Protocol.Transaction.Contract.ContractType.MarketSellAssetContract).getInstance();
            JSONObject jsonObject = JSONObject.parseObject((String)contract);
            tx = Util.setTransactionPermissionId(jsonObject, tx);
            tx = Util.setTransactionExtraData(jsonObject, tx, visible);
            response.getWriter().println(Util.printCreateTransaction(tx, visible));
        }
        catch (Exception e) {
            Util.processError(e, response);
        }
    }
}

