/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.services.http;

import com.google.protobuf.Message;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.api.GrpcAPI;
import org.tron.common.utils.ByteArray;
import org.tron.core.capsule.TransactionCapsule;
import org.tron.core.db.Manager;
import org.tron.core.services.http.JsonFormat;
import org.tron.core.services.http.PostParams;
import org.tron.core.services.http.RateLimiterServlet;
import org.tron.core.services.http.Util;

@Component
public class GetTransactionFromPendingServlet
extends RateLimiterServlet {
    private static final Logger logger = LoggerFactory.getLogger((String)"API");
    @Autowired
    private Manager manager;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        try {
            boolean visible = Util.getVisible(request);
            String input = request.getParameter("value");
            TransactionCapsule reply = this.manager.getTxFromPending(input);
            if (reply != null) {
                response.getWriter().println(Util.printTransaction(reply.getInstance(), visible));
            } else {
                response.getWriter().println("{}");
            }
        }
        catch (Exception e) {
            Util.processError(e, response);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        try {
            PostParams params = PostParams.getPostParams(request);
            GrpcAPI.BytesMessage.Builder build = GrpcAPI.BytesMessage.newBuilder();
            JsonFormat.merge(params.getParams(), (Message.Builder)build, params.isVisible());
            TransactionCapsule reply = this.manager.getTxFromPending(ByteArray.toHexString((byte[])build.getValue().toByteArray()));
            if (reply != null) {
                response.getWriter().println(Util.printTransaction(reply.getInstance(), params.isVisible()));
            } else {
                response.getWriter().println("{}");
            }
        }
        catch (Exception e) {
            Util.processError(e, response);
        }
    }
}

