/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.services.http;

import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.api.GrpcAPI;
import org.tron.common.utils.ByteArray;
import org.tron.core.Wallet;
import org.tron.core.services.http.JsonFormat;
import org.tron.core.services.http.PostParams;
import org.tron.core.services.http.RateLimiterServlet;
import org.tron.core.services.http.Util;
import org.tron.protos.Protocol;

@Component
public class GetTransactionByIdServlet
extends RateLimiterServlet {
    private static final Logger logger = LoggerFactory.getLogger((String)"API");
    @Autowired
    private Wallet wallet;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        try {
            boolean visible = Util.getVisible(request);
            String input = request.getParameter("value");
            this.fillResponse(ByteString.copyFrom((byte[])ByteArray.fromHexString((String)input)), visible, response);
        }
        catch (Exception e) {
            Util.processError(e, response);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        try {
            PostParams params = PostParams.getPostParams(request);
            GrpcAPI.BytesMessage.Builder build = GrpcAPI.BytesMessage.newBuilder();
            JsonFormat.merge(params.getParams(), (Message.Builder)build, params.isVisible());
            this.fillResponse(build.getValue(), params.isVisible(), response);
        }
        catch (Exception e) {
            Util.processError(e, response);
        }
    }

    private void fillResponse(ByteString txId, boolean visible, HttpServletResponse response) throws IOException {
        Protocol.Transaction reply = this.wallet.getTransactionById(txId);
        if (reply != null) {
            response.getWriter().println(Util.printTransaction(reply, visible));
        } else {
            response.getWriter().println("{}");
        }
    }
}

