/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.services.http;

import com.google.protobuf.Message;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.api.GrpcAPI;
import org.tron.core.Wallet;
import org.tron.core.services.http.JsonFormat;
import org.tron.core.services.http.PostParams;
import org.tron.core.services.http.RateLimiterServlet;
import org.tron.core.services.http.Util;

@Component
public class GetPaginatedAssetIssueListServlet
extends RateLimiterServlet {
    private static final Logger logger = LoggerFactory.getLogger((String)"API");
    @Autowired
    private Wallet wallet;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        try {
            boolean visible = Util.getVisible(request);
            long offset = Long.parseLong(request.getParameter("offset"));
            long limit = Long.parseLong(request.getParameter("limit"));
            this.fillResponse(offset, limit, visible, response);
        }
        catch (Exception e) {
            Util.processError(e, response);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        try {
            PostParams params = PostParams.getPostParams(request);
            String input = params.getParams();
            boolean visible = params.isVisible();
            GrpcAPI.PaginatedMessage.Builder build = GrpcAPI.PaginatedMessage.newBuilder();
            JsonFormat.merge(input, (Message.Builder)build, visible);
            this.fillResponse(build.getOffset(), build.getLimit(), visible, response);
        }
        catch (Exception e) {
            Util.processError(e, response);
        }
    }

    private void fillResponse(long offset, long limit, boolean visible, HttpServletResponse response) throws IOException {
        GrpcAPI.AssetIssueList reply = this.wallet.getAssetIssueList(offset, limit);
        if (reply != null) {
            response.getWriter().println(JsonFormat.printToString((Message)reply, visible));
        } else {
            response.getWriter().println("{}");
        }
    }
}

