/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.services.http;

import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.api.GrpcAPI;
import org.tron.common.utils.ByteArray;
import org.tron.core.Wallet;
import org.tron.core.services.http.JsonFormat;
import org.tron.core.services.http.PostParams;
import org.tron.core.services.http.RateLimiterServlet;
import org.tron.core.services.http.Util;

@Component
public class GetDelegatedResourceV2Servlet
extends RateLimiterServlet {
    private static final Logger logger = LoggerFactory.getLogger((String)"API");
    @Autowired
    private Wallet wallet;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        try {
            boolean visible = Util.getVisible(request);
            String fromAddress = request.getParameter("fromAddress");
            String toAddress = request.getParameter("toAddress");
            if (visible) {
                fromAddress = Util.getHexAddress(fromAddress);
                toAddress = Util.getHexAddress(toAddress);
            }
            this.fillResponse(visible, ByteString.copyFrom((byte[])ByteArray.fromHexString((String)fromAddress)), ByteString.copyFrom((byte[])ByteArray.fromHexString((String)toAddress)), response);
        }
        catch (Exception e) {
            Util.processError(e, response);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        try {
            PostParams params = PostParams.getPostParams(request);
            GrpcAPI.DelegatedResourceMessage.Builder build = GrpcAPI.DelegatedResourceMessage.newBuilder();
            JsonFormat.merge(params.getParams(), (Message.Builder)build, params.isVisible());
            this.fillResponse(params.isVisible(), build.getFromAddress(), build.getToAddress(), response);
        }
        catch (Exception e) {
            Util.processError(e, response);
        }
    }

    private void fillResponse(boolean visible, ByteString fromAddress, ByteString toAddress, HttpServletResponse response) throws IOException {
        GrpcAPI.DelegatedResourceList reply = this.wallet.getDelegatedResourceV2(fromAddress, toAddress);
        if (reply != null) {
            response.getWriter().println(JsonFormat.printToString((Message)reply, visible));
        } else {
            response.getWriter().println("{}");
        }
    }
}

