/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.services.http;

import com.alibaba.fastjson.JSONObject;
import com.google.protobuf.Message;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.core.Wallet;
import org.tron.core.services.http.JsonFormat;
import org.tron.core.services.http.PostParams;
import org.tron.core.services.http.RateLimiterServlet;
import org.tron.core.services.http.Util;
import org.tron.protos.Protocol;
import org.tron.protos.contract.ExchangeContract;

@Component
public class ExchangeCreateServlet
extends RateLimiterServlet {
    private static final Logger logger = LoggerFactory.getLogger((String)"API");
    @Autowired
    private Wallet wallet;

    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        try {
            PostParams params = PostParams.getPostParams(request);
            ExchangeContract.ExchangeCreateContract.Builder build = ExchangeContract.ExchangeCreateContract.newBuilder();
            JsonFormat.merge(params.getParams(), (Message.Builder)build, params.isVisible());
            Protocol.Transaction tx = this.wallet.createTransactionCapsule((Message)build.build(), Protocol.Transaction.Contract.ContractType.ExchangeCreateContract).getInstance();
            JSONObject jsonObject = JSONObject.parseObject((String)params.getParams());
            tx = Util.setTransactionPermissionId(jsonObject, tx);
            response.getWriter().println(Util.printCreateTransaction(tx, params.isVisible()));
        }
        catch (Exception e) {
            Util.processError(e, response);
        }
    }
}

