/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.services.http;

import com.alibaba.fastjson.JSONObject;
import com.google.protobuf.Message;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.api.GrpcAPI;
import org.tron.common.utils.ByteArray;
import org.tron.core.Wallet;
import org.tron.core.capsule.TransactionCapsule;
import org.tron.core.services.http.JsonFormat;
import org.tron.core.services.http.RateLimiterServlet;
import org.tron.core.services.http.Util;
import org.tron.protos.Protocol;

@Component
public class BroadcastHexServlet
extends RateLimiterServlet {
    private static final Logger logger = LoggerFactory.getLogger((String)"API");
    @Autowired
    private Wallet wallet;

    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        try {
            String input = request.getReader().lines().collect(Collectors.joining(System.lineSeparator()));
            String trx = JSONObject.parseObject((String)input).getString("transaction");
            Protocol.Transaction transaction = Protocol.Transaction.parseFrom((byte[])ByteArray.fromHexString((String)trx));
            TransactionCapsule transactionCapsule = new TransactionCapsule(transaction);
            String transactionID = ByteArray.toHexString((byte[])transactionCapsule.getTransactionId().getBytes());
            GrpcAPI.Return result = this.wallet.broadcastTransaction(transaction);
            JSONObject json = new JSONObject();
            json.put("result", (Object)result.getResult());
            json.put("code", (Object)result.getCode().toString());
            json.put("message", (Object)result.getMessage().toStringUtf8());
            json.put("transaction", (Object)JsonFormat.printToString((Message)transaction, true));
            json.put("txid", (Object)transactionID);
            response.getWriter().println(json.toJSONString());
        }
        catch (Exception e) {
            Util.processError(e, response);
        }
    }
}

