/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.services.filter;

import com.google.common.base.Strings;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.prometheus.Metrics;
import org.tron.core.metrics.MetricsUtil;
import org.tron.core.services.filter.CharResponseWrapper;

public class HttpInterceptor
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger((String)"httpInterceptor");
    private String endpoint;
    private final int HTTP_NOT_FOUND = 404;
    private final int HTTP_SUCCESS = 200;

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) {
        try {
            if (request instanceof HttpServletRequest) {
                this.endpoint = ((HttpServletRequest)request).getRequestURI();
                CharResponseWrapper responseWrapper = new CharResponseWrapper((HttpServletResponse)response);
                chain.doFilter(request, (ServletResponse)responseWrapper);
                HttpServletResponse resp = (HttpServletResponse)response;
                if (resp.getStatus() != 404) {
                    String endpointQPS = "net.api.detail.qps." + this.endpoint;
                    MetricsUtil.meterMark("net.api.qps");
                    MetricsUtil.meterMark(endpointQPS);
                    int reposeContentSize = responseWrapper.getByteSize();
                    String endpointOutTraffic = "net.api.detail.outTraffic." + this.endpoint;
                    MetricsUtil.meterMark("net.api.outTraffic", reposeContentSize);
                    MetricsUtil.meterMark(endpointOutTraffic, reposeContentSize);
                    if (resp.getStatus() != 200) {
                        String endpointFailQPS = "net.api.detail.failQps." + this.endpoint;
                        MetricsUtil.meterMark("net.api.failQps");
                        MetricsUtil.meterMark(endpointFailQPS);
                    }
                } else {
                    MetricsUtil.meterMark("net.api.qps");
                    MetricsUtil.meterMark("net.api.failQps");
                }
                Metrics.histogramObserve((String)"tron:http_bytes", (double)responseWrapper.getByteSize(), (String[])new String[]{Strings.isNullOrEmpty((String)this.endpoint) ? "undefined" : this.endpoint, String.valueOf(responseWrapper.getStatus())});
            } else {
                chain.doFilter(request, response);
            }
        }
        catch (Exception e) {
            if (MetricsUtil.getMeters("net.api.detail.qps.").containsKey("net.api.detail.qps." + this.endpoint)) {
                MetricsUtil.meterMark("net.api.detail.failQps." + this.endpoint, 1L);
                MetricsUtil.meterMark("net.api.detail.qps." + this.endpoint, 1L);
            }
            MetricsUtil.meterMark("net.api.qps", 1L);
            MetricsUtil.meterMark("net.api.failQps", 1L);
        }
    }

    public void destroy() {
    }
}

