/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.net.service.effective;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.net.InetSocketAddress;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.core.config.args.Args;
import org.tron.core.net.TronNetDelegate;
import org.tron.core.net.TronNetService;
import org.tron.core.net.peer.PeerConnection;
import org.tron.p2p.discover.Node;
import org.tron.protos.Protocol;

@Component
public class EffectiveCheckService {
    private static final Logger logger = LoggerFactory.getLogger((String)"net");
    private final boolean isEffectiveCheck = Args.getInstance().isNodeEffectiveCheckEnable();
    @Autowired
    private TronNetDelegate tronNetDelegate;
    private final Cache<InetSocketAddress, Boolean> nodesCache = CacheBuilder.newBuilder().initialCapacity(100).maximumSize(10000L).expireAfterWrite(20L, TimeUnit.MINUTES).build();
    private volatile InetSocketAddress cur;
    private final AtomicInteger count = new AtomicInteger(0);
    private ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("effective-thread-%d").build());
    private long MAX_HANDSHAKE_TIME = 60000L;

    public void init() {
        if (this.isEffectiveCheck) {
            this.executor.scheduleWithFixedDelay(() -> {
                try {
                    this.findEffectiveNode();
                }
                catch (Exception e) {
                    logger.error("Check effective connection processing failed", (Throwable)e);
                }
            }, 60L, 5L, TimeUnit.SECONDS);
        } else {
            logger.info("EffectiveCheckService is disabled");
        }
    }

    public void triggerNext() {
        try {
            this.executor.submit(this::findEffectiveNode);
        }
        catch (Exception e) {
            logger.warn("Submit effective service task failed, message:{}", (Object)e.getMessage());
        }
    }

    public void close() {
        if (this.executor != null) {
            try {
                this.executor.shutdown();
            }
            catch (Exception e) {
                logger.error("Exception in shutdown effective service worker, {}", (Object)e.getMessage());
            }
        }
    }

    public boolean isIsolateLand() {
        return (int)this.tronNetDelegate.getActivePeer().stream().filter(PeerConnection::isNeedSyncFromUs).count() == this.tronNetDelegate.getActivePeer().size();
    }

    private void findEffectiveNode() {
        if (!this.isIsolateLand()) {
            if (this.count.get() > 0) {
                logger.info("Success to verify effective node {}", (Object)this.cur);
                this.resetCount();
            }
            return;
        }
        if (this.cur != null) {
            this.tronNetDelegate.getActivePeer().forEach(p -> {
                if (p.getInetSocketAddress().equals(this.cur) && System.currentTimeMillis() - p.getChannel().getStartTime() >= this.MAX_HANDSHAKE_TIME) {
                    logger.info("Disconnect with {}", (Object)this.cur);
                    p.disconnect(Protocol.ReasonCode.BELOW_THAN_ME);
                }
            });
            logger.info("Thread is running");
            return;
        }
        List tableNodes = TronNetService.getP2pService().getConnectableNodes();
        tableNodes.sort(Comparator.comparingLong(node -> -node.getUpdateTime()));
        HashSet usedAddressSet = new HashSet();
        this.tronNetDelegate.getActivePeer().forEach(p -> usedAddressSet.add(p.getInetSocketAddress()));
        Optional<Node> chosenNode = tableNodes.stream().filter(node -> this.nodesCache.getIfPresent((Object)node.getPreferInetSocketAddress()) == null).filter(node -> !usedAddressSet.contains(node.getPreferInetSocketAddress())).filter(node -> !TronNetService.getP2pConfig().getActiveNodes().contains(node.getPreferInetSocketAddress())).findFirst();
        if (!chosenNode.isPresent()) {
            logger.warn("No available node to choose");
            return;
        }
        this.count.incrementAndGet();
        this.nodesCache.put((Object)chosenNode.get().getPreferInetSocketAddress(), (Object)true);
        this.cur = new InetSocketAddress(chosenNode.get().getPreferInetSocketAddress().getAddress(), chosenNode.get().getPreferInetSocketAddress().getPort());
        logger.info("Try to get effective connection by using {} at seq {}", (Object)this.cur, (Object)this.count.get());
        TronNetService.getP2pService().connect(chosenNode.get(), future -> {
            if (future.isCancelled()) {
                this.cur = null;
            } else if (!future.isSuccess()) {
                logger.warn("Connect to chosen peer {} fail, cause:{}", (Object)this.cur, (Object)future.cause().getMessage());
                future.channel().close();
                this.cur = null;
                this.triggerNext();
            }
        });
    }

    private void resetCount() {
        this.count.set(0);
    }

    public void onDisconnect(InetSocketAddress inetSocketAddress) {
        if (inetSocketAddress.equals(this.cur)) {
            logger.warn("Close chosen peer: {}", (Object)this.cur);
            this.cur = null;
            this.triggerNext();
        }
    }

    public boolean isEffectiveCheck() {
        return this.isEffectiveCheck;
    }

    public InetSocketAddress getCur() {
        return this.cur;
    }

    public void setCur(InetSocketAddress cur) {
        this.cur = cur;
    }
}

