/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.net.messagehandler;

import com.google.common.collect.Sets;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import io.netty.util.internal.ConcurrentSet;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.tron.common.crypto.ECKey;
import org.tron.common.utils.ByteArray;
import org.tron.common.utils.Sha256Hash;
import org.tron.consensus.base.Param;
import org.tron.core.ChainBaseManager;
import org.tron.core.capsule.BlockCapsule;
import org.tron.core.capsule.TransactionCapsule;
import org.tron.core.db.PbftSignDataStore;
import org.tron.core.exception.P2pException;
import org.tron.core.net.message.TronMessage;
import org.tron.core.net.message.pbft.PbftCommitMessage;
import org.tron.core.net.messagehandler.TronMsgHandler;
import org.tron.core.net.peer.PeerConnection;
import org.tron.protos.Protocol;

@Service
public class PbftDataSyncHandler
implements TronMsgHandler {
    private static final Logger logger = LoggerFactory.getLogger((String)"pbft-data-sync");
    private Map<Long, PbftCommitMessage> pbftCommitMessageCache = new ConcurrentHashMap<Long, PbftCommitMessage>();
    private ExecutorService executorService = Executors.newFixedThreadPool(19, r -> new Thread(r, "valid-header-pbft-sign"));
    @Autowired
    private ChainBaseManager chainBaseManager;

    @Override
    public void processMessage(PeerConnection peer, TronMessage msg) throws P2pException {
        PbftCommitMessage pbftCommitMessage = (PbftCommitMessage)msg;
        try {
            Protocol.PBFTMessage.Raw raw2 = Protocol.PBFTMessage.Raw.parseFrom((ByteString)pbftCommitMessage.getPBFTCommitResult().getData());
            this.pbftCommitMessageCache.put(raw2.getViewN(), pbftCommitMessage);
        }
        catch (InvalidProtocolBufferException e) {
            logger.error("", (Throwable)e);
        }
    }

    public void processPBFTCommitData(BlockCapsule block) {
        try {
            if (!this.chainBaseManager.getDynamicPropertiesStore().allowPBFT()) {
                return;
            }
            long epoch = 0L;
            PbftCommitMessage pbftCommitMessage = this.pbftCommitMessageCache.remove(block.getNum());
            long maintenanceTimeInterval = this.chainBaseManager.getDynamicPropertiesStore().getMaintenanceTimeInterval();
            if (pbftCommitMessage == null) {
                long round = block.getTimeStamp() / maintenanceTimeInterval;
                epoch = (round + 1L) * maintenanceTimeInterval;
            } else {
                this.processPBFTCommitMessage(pbftCommitMessage);
                Protocol.PBFTMessage.Raw raw2 = Protocol.PBFTMessage.Raw.parseFrom((ByteString)pbftCommitMessage.getPBFTCommitResult().getData());
                epoch = raw2.getEpoch();
            }
            pbftCommitMessage = this.pbftCommitMessageCache.remove(epoch);
            if (pbftCommitMessage != null) {
                this.processPBFTCommitMessage(pbftCommitMessage);
            }
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
    }

    private void processPBFTCommitMessage(PbftCommitMessage pbftCommitMessage) {
        try {
            PbftSignDataStore pbftSignDataStore = this.chainBaseManager.getPbftSignDataStore();
            Protocol.PBFTMessage.Raw raw2 = Protocol.PBFTMessage.Raw.parseFrom((ByteString)pbftCommitMessage.getPBFTCommitResult().getData());
            if (!this.validPbftSign(raw2, pbftCommitMessage.getPBFTCommitResult().getSignatureList(), this.chainBaseManager.getWitnesses())) {
                return;
            }
            if (raw2.getDataType() == Protocol.PBFTMessage.DataType.BLOCK && pbftSignDataStore.getBlockSignData(raw2.getViewN()) == null) {
                pbftSignDataStore.putBlockSignData(raw2.getViewN(), pbftCommitMessage.getPbftSignCapsule());
                logger.info("Save the block {} pbft commit data", (Object)raw2.getViewN());
            } else if (raw2.getDataType() == Protocol.PBFTMessage.DataType.SRL && pbftSignDataStore.getSrSignData(raw2.getEpoch()) == null) {
                pbftSignDataStore.putSrSignData(raw2.getEpoch(), pbftCommitMessage.getPbftSignCapsule());
                logger.info("Save the srl {} pbft commit data", (Object)raw2.getEpoch());
            }
        }
        catch (InvalidProtocolBufferException e) {
            logger.error("", (Throwable)e);
        }
    }

    private boolean validPbftSign(Protocol.PBFTMessage.Raw raw2, List<ByteString> srSignList, List<ByteString> currentSrList) {
        if (srSignList.size() != 0) {
            ConcurrentSet srSignSet = new ConcurrentSet();
            srSignSet.addAll(srSignList);
            if (srSignSet.size() < Param.getInstance().getAgreeNodeCount()) {
                logger.error("sr sign count {} < sr count * 2/3 + 1 == {}", (Object)srSignSet.size(), (Object)Param.getInstance().getAgreeNodeCount());
                return false;
            }
            byte[] dataHash = Sha256Hash.hash((boolean)true, (byte[])raw2.toByteArray());
            HashSet srSet = Sets.newHashSet(currentSrList);
            ArrayList<Future<Boolean>> futureList = new ArrayList<Future<Boolean>>();
            for (ByteString byteString : srSignList) {
                futureList.add(this.executorService.submit(new ValidPbftSignTask(raw2.getViewN(), (Set<ByteString>)srSignSet, dataHash, srSet, byteString)));
            }
            for (Future future : futureList) {
                try {
                    if (((Boolean)future.get()).booleanValue()) continue;
                    return false;
                }
                catch (Exception e) {
                    logger.error("", (Throwable)e);
                }
            }
            if (srSignSet.size() != 0) {
                return false;
            }
        }
        return true;
    }

    private class ValidPbftSignTask
    implements Callable<Boolean> {
        private long viewN;
        private Set<ByteString> srSignSet;
        private byte[] dataHash;
        private Set<ByteString> srSet;
        private ByteString sign;

        ValidPbftSignTask(long viewN, Set<ByteString> srSignSet, byte[] dataHash, Set<ByteString> srSet, ByteString sign) {
            this.viewN = viewN;
            this.srSignSet = srSignSet;
            this.dataHash = dataHash;
            this.srSet = srSet;
            this.sign = sign;
        }

        @Override
        public Boolean call() throws Exception {
            try {
                byte[] srAddress = ECKey.signatureToAddress((byte[])this.dataHash, (String)TransactionCapsule.getBase64FromByteString((ByteString)this.sign));
                if (!this.srSet.contains(ByteString.copyFrom((byte[])srAddress))) {
                    logger.error("valid sr signature fail,error sr address:{}", (Object)ByteArray.toHexString((byte[])srAddress));
                    return false;
                }
                this.srSignSet.remove(this.sign);
            }
            catch (SignatureException e) {
                logger.error("viewN {} valid sr list sign fail!", (Object)this.viewN, (Object)e);
                return false;
            }
            return true;
        }
    }
}

