/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.net.message.adv;

import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.tron.common.utils.Sha256Hash;
import org.tron.core.net.message.MessageTypes;
import org.tron.core.net.message.TronMessage;
import org.tron.protos.Protocol;

public class InventoryMessage
extends TronMessage {
    protected Protocol.Inventory inv;

    public InventoryMessage(byte[] data) throws Exception {
        super(data);
        this.type = MessageTypes.INVENTORY.asByte();
        this.inv = Protocol.Inventory.parseFrom((byte[])data);
    }

    public InventoryMessage(Protocol.Inventory inv) {
        this.inv = inv;
        this.type = MessageTypes.INVENTORY.asByte();
        this.data = inv.toByteArray();
    }

    public InventoryMessage(List<Sha256Hash> hashList, Protocol.Inventory.InventoryType type) {
        Protocol.Inventory.Builder invBuilder = Protocol.Inventory.newBuilder();
        for (Sha256Hash hash : hashList) {
            invBuilder.addIds(hash.getByteString());
        }
        invBuilder.setType(type);
        this.inv = invBuilder.build();
        this.type = MessageTypes.INVENTORY.asByte();
        this.data = this.inv.toByteArray();
    }

    public Class<?> getAnswerMessage() {
        return null;
    }

    public Protocol.Inventory getInventory() {
        return this.inv;
    }

    public MessageTypes getInvMessageType() {
        return this.getInventoryType().equals((Object)Protocol.Inventory.InventoryType.BLOCK) ? MessageTypes.BLOCK : MessageTypes.TRX;
    }

    public Protocol.Inventory.InventoryType getInventoryType() {
        return this.inv.getType();
    }

    public String toString() {
        LinkedList<Sha256Hash> hashes = new LinkedList<Sha256Hash>(this.getHashList());
        StringBuilder builder = new StringBuilder();
        builder.append(super.toString()).append("invType: ").append(this.getInvMessageType()).append(", size: ").append(hashes.size()).append(", First hash: ").append(hashes.peekFirst());
        if (hashes.size() > 1) {
            builder.append(", End hash: ").append(hashes.peekLast());
        }
        return builder.toString();
    }

    public List<Sha256Hash> getHashList() {
        return this.getInventory().getIdsList().stream().map(hash -> Sha256Hash.wrap((byte[])hash.toByteArray())).collect(Collectors.toList());
    }
}

