/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.db.api;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.core.ChainBaseManager;
import org.tron.core.capsule.ProposalCapsule;
import org.tron.core.utils.ProposalUtil;
import org.tron.protos.Protocol;

public class BandwidthPriceHistoryLoader {
    private static final Logger logger = LoggerFactory.getLogger((String)"DB");
    private final ChainBaseManager chainBaseManager;
    private List<ProposalCapsule> proposalCapsuleList = new ArrayList<ProposalCapsule>();

    public BandwidthPriceHistoryLoader(ChainBaseManager chainBaseManager) {
        this.chainBaseManager = chainBaseManager;
    }

    public void doWork() {
        long start = System.currentTimeMillis();
        logger.info("Start to load bandwidth price");
        this.getBandwidthProposals();
        if (!this.proposalCapsuleList.isEmpty()) {
            String bandwidthPriceHistory = this.parseProposalsToStr();
            this.chainBaseManager.getDynamicPropertiesStore().saveBandwidthPriceHistory(bandwidthPriceHistory);
        }
        this.finish();
        logger.info("Complete bandwidth price load, total time: {} milliseconds, total proposal count: {}", (Object)(System.currentTimeMillis() - start), (Object)this.proposalCapsuleList.size());
    }

    public void getBandwidthProposals() {
        this.proposalCapsuleList = this.chainBaseManager.getProposalStore().getSpecifiedProposals(Protocol.Proposal.State.APPROVED, ProposalUtil.ProposalType.TRANSACTION_FEE.getCode());
    }

    public String parseProposalsToStr() {
        StringBuilder builder = new StringBuilder("0:10");
        for (ProposalCapsule proposalCapsule : this.proposalCapsuleList) {
            builder.append(",").append(proposalCapsule.getExpirationTime()).append(":").append(proposalCapsule.getParameters().get(ProposalUtil.ProposalType.TRANSACTION_FEE.getCode()));
        }
        return builder.toString();
    }

    public void finish() {
        this.chainBaseManager.getDynamicPropertiesStore().saveBandwidthPriceHistoryDone(1L);
    }
}

