/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.consensus;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.core.capsule.ProposalCapsule;
import org.tron.core.capsule.ProtoCapsule;
import org.tron.core.consensus.ProposalService;
import org.tron.core.db.Manager;
import org.tron.protos.Protocol;

public class ProposalController {
    private static final Logger logger = LoggerFactory.getLogger((String)"witness");
    private Manager manager;

    public static ProposalController createInstance(Manager manager) {
        ProposalController instance = new ProposalController();
        instance.setManager(manager);
        return instance;
    }

    public void processProposals() {
        long latestProposalNum = this.manager.getDynamicPropertiesStore().getLatestProposalNum();
        if (latestProposalNum == 0L) {
            logger.info("latestProposalNum is 0, return");
            return;
        }
        long proposalNum = latestProposalNum;
        ProposalCapsule proposalCapsule = null;
        while (proposalNum > 0L) {
            try {
                proposalCapsule = this.manager.getProposalStore().get(ProposalCapsule.calculateDbKey((long)proposalNum));
            }
            catch (Exception ex) {
                logger.error("", (Throwable)ex);
                --proposalNum;
                continue;
            }
            if (proposalCapsule.hasProcessed()) {
                logger.info("Proposal has processed, id:[{}], skip it and before it", (Object)proposalCapsule.getID());
                break;
            }
            if (proposalCapsule.hasCanceled()) {
                logger.info("Proposal has canceled, id:[{}], skip it", (Object)proposalCapsule.getID());
                --proposalNum;
                continue;
            }
            long currentTime = this.manager.getDynamicPropertiesStore().getNextMaintenanceTime();
            if (proposalCapsule.hasExpired(currentTime)) {
                this.processProposal(proposalCapsule);
                --proposalNum;
                continue;
            }
            --proposalNum;
            logger.info("Proposal has not expired, id:[{}], skip it", (Object)proposalCapsule.getID());
        }
        logger.info("Processing proposals done, oldest proposal[{}]", (Object)proposalNum);
    }

    public void processProposal(ProposalCapsule proposalCapsule) {
        List activeWitnesses = this.manager.getWitnessScheduleStore().getActiveWitnesses();
        if (proposalCapsule.hasMostApprovals(activeWitnesses)) {
            logger.info("Processing proposal,id:{},it has received most approvals, begin to set dynamic parameter:{}, and set proposal state as APPROVED", (Object)proposalCapsule.getID(), (Object)proposalCapsule.getParameters());
            this.setDynamicParameters(proposalCapsule);
            proposalCapsule.setState(Protocol.Proposal.State.APPROVED);
            this.manager.getProposalStore().put(proposalCapsule.createDbKey(), (ProtoCapsule)proposalCapsule);
        } else {
            logger.info("Processing proposal,id:{}, it has not received enough approvals, set proposal state as DISAPPROVED", (Object)proposalCapsule.getID());
            proposalCapsule.setState(Protocol.Proposal.State.DISAPPROVED);
            this.manager.getProposalStore().put(proposalCapsule.createDbKey(), (ProtoCapsule)proposalCapsule);
        }
    }

    public void setDynamicParameters(ProposalCapsule proposalCapsule) {
        ProposalService.process(this.manager, proposalCapsule);
    }

    public void setManager(Manager manager) {
        this.manager = manager;
    }

    public Manager getManager() {
        return this.manager;
    }
}

