/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.logsfilter.capsule;

import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.logsfilter.EventPluginLoader;
import org.tron.common.logsfilter.capsule.TriggerCapsule;
import org.tron.common.logsfilter.trigger.InternalTransactionPojo;
import org.tron.common.logsfilter.trigger.LogPojo;
import org.tron.common.logsfilter.trigger.TransactionLogTrigger;
import org.tron.common.runtime.InternalTransaction;
import org.tron.common.runtime.ProgramResult;
import org.tron.common.utils.StringUtil;
import org.tron.core.capsule.BlockCapsule;
import org.tron.core.capsule.TransactionCapsule;
import org.tron.core.db.TransactionTrace;
import org.tron.protos.Protocol;
import org.tron.protos.contract.AssetIssueContractOuterClass;
import org.tron.protos.contract.BalanceContract;
import org.tron.protos.contract.SmartContractOuterClass;

public class TransactionLogTriggerCapsule
extends TriggerCapsule {
    private static final Logger logger = LoggerFactory.getLogger(TransactionLogTriggerCapsule.class);
    private TransactionLogTrigger transactionLogTrigger = new TransactionLogTrigger();

    public TransactionLogTriggerCapsule(TransactionCapsule trxCapsule, BlockCapsule blockCapsule) {
        this(trxCapsule, blockCapsule, 0, 0L, 0L, null, 0L);
    }

    public TransactionLogTriggerCapsule(TransactionCapsule trxCapsule, BlockCapsule blockCapsule, int txIndex, long preCumulativeEnergyUsed, long preCumulativeLogCount, Protocol.TransactionInfo transactionInfo, long energyUnitPrice) {
        String blockHash = "";
        if (Objects.nonNull(blockCapsule)) {
            blockHash = blockCapsule.getBlockId().toString();
            this.transactionLogTrigger.setBlockHash(blockHash);
        }
        String transactionHash = trxCapsule.getTransactionId().toString();
        this.transactionLogTrigger.setTransactionId(transactionHash);
        this.transactionLogTrigger.setTimeStamp(blockCapsule.getTimeStamp());
        this.transactionLogTrigger.setBlockNumber(trxCapsule.getBlockNum());
        this.transactionLogTrigger.setData(Hex.toHexString((byte[])trxCapsule.getInstance().getRawData().getData().toByteArray()));
        TransactionTrace trxTrace = trxCapsule.getTrxTrace();
        if (Objects.nonNull(trxCapsule.getContractRet())) {
            this.transactionLogTrigger.setResult(trxCapsule.getContractRet().toString());
        }
        Protocol.Transaction.raw rawData = trxCapsule.getInstance().getRawData();
        Protocol.Transaction.Contract.ContractType contractType = null;
        if (Objects.nonNull(rawData)) {
            this.transactionLogTrigger.setFeeLimit(rawData.getFeeLimit());
            Protocol.Transaction.Contract contract = rawData.getContract(0);
            Any contractParameter = null;
            if (Objects.nonNull(contract)) {
                contractType = contract.getType();
                if (Objects.nonNull(contractType)) {
                    this.transactionLogTrigger.setContractType(contractType.toString());
                }
                contractParameter = contract.getParameter();
                this.transactionLogTrigger.setContractCallValue(TransactionCapsule.getCallValue((Protocol.Transaction.Contract)contract));
            }
            if (Objects.nonNull(contractParameter) && Objects.nonNull(contract)) {
                try {
                    switch (contractType) {
                        case TransferContract: {
                            BalanceContract.TransferContract transferContract = (BalanceContract.TransferContract)contractParameter.unpack(BalanceContract.TransferContract.class);
                            if (!Objects.nonNull(transferContract)) break;
                            this.transactionLogTrigger.setAssetName("trx");
                            if (Objects.nonNull(transferContract.getOwnerAddress())) {
                                this.transactionLogTrigger.setFromAddress(StringUtil.encode58Check((byte[])transferContract.getOwnerAddress().toByteArray()));
                            }
                            if (Objects.nonNull(transferContract.getToAddress())) {
                                this.transactionLogTrigger.setToAddress(StringUtil.encode58Check((byte[])transferContract.getToAddress().toByteArray()));
                            }
                            this.transactionLogTrigger.setAssetAmount(transferContract.getAmount());
                            break;
                        }
                        case TransferAssetContract: {
                            AssetIssueContractOuterClass.TransferAssetContract transferAssetContract = (AssetIssueContractOuterClass.TransferAssetContract)contractParameter.unpack(AssetIssueContractOuterClass.TransferAssetContract.class);
                            if (!Objects.nonNull(transferAssetContract)) break;
                            if (Objects.nonNull(transferAssetContract.getAssetName())) {
                                this.transactionLogTrigger.setAssetName(transferAssetContract.getAssetName().toStringUtf8());
                            }
                            if (Objects.nonNull(transferAssetContract.getOwnerAddress())) {
                                this.transactionLogTrigger.setFromAddress(StringUtil.encode58Check((byte[])transferAssetContract.getOwnerAddress().toByteArray()));
                            }
                            if (Objects.nonNull(transferAssetContract.getToAddress())) {
                                this.transactionLogTrigger.setToAddress(StringUtil.encode58Check((byte[])transferAssetContract.getToAddress().toByteArray()));
                            }
                            this.transactionLogTrigger.setAssetAmount(transferAssetContract.getAmount());
                            break;
                        }
                        case TriggerSmartContract: {
                            SmartContractOuterClass.TriggerSmartContract triggerSmartContract = (SmartContractOuterClass.TriggerSmartContract)contractParameter.unpack(SmartContractOuterClass.TriggerSmartContract.class);
                            if (Objects.nonNull(triggerSmartContract.getOwnerAddress())) {
                                this.transactionLogTrigger.setFromAddress(StringUtil.encode58Check((byte[])triggerSmartContract.getOwnerAddress().toByteArray()));
                            }
                            if (!Objects.nonNull(triggerSmartContract.getContractAddress())) break;
                            this.transactionLogTrigger.setToAddress(StringUtil.encode58Check((byte[])triggerSmartContract.getContractAddress().toByteArray()));
                            break;
                        }
                        case CreateSmartContract: {
                            SmartContractOuterClass.CreateSmartContract createSmartContract = (SmartContractOuterClass.CreateSmartContract)contractParameter.unpack(SmartContractOuterClass.CreateSmartContract.class);
                            if (!Objects.nonNull(createSmartContract.getOwnerAddress())) break;
                            this.transactionLogTrigger.setFromAddress(StringUtil.encode58Check((byte[])createSmartContract.getOwnerAddress().toByteArray()));
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    logger.error("failed to load transferAssetContract, error '{}'", (Object)e.getMessage());
                }
            }
        }
        long energyUsageTotal = 0L;
        if (Objects.nonNull(trxTrace) && Objects.nonNull(trxTrace.getReceipt())) {
            energyUsageTotal = trxTrace.getReceipt().getEnergyUsageTotal();
            this.transactionLogTrigger.setEnergyFee(trxTrace.getReceipt().getEnergyFee());
            this.transactionLogTrigger.setOriginEnergyUsage(trxTrace.getReceipt().getOriginEnergyUsage());
            this.transactionLogTrigger.setEnergyUsageTotal(energyUsageTotal);
            this.transactionLogTrigger.setNetUsage(trxTrace.getReceipt().getNetUsage());
            this.transactionLogTrigger.setNetFee(trxTrace.getReceipt().getNetFee());
            this.transactionLogTrigger.setEnergyUsage(trxTrace.getReceipt().getEnergyUsage());
        }
        if (Objects.nonNull(trxTrace) && Objects.nonNull(trxTrace.getRuntime()) && Objects.nonNull(trxTrace.getRuntime().getResult())) {
            ProgramResult programResult = trxTrace.getRuntime().getResult();
            ByteString contractResult2 = ByteString.copyFrom((byte[])programResult.getHReturn());
            ByteString contractAddress = ByteString.copyFrom((byte[])programResult.getContractAddress());
            if (Objects.nonNull(contractResult2) && contractResult2.size() > 0) {
                this.transactionLogTrigger.setContractResult(Hex.toHexString((byte[])contractResult2.toByteArray()));
            }
            if (Objects.nonNull(contractAddress) && contractAddress.size() > 0) {
                if (Objects.nonNull(transactionInfo) && contractType != null && contractType != Protocol.Transaction.Contract.ContractType.CreateSmartContract) {
                    this.transactionLogTrigger.setContractAddress(null);
                } else {
                    this.transactionLogTrigger.setContractAddress(StringUtil.encode58Check((byte[])contractAddress.toByteArray()));
                }
            }
            this.transactionLogTrigger.setInternalTransactionList(this.getInternalTransactionList(programResult.getInternalTransactions()));
        }
        if (Objects.nonNull(transactionInfo)) {
            this.transactionLogTrigger.setTransactionIndex(txIndex);
            this.transactionLogTrigger.setCumulativeEnergyUsed(preCumulativeEnergyUsed + energyUsageTotal);
            this.transactionLogTrigger.setPreCumulativeLogCount(preCumulativeLogCount);
            this.transactionLogTrigger.setEnergyUnitPrice(energyUnitPrice);
            ArrayList<LogPojo> logPojoList = new ArrayList<LogPojo>();
            for (int index = 0; index < transactionInfo.getLogCount(); ++index) {
                Protocol.TransactionInfo.Log log = (Protocol.TransactionInfo.Log)transactionInfo.getLogList().get(index);
                LogPojo logPojo = new LogPojo();
                logPojo.setAddress(log.getAddress() != null ? Hex.toHexString((byte[])log.getAddress().toByteArray()) : "");
                logPojo.setBlockHash(blockHash);
                logPojo.setBlockNumber(trxCapsule.getBlockNum());
                logPojo.setData(Hex.toHexString((byte[])log.getData().toByteArray()));
                logPojo.setLogIndex(preCumulativeLogCount + (long)index);
                ArrayList<String> topics = new ArrayList<String>();
                for (int i = 0; i < log.getTopicsCount(); ++i) {
                    topics.add(Hex.toHexString((byte[])log.getTopics(i).toByteArray()));
                }
                logPojo.setTopicList(topics);
                logPojo.setTransactionHash(transactionHash);
                logPojo.setTransactionIndex((long)txIndex);
                logPojoList.add(logPojo);
            }
            this.transactionLogTrigger.setLogList(logPojoList);
        }
    }

    public void setLatestSolidifiedBlockNumber(long latestSolidifiedBlockNumber) {
        this.transactionLogTrigger.setLatestSolidifiedBlockNumber(latestSolidifiedBlockNumber);
    }

    private List<InternalTransactionPojo> getInternalTransactionList(List<InternalTransaction> internalTransactionList) {
        ArrayList<InternalTransactionPojo> pojoList = new ArrayList<InternalTransactionPojo>();
        internalTransactionList.forEach(internalTransaction -> {
            InternalTransactionPojo item = new InternalTransactionPojo();
            item.setHash(Hex.toHexString((byte[])internalTransaction.getHash()));
            item.setCallValue(internalTransaction.getValue());
            item.setTokenInfo(internalTransaction.getTokenInfo());
            item.setCaller_address(Hex.toHexString((byte[])internalTransaction.getSender()));
            item.setTransferTo_address(Hex.toHexString((byte[])internalTransaction.getTransferToAddress()));
            item.setData(Hex.toHexString((byte[])internalTransaction.getData()));
            item.setRejected(internalTransaction.isRejected());
            item.setNote(internalTransaction.getNote());
            item.setExtra(internalTransaction.getExtra());
            pojoList.add(item);
        });
        return pojoList;
    }

    @Override
    public void processTrigger() {
        EventPluginLoader.getInstance().postTransactionTrigger(this.transactionLogTrigger);
    }

    public TransactionLogTrigger getTransactionLogTrigger() {
        return this.transactionLogTrigger;
    }

    public void setTransactionLogTrigger(TransactionLogTrigger transactionLogTrigger) {
        this.transactionLogTrigger = transactionLogTrigger;
    }
}

