/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.logsfilter;

import com.beust.jcommander.internal.Sets;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.bouncycastle.util.encoders.Hex;
import org.pf4j.CompoundPluginDescriptorFinder;
import org.pf4j.DefaultPluginManager;
import org.pf4j.ManifestPluginDescriptorFinder;
import org.pf4j.PluginDescriptorFinder;
import org.pf4j.PluginManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.tron.common.logsfilter.EventPluginConfig;
import org.tron.common.logsfilter.FilterQuery;
import org.tron.common.logsfilter.IPluginEventListener;
import org.tron.common.logsfilter.TriggerConfig;
import org.tron.common.logsfilter.nativequeue.NativeMessageQueue;
import org.tron.common.logsfilter.trigger.BlockLogTrigger;
import org.tron.common.logsfilter.trigger.ContractEventTrigger;
import org.tron.common.logsfilter.trigger.ContractLogTrigger;
import org.tron.common.logsfilter.trigger.ContractTrigger;
import org.tron.common.logsfilter.trigger.SolidityTrigger;
import org.tron.common.logsfilter.trigger.TransactionLogTrigger;

public class EventPluginLoader {
    private static final Logger logger = LoggerFactory.getLogger(EventPluginLoader.class);
    private static EventPluginLoader instance;
    private PluginManager pluginManager = null;
    private List<IPluginEventListener> eventListeners;
    private ObjectMapper objectMapper = new ObjectMapper();
    private String serverAddress;
    private String dbConfig;
    private List<TriggerConfig> triggerConfigList;
    private boolean blockLogTriggerEnable = false;
    private boolean blockLogTriggerSolidified = false;
    private boolean transactionLogTriggerEnable = false;
    private boolean transactionLogTriggerSolidified = false;
    private boolean transactionLogTriggerEthCompatible = false;
    private boolean contractEventTriggerEnable = false;
    private boolean contractLogTriggerEnable = false;
    private boolean contractLogTriggerRedundancy = false;
    private boolean solidityEventTriggerEnable = false;
    private boolean solidityLogTriggerEnable = false;
    private boolean solidityLogTriggerRedundancy = false;
    private boolean solidityTriggerEnable = false;
    private FilterQuery filterQuery;
    private boolean useNativeQueue = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EventPluginLoader getInstance() {
        if (!Objects.isNull(instance)) return instance;
        Class<EventPluginLoader> clazz = EventPluginLoader.class;
        synchronized (EventPluginLoader.class) {
            if (!Objects.isNull(instance)) return instance;
            instance = new EventPluginLoader();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static boolean matchFilter(ContractTrigger trigger) {
        long blockNumber = trigger.getBlockNumber();
        FilterQuery filterQuery = EventPluginLoader.getInstance().getFilterQuery();
        if (Objects.isNull(filterQuery)) {
            return true;
        }
        long fromBlockNumber = filterQuery.getFromBlock();
        long toBlockNumber = filterQuery.getToBlock();
        boolean matched = false;
        if (fromBlockNumber == -1L || toBlockNumber == 0L) {
            logger.error("invalid filter: fromBlockNumber: {}, toBlockNumber: {}", (Object)fromBlockNumber, (Object)toBlockNumber);
            return false;
        }
        if (toBlockNumber == -1L) {
            if (fromBlockNumber == 0L) {
                matched = true;
            } else if (blockNumber >= fromBlockNumber) {
                matched = true;
            }
        } else if (fromBlockNumber == 0L) {
            if (blockNumber <= toBlockNumber) {
                matched = true;
            }
        } else if (blockNumber >= fromBlockNumber && blockNumber <= toBlockNumber) {
            matched = true;
        }
        if (!matched) {
            return false;
        }
        return EventPluginLoader.filterContractAddress(trigger, filterQuery.getContractAddressList()) && EventPluginLoader.filterContractTopicList(trigger, filterQuery.getContractTopicList());
    }

    private static boolean filterContractAddress(ContractTrigger trigger, List<String> addressList) {
        if (Objects.isNull(addressList = addressList.stream().filter(item -> org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)item)).collect(Collectors.toList())) || addressList.isEmpty()) {
            return true;
        }
        String contractAddress = trigger.getContractAddress();
        if (Objects.isNull(contractAddress)) {
            return false;
        }
        for (String address : addressList) {
            if (!contractAddress.equalsIgnoreCase(address)) continue;
            return true;
        }
        return false;
    }

    private static boolean filterContractTopicList(ContractTrigger trigger, List<String> topList) {
        if (Objects.isNull(topList = topList.stream().filter(item -> org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)item)).collect(Collectors.toList())) || topList.isEmpty()) {
            return true;
        }
        Set hset = Sets.newHashSet();
        if (trigger instanceof ContractLogTrigger) {
            hset = ((ContractLogTrigger)trigger).getTopicList().stream().collect(Collectors.toSet());
        } else if (trigger instanceof ContractEventTrigger) {
            hset = new HashSet(((ContractEventTrigger)trigger).getTopicMap().values());
        } else if (trigger != null) {
            hset = trigger.getLogInfo().getClonedTopics().stream().map(Hex::toHexString).collect(Collectors.toSet());
        }
        for (String top : topList) {
            if (!hset.contains(top)) continue;
            return true;
        }
        return false;
    }

    private boolean launchNativeQueue(EventPluginConfig config) {
        if (!NativeMessageQueue.getInstance().start(config.getBindPort(), config.getSendQueueLength())) {
            return false;
        }
        if (Objects.isNull(this.triggerConfigList)) {
            logger.error("trigger config is null");
            return false;
        }
        this.triggerConfigList.forEach(triggerConfig -> this.setSingleTriggerConfig((TriggerConfig)triggerConfig));
        return true;
    }

    private boolean launchEventPlugin(EventPluginConfig config) {
        String pluginPath = config.getPluginPath();
        this.serverAddress = config.getServerAddress();
        this.dbConfig = config.getDbConfig();
        if (!this.startPlugin(pluginPath)) {
            logger.error("failed to load '{}'", (Object)pluginPath);
            return false;
        }
        this.setPluginConfig();
        if (Objects.nonNull(this.eventListeners)) {
            this.eventListeners.forEach(listener -> listener.start());
        }
        return true;
    }

    public boolean start(EventPluginConfig config) {
        if (Objects.isNull(config)) {
            return false;
        }
        this.triggerConfigList = config.getTriggerConfigList();
        this.useNativeQueue = config.isUseNativeQueue();
        if (config.isUseNativeQueue()) {
            return this.launchNativeQueue(config);
        }
        return this.launchEventPlugin(config);
    }

    private void setPluginConfig() {
        if (Objects.isNull(this.eventListeners)) {
            return;
        }
        this.eventListeners.forEach(listener -> listener.setServerAddress(this.serverAddress));
        this.eventListeners.forEach(listener -> listener.setDBConfig(this.dbConfig));
        this.triggerConfigList.forEach(triggerConfig -> this.setSingleTriggerConfig((TriggerConfig)triggerConfig));
    }

    private void setSingleTriggerConfig(TriggerConfig triggerConfig) {
        if ("block".equalsIgnoreCase(triggerConfig.getTriggerName())) {
            if (triggerConfig.isEnabled()) {
                this.blockLogTriggerEnable = true;
                if (triggerConfig.isSolidified()) {
                    this.blockLogTriggerSolidified = true;
                }
            } else {
                this.blockLogTriggerEnable = false;
                this.blockLogTriggerSolidified = false;
            }
            if (!this.useNativeQueue) {
                this.setPluginTopic(0, triggerConfig.getTopic());
            }
        } else if ("transaction".equalsIgnoreCase(triggerConfig.getTriggerName())) {
            if (triggerConfig.isEnabled()) {
                this.transactionLogTriggerEnable = true;
                if (triggerConfig.isEthCompatible()) {
                    this.transactionLogTriggerEthCompatible = true;
                }
                if (triggerConfig.isSolidified()) {
                    this.transactionLogTriggerSolidified = true;
                }
            } else {
                this.transactionLogTriggerEnable = false;
                this.transactionLogTriggerEthCompatible = false;
                this.transactionLogTriggerSolidified = false;
            }
            if (!this.useNativeQueue) {
                this.setPluginTopic(1, triggerConfig.getTopic());
            }
        } else if ("contractevent".equalsIgnoreCase(triggerConfig.getTriggerName())) {
            this.contractEventTriggerEnable = triggerConfig.isEnabled();
            if (!this.useNativeQueue) {
                this.setPluginTopic(3, triggerConfig.getTopic());
            }
        } else if ("contractlog".equalsIgnoreCase(triggerConfig.getTriggerName())) {
            if (triggerConfig.isEnabled()) {
                this.contractLogTriggerEnable = true;
                if (triggerConfig.isRedundancy()) {
                    this.contractLogTriggerRedundancy = true;
                }
            } else {
                this.contractLogTriggerEnable = false;
                this.contractLogTriggerRedundancy = false;
            }
            if (!this.useNativeQueue) {
                this.setPluginTopic(2, triggerConfig.getTopic());
            }
        } else if ("solidity".equalsIgnoreCase(triggerConfig.getTriggerName())) {
            this.solidityTriggerEnable = triggerConfig.isEnabled();
            if (!this.useNativeQueue) {
                this.setPluginTopic(4, triggerConfig.getTopic());
            }
        } else if ("solidityevent".equalsIgnoreCase(triggerConfig.getTriggerName())) {
            this.solidityEventTriggerEnable = triggerConfig.isEnabled();
            if (!this.useNativeQueue) {
                this.setPluginTopic(5, triggerConfig.getTopic());
            }
        } else if ("soliditylog".equalsIgnoreCase(triggerConfig.getTriggerName())) {
            if (triggerConfig.isEnabled()) {
                this.solidityLogTriggerEnable = true;
                if (triggerConfig.isRedundancy()) {
                    this.solidityLogTriggerRedundancy = true;
                }
            } else {
                this.solidityLogTriggerEnable = false;
                this.solidityLogTriggerRedundancy = false;
            }
            if (!this.useNativeQueue) {
                this.setPluginTopic(6, triggerConfig.getTopic());
            }
        }
    }

    public void postSolidityTrigger(SolidityTrigger trigger) {
        if (this.useNativeQueue) {
            NativeMessageQueue.getInstance().publishTrigger(this.toJsonString(trigger), trigger.getTriggerName());
        } else {
            this.eventListeners.forEach(listener -> listener.handleSolidityTrigger(this.toJsonString(trigger)));
        }
    }

    public synchronized boolean isBlockLogTriggerEnable() {
        return this.blockLogTriggerEnable;
    }

    public synchronized boolean isBlockLogTriggerSolidified() {
        return this.blockLogTriggerSolidified;
    }

    public synchronized boolean isSolidityTriggerEnable() {
        return this.solidityTriggerEnable;
    }

    public synchronized boolean isSolidityEventTriggerEnable() {
        return this.solidityEventTriggerEnable;
    }

    public synchronized boolean isSolidityLogTriggerEnable() {
        return this.solidityLogTriggerEnable;
    }

    public synchronized boolean isSolidityLogTriggerRedundancy() {
        return this.solidityLogTriggerRedundancy;
    }

    public synchronized boolean isTransactionLogTriggerEnable() {
        return this.transactionLogTriggerEnable;
    }

    public synchronized boolean isTransactionLogTriggerEthCompatible() {
        return this.transactionLogTriggerEthCompatible;
    }

    public synchronized boolean isTransactionLogTriggerSolidified() {
        return this.transactionLogTriggerSolidified;
    }

    public synchronized boolean isContractEventTriggerEnable() {
        return this.contractEventTriggerEnable;
    }

    public synchronized boolean isContractLogTriggerEnable() {
        return this.contractLogTriggerEnable;
    }

    public synchronized boolean isContractLogTriggerRedundancy() {
        return this.contractLogTriggerRedundancy;
    }

    private void setPluginTopic(int eventType, String topic) {
        this.eventListeners.forEach(listener -> listener.setTopic(eventType, topic));
    }

    private boolean startPlugin(String path) {
        String pluginId;
        logger.info("start loading '{}'", (Object)path);
        File pluginPath = new File(path);
        if (!pluginPath.exists()) {
            logger.error("'{}' doesn't exist", (Object)path);
            return false;
        }
        if (Objects.isNull(this.pluginManager)) {
            this.pluginManager = new DefaultPluginManager(pluginPath.toPath()){

                protected CompoundPluginDescriptorFinder createPluginDescriptorFinder() {
                    return new CompoundPluginDescriptorFinder().add((PluginDescriptorFinder)new ManifestPluginDescriptorFinder());
                }
            };
        }
        if (StringUtils.isEmpty((Object)(pluginId = this.pluginManager.loadPlugin(pluginPath.toPath())))) {
            logger.error("invalid pluginID");
            return false;
        }
        this.pluginManager.startPlugins();
        this.eventListeners = this.pluginManager.getExtensions(IPluginEventListener.class);
        if (Objects.isNull(this.eventListeners) || this.eventListeners.isEmpty()) {
            logger.error("No eventListener is registered");
            return false;
        }
        logger.info("'{}' loaded", (Object)path);
        return true;
    }

    public void stopPlugin() {
        if (Objects.nonNull(this.pluginManager)) {
            this.pluginManager.stopPlugins();
        }
        NativeMessageQueue.getInstance().stop();
        logger.info("eventPlugin stopped");
    }

    public void postBlockTrigger(BlockLogTrigger trigger) {
        if (this.useNativeQueue) {
            NativeMessageQueue.getInstance().publishTrigger(this.toJsonString(trigger), trigger.getTriggerName());
        } else {
            this.eventListeners.forEach(listener -> listener.handleBlockEvent(this.toJsonString(trigger)));
        }
    }

    public void postSolidityLogTrigger(ContractLogTrigger trigger) {
        if (this.useNativeQueue) {
            NativeMessageQueue.getInstance().publishTrigger(this.toJsonString(trigger), trigger.getTriggerName());
        } else {
            this.eventListeners.forEach(listener -> listener.handleSolidityLogTrigger(this.toJsonString(trigger)));
        }
    }

    public void postSolidityEventTrigger(ContractEventTrigger trigger) {
        if (this.useNativeQueue) {
            NativeMessageQueue.getInstance().publishTrigger(this.toJsonString(trigger), trigger.getTriggerName());
        } else {
            this.eventListeners.forEach(listener -> listener.handleSolidityEventTrigger(this.toJsonString(trigger)));
        }
    }

    public void postTransactionTrigger(TransactionLogTrigger trigger) {
        if (this.useNativeQueue) {
            NativeMessageQueue.getInstance().publishTrigger(this.toJsonString(trigger), trigger.getTriggerName());
        } else {
            this.eventListeners.forEach(listener -> listener.handleTransactionTrigger(this.toJsonString(trigger)));
        }
    }

    public void postContractLogTrigger(ContractLogTrigger trigger) {
        if (this.useNativeQueue) {
            NativeMessageQueue.getInstance().publishTrigger(this.toJsonString(trigger), trigger.getTriggerName());
        } else {
            this.eventListeners.forEach(listener -> listener.handleContractLogTrigger(this.toJsonString(trigger)));
        }
    }

    public void postContractEventTrigger(ContractEventTrigger trigger) {
        if (this.useNativeQueue) {
            NativeMessageQueue.getInstance().publishTrigger(this.toJsonString(trigger), trigger.getTriggerName());
        } else {
            this.eventListeners.forEach(listener -> listener.handleContractEventTrigger(this.toJsonString(trigger)));
        }
    }

    private String toJsonString(Object data) {
        String jsonData = "";
        try {
            jsonData = this.objectMapper.writeValueAsString(data);
        }
        catch (JsonProcessingException e) {
            logger.error("'{}'", (Throwable)e);
        }
        return jsonData;
    }

    public synchronized FilterQuery getFilterQuery() {
        return this.filterQuery;
    }

    public synchronized void setFilterQuery(FilterQuery filterQuery) {
        this.filterQuery = filterQuery;
    }
}

