/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.logsfilter;

import java.math.BigInteger;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;
import org.bouncycastle.crypto.OutputLengthException;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;
import org.pf4j.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.runtime.vm.DataWord;
import org.tron.common.utils.StringUtil;
import org.tron.core.db.TransactionTrace;

public class ContractEventParser {
    private static final Logger logger = LoggerFactory.getLogger((String)"Parser");
    private static final int DATAWORD_UNIT_SIZE = 32;

    public static String parseDataBytes(byte[] data, String typeStr, int index) {
        try {
            byte[] startBytes = ContractEventParser.subBytes(data, index * 32, 32);
            Type type = ContractEventParser.basicType(typeStr);
            if (type == Type.INT_NUMBER) {
                return new BigInteger(startBytes).toString();
            }
            if (type == Type.BOOL) {
                return String.valueOf(!DataWord.isZero((byte[])startBytes));
            }
            if (type == Type.FIXED_BYTES) {
                return Hex.toHexString((byte[])startBytes);
            }
            if (type == Type.ADDRESS) {
                byte[] last20Bytes = Arrays.copyOfRange((byte[])startBytes, (int)12, (int)startBytes.length);
                return StringUtil.encode58Check((byte[])TransactionTrace.convertToTronAddress((byte[])last20Bytes));
            }
            if (type == Type.STRING || type == Type.BYTES) {
                int start = ContractEventParser.intValueExact(startBytes);
                byte[] lengthBytes = ContractEventParser.subBytes(data, start, 32);
                int length = ContractEventParser.intValueExact(lengthBytes);
                byte[] realBytes = length > 0 ? ContractEventParser.subBytes(data, start + 32, length) : new byte[]{};
                return type == Type.STRING ? new String(realBytes) : Hex.toHexString((byte[])realBytes);
            }
        }
        catch (ArithmeticException | OutputLengthException e) {
            logger.debug("parseDataBytes ", e);
        }
        throw new UnsupportedOperationException("unsupported type:" + typeStr);
    }

    protected static Type basicType(String type) {
        if (!Pattern.matches("^.*\\[\\d*\\]$", type)) {
            if (type.startsWith("int") || type.startsWith("uint") || type.startsWith("trcToken")) {
                return Type.INT_NUMBER;
            }
            if ("bool".equals(type)) {
                return Type.BOOL;
            }
            if ("address".equals(type)) {
                return Type.ADDRESS;
            }
            if (Pattern.matches("^bytes\\d+$", type)) {
                return Type.FIXED_BYTES;
            }
            if ("string".equals(type)) {
                return Type.STRING;
            }
            if ("bytes".equals(type)) {
                return Type.BYTES;
            }
        }
        return Type.UNKNOWN;
    }

    protected static Integer intValueExact(byte[] data) {
        return new BigInteger(data).intValueExact();
    }

    protected static byte[] subBytes(byte[] src, int start, int length) {
        if (ArrayUtils.isEmpty((byte[])src) || start >= src.length || length < 0) {
            throw new OutputLengthException("data start:" + start + ", length:" + length);
        }
        byte[] dst = new byte[length];
        System.arraycopy(src, start, dst, 0, Math.min(length, src.length - start));
        return dst;
    }

    protected static String parseTopic(byte[] bytes, String typeStr) {
        if (ArrayUtils.isEmpty((byte[])bytes) || StringUtils.isNullOrEmpty((String)typeStr)) {
            return "";
        }
        Type type = ContractEventParser.basicType(typeStr);
        if (type == Type.INT_NUMBER) {
            return DataWord.bigIntValue((byte[])bytes);
        }
        if (type == Type.BOOL) {
            return String.valueOf(!DataWord.isZero((byte[])bytes));
        }
        if (type == Type.ADDRESS) {
            byte[] last20Bytes = Arrays.copyOfRange((byte[])bytes, (int)12, (int)bytes.length);
            return StringUtil.encode58Check((byte[])TransactionTrace.convertToTronAddress((byte[])last20Bytes));
        }
        return Hex.toHexString((byte[])bytes);
    }

    private static enum Type {
        UNKNOWN,
        INT_NUMBER,
        BOOL,
        FLOAT_NUMBER,
        FIXED_BYTES,
        ADDRESS,
        STRING,
        BYTES;

    }
}

