/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.crypto.zksnark;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.tron.common.crypto.zksnark.BN128G1;
import org.tron.common.crypto.zksnark.BN128G2;
import org.tron.common.crypto.zksnark.Fp;
import org.tron.common.crypto.zksnark.Fp12;
import org.tron.common.crypto.zksnark.Fp2;
import org.tron.common.crypto.zksnark.Params;

public class PairingCheck {
    static final BigInteger LOOP_COUNT = new BigInteger("29793968203157093288");
    List<Pair> pairs = new ArrayList<Pair>();
    Fp12 product = Fp12._1;

    private PairingCheck() {
    }

    public static PairingCheck create() {
        return new PairingCheck();
    }

    private static Fp12 millerLoop(BN128G1 g1, BN128G2 g2) {
        g1 = g1.toAffine();
        g2 = g2.toAffine();
        List<EllCoeffs> coeffs = PairingCheck.calcEllCoeffs(g2);
        Fp12 f = Fp12._1;
        int idx = 0;
        for (int i = LOOP_COUNT.bitLength() - 2; i >= 0; --i) {
            EllCoeffs c = coeffs.get(idx++);
            f = f.squared();
            f = f.mulBy024(c.ell0, ((Fp)g1.y).mul(c.ellVW), ((Fp)g1.x).mul(c.ellVV));
            if (!LOOP_COUNT.testBit(i)) continue;
            c = coeffs.get(idx++);
            f = f.mulBy024(c.ell0, ((Fp)g1.y).mul(c.ellVW), ((Fp)g1.x).mul(c.ellVV));
        }
        EllCoeffs c = coeffs.get(idx++);
        f = f.mulBy024(c.ell0, ((Fp)g1.y).mul(c.ellVW), ((Fp)g1.x).mul(c.ellVV));
        c = coeffs.get(idx);
        f = f.mulBy024(c.ell0, ((Fp)g1.y).mul(c.ellVW), ((Fp)g1.x).mul(c.ellVV));
        return f;
    }

    private static List<EllCoeffs> calcEllCoeffs(BN128G2 base) {
        Precomputed addition;
        ArrayList<EllCoeffs> coeffs = new ArrayList<EllCoeffs>();
        BN128G2 addend = base;
        for (int i = LOOP_COUNT.bitLength() - 2; i >= 0; --i) {
            Precomputed doubling = PairingCheck.flippedMillerLoopDoubling(addend);
            addend = doubling.g2;
            coeffs.add(doubling.coeffs);
            if (!LOOP_COUNT.testBit(i)) continue;
            addition = PairingCheck.flippedMillerLoopMixedAddition(base, addend);
            addend = addition.g2;
            coeffs.add(addition.coeffs);
        }
        BN128G2 q1 = base.mulByP();
        BN128G2 q2 = q1.mulByP();
        q2 = new BN128G2((Fp2)q2.x, ((Fp2)q2.y).negate(), (Fp2)q2.z);
        addition = PairingCheck.flippedMillerLoopMixedAddition(q1, addend);
        addend = addition.g2;
        coeffs.add(addition.coeffs);
        addition = PairingCheck.flippedMillerLoopMixedAddition(q2, addend);
        coeffs.add(addition.coeffs);
        return coeffs;
    }

    private static Precomputed flippedMillerLoopMixedAddition(BN128G2 base, BN128G2 addend) {
        Fp2 x1 = (Fp2)addend.x;
        Fp2 y1 = (Fp2)addend.y;
        Fp2 z1 = (Fp2)addend.z;
        Fp2 x2 = (Fp2)base.x;
        Fp2 y2 = (Fp2)base.y;
        Fp2 d = x1.sub(x2.mul(z1));
        Fp2 e = y1.sub(y2.mul(z1));
        Fp2 f = d.squared();
        Fp2 g = e.squared();
        Fp2 h = d.mul(f);
        Fp2 i = x1.mul(f);
        Fp2 j = h.add(z1.mul(g)).sub(i.dbl());
        Fp2 x3 = d.mul(j);
        Fp2 y3 = e.mul(i.sub(j)).sub(h.mul(y1));
        Fp2 z3 = z1.mul(h);
        Fp2 ell0 = Params.TWIST.mul(e.mul(x2).sub(d.mul(y2)));
        Fp2 ellVV = e.negate();
        Fp2 ellVW = d;
        return Precomputed.of(new BN128G2(x3, y3, z3), new EllCoeffs(ell0, ellVW, ellVV));
    }

    private static Precomputed flippedMillerLoopDoubling(BN128G2 g2) {
        Fp2 x = (Fp2)g2.x;
        Fp2 y = (Fp2)g2.y;
        Fp2 z = (Fp2)g2.z;
        Fp2 a = Fp._2_INV.mul(x.mul(y));
        Fp2 b = y.squared();
        Fp2 c = z.squared();
        Fp2 d = c.add(c).add(c);
        Fp2 e = Params.B_Fp2.mul(d);
        Fp2 f = e.add(e).add(e);
        Fp2 g = Fp._2_INV.mul(b.add(f));
        Fp2 h = y.add(z).squared().sub(b.add(c));
        Fp2 i = e.sub(b);
        Fp2 j = x.squared();
        Fp2 e2 = e.squared();
        Fp2 rx = a.mul(b.sub(f));
        Fp2 ry = g.squared().sub(e2.add(e2).add(e2));
        Fp2 rz = b.mul(h);
        Fp2 ell0 = Params.TWIST.mul(i);
        Fp2 ellVW = h.negate();
        Fp2 ellVV = j.add(j).add(j);
        return Precomputed.of(new BN128G2(rx, ry, rz), new EllCoeffs(ell0, ellVW, ellVV));
    }

    public static Fp12 finalExponentiation(Fp12 el) {
        Fp12 w = new Fp12(el.a, el.b.negate());
        Fp12 x = el.inverse();
        Fp12 y = w.mul(x);
        Fp12 z = y.frobeniusMap(2);
        Fp12 pre = z.mul(y);
        Fp12 a = pre.negExp(Params.PAIRING_FINAL_EXPONENT_Z);
        Fp12 b = a.cyclotomicSquared();
        Fp12 c = b.cyclotomicSquared();
        Fp12 d = c.mul(b);
        Fp12 e = d.negExp(Params.PAIRING_FINAL_EXPONENT_Z);
        Fp12 f = e.cyclotomicSquared();
        Fp12 g = f.negExp(Params.PAIRING_FINAL_EXPONENT_Z);
        Fp12 h = d.unitaryInverse();
        Fp12 i = g.unitaryInverse();
        Fp12 j = i.mul(e);
        Fp12 k = j.mul(h);
        Fp12 l = k.mul(b);
        Fp12 m = k.mul(e);
        Fp12 n = m.mul(pre);
        Fp12 o = l.frobeniusMap(1);
        Fp12 p = o.mul(n);
        Fp12 q = k.frobeniusMap(2);
        Fp12 r = q.mul(p);
        Fp12 s = pre.unitaryInverse();
        Fp12 t = s.mul(l);
        Fp12 u = t.frobeniusMap(3);
        Fp12 v = u.mul(r);
        return v;
    }

    public void addPair(BN128G1 g1, BN128G2 g2) {
        this.pairs.add(Pair.of(g1, g2));
    }

    public void run() {
        for (Pair pair : this.pairs) {
            Fp12 miller = pair.millerLoop();
            if (miller.equals(Fp12._1)) continue;
            this.product = this.product.mul(miller);
        }
        this.product = PairingCheck.finalExponentiation(this.product);
    }

    public int result() {
        return this.product.equals(Fp12._1) ? 1 : 0;
    }

    static class EllCoeffs {
        Fp2 ell0;
        Fp2 ellVW;
        Fp2 ellVV;

        EllCoeffs(Fp2 ell0, Fp2 ellVW, Fp2 ellVV) {
            this.ell0 = ell0;
            this.ellVW = ellVW;
            this.ellVV = ellVV;
        }
    }

    static class Pair {
        BN128G1 g1;
        BN128G2 g2;

        Pair(BN128G1 g1, BN128G2 g2) {
            this.g1 = g1;
            this.g2 = g2;
        }

        static Pair of(BN128G1 g1, BN128G2 g2) {
            return new Pair(g1, g2);
        }

        Fp12 millerLoop() {
            if (this.g1.isZero()) {
                return Fp12._1;
            }
            if (this.g2.isZero()) {
                return Fp12._1;
            }
            return PairingCheck.millerLoop(this.g1, this.g2);
        }
    }

    static class Precomputed {
        BN128G2 g2;
        EllCoeffs coeffs;

        Precomputed(BN128G2 g2, EllCoeffs coeffs) {
            this.g2 = g2;
            this.coeffs = coeffs;
        }

        static Precomputed of(BN128G2 g2, EllCoeffs coeffs) {
            return new Precomputed(g2, coeffs);
        }
    }
}

