/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.crypto;

import org.bouncycastle.crypto.Digest;
import org.bouncycastle.jcajce.provider.digest.BCMessageDigest;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;

public class Blake2bfMessageDigest
extends BCMessageDigest
implements Cloneable {
    public Blake2bfMessageDigest() {
        super((Digest)new Blake2bfDigest());
    }

    public static class Blake2bfDigest
    implements Digest {
        public static final int MESSAGE_LENGTH_BYTES = 213;
        private static final long[] IV = new long[]{7640891576956012808L, -4942790177534073029L, 4354685564936845355L, -6534734903238641935L, 5840696475078001361L, -7276294671716946913L, 2270897969802886507L, 6620516959819538809L};
        private static final byte[][] PRECOMPUTED = new byte[][]{{0, 2, 4, 6, 1, 3, 5, 7, 8, 10, 12, 14, 9, 11, 13, 15}, {14, 4, 9, 13, 10, 8, 15, 6, 1, 0, 11, 5, 12, 2, 7, 3}, {11, 12, 5, 15, 8, 0, 2, 13, 10, 3, 7, 9, 14, 6, 1, 4}, {7, 3, 13, 11, 9, 1, 12, 14, 2, 5, 4, 15, 6, 10, 0, 8}, {9, 5, 2, 10, 0, 7, 4, 15, 14, 11, 6, 3, 1, 12, 8, 13}, {2, 6, 0, 8, 12, 10, 11, 3, 4, 7, 15, 1, 13, 5, 14, 9}, {12, 1, 14, 4, 5, 15, 13, 10, 0, 6, 9, 8, 7, 3, 2, 11}, {13, 7, 12, 3, 11, 14, 1, 9, 5, 15, 8, 2, 0, 4, 6, 10}, {6, 14, 11, 0, 15, 9, 3, 8, 12, 13, 1, 10, 2, 7, 4, 5}, {10, 8, 7, 1, 2, 4, 6, 5, 15, 9, 3, 13, 11, 14, 12, 0}};
        private static final int DIGEST_LENGTH = 64;
        private final byte[] buffer;
        private int bufferPos;
        private final long[] h;
        private final long[] m;
        private final long[] t;
        private boolean f;
        private long rounds;
        private final long[] v;

        Blake2bfDigest() {
            this.buffer = new byte[213];
            this.bufferPos = 0;
            this.h = new long[8];
            this.m = new long[16];
            this.t = new long[2];
            this.f = false;
            this.rounds = 12L;
            this.v = new long[16];
        }

        Blake2bfDigest(long[] h, long[] m, long[] t, boolean f, long rounds) {
            assert (rounds <= 0xFFFFFFFFL);
            this.buffer = new byte[213];
            this.bufferPos = 0;
            this.h = h;
            this.m = m;
            this.t = t;
            this.f = f;
            this.rounds = rounds;
            this.v = new long[16];
        }

        public String getAlgorithmName() {
            return "BLAKE2f";
        }

        public int getDigestSize() {
            return 64;
        }

        public void update(byte in) {
            if (this.bufferPos == 213) {
                throw new IllegalArgumentException();
            }
            this.buffer[this.bufferPos] = in;
            ++this.bufferPos;
            if (this.bufferPos == 213) {
                this.initialize();
            }
        }

        public void update(byte[] in, int offset, int len) {
            if (in == null || len == 0) {
                return;
            }
            if (len > 213 - this.bufferPos) {
                throw new IllegalArgumentException("Attempting to update buffer with " + len + " byte(s) but there is " + (213 - this.bufferPos) + " byte(s) left to fill");
            }
            System.arraycopy(in, offset, this.buffer, this.bufferPos, len);
            this.bufferPos += len;
            if (this.bufferPos == 213) {
                this.initialize();
            }
        }

        public int doFinal(byte[] out, int offset) {
            if (this.bufferPos != 213) {
                throw new IllegalStateException("The buffer must be filled with 213 bytes");
            }
            this.compress();
            for (int i = 0; i < this.h.length; ++i) {
                System.arraycopy(Pack.longToLittleEndian((long)this.h[i]), 0, out, i * 8, 8);
            }
            this.reset();
            return 0;
        }

        public void reset() {
            this.bufferPos = 0;
            Arrays.fill((byte[])this.buffer, (byte)0);
            Arrays.fill((long[])this.h, (long)0L);
            Arrays.fill((long[])this.m, (long)0L);
            Arrays.fill((long[])this.t, (long)0L);
            this.f = false;
            this.rounds = 12L;
            Arrays.fill((long[])this.v, (long)0L);
        }

        private void initialize() {
            int offset;
            int i;
            this.rounds = Integer.toUnsignedLong(this.bytesToInt(java.util.Arrays.copyOfRange(this.buffer, 0, 4)));
            for (i = 0; i < this.h.length; ++i) {
                offset = 4 + i * 8;
                this.h[i] = this.bytesToLong(java.util.Arrays.copyOfRange(this.buffer, offset, offset + 8));
            }
            for (i = 0; i < 16; ++i) {
                offset = 68 + i * 8;
                this.m[i] = this.bytesToLong(java.util.Arrays.copyOfRange(this.buffer, offset, offset + 8));
            }
            this.t[0] = this.bytesToLong(java.util.Arrays.copyOfRange(this.buffer, 196, 204));
            this.t[1] = this.bytesToLong(java.util.Arrays.copyOfRange(this.buffer, 204, 212));
            this.f = this.buffer[212] != 0;
        }

        private int bytesToInt(byte[] bytes) {
            return Pack.bigEndianToInt((byte[])bytes, (int)0);
        }

        private long bytesToLong(byte[] bytes) {
            return Pack.littleEndianToLong((byte[])bytes, (int)0);
        }

        private void compress() {
            long t0 = this.t[0];
            long t1 = this.t[1];
            System.arraycopy(this.h, 0, this.v, 0, 8);
            System.arraycopy(IV, 0, this.v, 8, 8);
            this.v[12] = this.v[12] ^ t0;
            this.v[13] = this.v[13] ^ t1;
            if (this.f) {
                this.v[14] = this.v[14] ^ 0xFFFFFFFFFFFFFFFFL;
            }
            for (long j = 0L; j < this.rounds; ++j) {
                byte[] s = PRECOMPUTED[(int)(j % 10L)];
                this.mix(this.m[s[0]], this.m[s[4]], 0, 4, 8, 12);
                this.mix(this.m[s[1]], this.m[s[5]], 1, 5, 9, 13);
                this.mix(this.m[s[2]], this.m[s[6]], 2, 6, 10, 14);
                this.mix(this.m[s[3]], this.m[s[7]], 3, 7, 11, 15);
                this.mix(this.m[s[8]], this.m[s[12]], 0, 5, 10, 15);
                this.mix(this.m[s[9]], this.m[s[13]], 1, 6, 11, 12);
                this.mix(this.m[s[10]], this.m[s[14]], 2, 7, 8, 13);
                this.mix(this.m[s[11]], this.m[s[15]], 3, 4, 9, 14);
            }
            for (int offset = 0; offset < this.h.length; ++offset) {
                int n = offset;
                this.h[n] = this.h[n] ^ (this.v[offset] ^ this.v[offset + 8]);
            }
        }

        private void mix(long a, long b, int i, int j, int k, int l) {
            int n = i;
            this.v[n] = this.v[n] + (a + this.v[j]);
            this.v[l] = Long.rotateLeft(this.v[l] ^ this.v[i], -32);
            int n2 = k;
            this.v[n2] = this.v[n2] + this.v[l];
            this.v[j] = Long.rotateLeft(this.v[j] ^ this.v[k], -24);
            int n3 = i;
            this.v[n3] = this.v[n3] + (b + this.v[j]);
            this.v[l] = Long.rotateLeft(this.v[l] ^ this.v[i], -16);
            int n4 = k;
            this.v[n4] = this.v[n4] + this.v[l];
            this.v[j] = Long.rotateLeft(this.v[j] ^ this.v[k], -63);
        }
    }
}

