/*
 * Decompiled with CFR 0.152.
 */
package org.tron.consensus.pbft.message;

import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.security.SignatureException;
import java.util.stream.Collectors;
import org.bouncycastle.util.encoders.Hex;
import org.tron.common.crypto.ECKey;
import org.tron.common.overlay.message.Message;
import org.tron.common.utils.ByteUtil;
import org.tron.common.utils.Sha256Hash;
import org.tron.common.utils.StringUtil;
import org.tron.core.capsule.TransactionCapsule;
import org.tron.core.exception.P2pException;
import org.tron.protos.Protocol;

public abstract class PbftBaseMessage
extends Message {
    protected Protocol.PBFTMessage pbftMessage;
    private boolean isSwitch;
    private byte[] publicKey;

    public PbftBaseMessage() {
    }

    public PbftBaseMessage(byte type, byte[] data) throws IOException, P2pException {
        super(type, data);
        this.pbftMessage = Protocol.PBFTMessage.parseFrom((CodedInputStream)PbftBaseMessage.getCodedInputStream((byte[])data));
        if (PbftBaseMessage.isFilter()) {
            PbftBaseMessage.compareBytes((byte[])data, (byte[])this.pbftMessage.toByteArray());
        }
    }

    public Class<?> getAnswerMessage() {
        return null;
    }

    public Protocol.PBFTMessage getPbftMessage() {
        return this.pbftMessage;
    }

    public PbftBaseMessage setPbftMessage(Protocol.PBFTMessage pbftMessage) {
        this.pbftMessage = pbftMessage;
        return this;
    }

    public boolean isSwitch() {
        return this.isSwitch;
    }

    public PbftBaseMessage setSwitch(boolean aSwitch) {
        this.isSwitch = aSwitch;
        return this;
    }

    public PbftBaseMessage setData(byte[] data) {
        this.data = data;
        return this;
    }

    public PbftBaseMessage setType(byte type) {
        this.type = type;
        return this;
    }

    public byte[] getPublicKey() {
        return this.publicKey;
    }

    public String getKey() {
        return this.getNo() + "_" + Hex.toHexString((byte[])this.publicKey);
    }

    public String getDataKey() {
        return this.getNo() + "_" + Hex.toHexString((byte[])this.pbftMessage.getRawData().getData().toByteArray());
    }

    public long getNumber() {
        return this.pbftMessage.getRawData().getViewN();
    }

    public long getEpoch() {
        return this.pbftMessage.getRawData().getEpoch();
    }

    public Protocol.PBFTMessage.DataType getDataType() {
        return this.pbftMessage.getRawData().getDataType();
    }

    public abstract String getNo();

    public void analyzeSignature() throws SignatureException {
        byte[] hash = Sha256Hash.hash((boolean)true, (byte[])this.getPbftMessage().getRawData().toByteArray());
        this.publicKey = ECKey.signatureToAddress((byte[])hash, (String)TransactionCapsule.getBase64FromByteString((ByteString)this.getPbftMessage().getSignature()));
    }

    public String toString() {
        return "DataType:" + this.getDataType() + ", MsgType:" + this.pbftMessage.getRawData().getMsgType() + ", node address:" + (ByteUtil.isNullOrZeroArray((byte[])this.publicKey) ? null : Hex.toHexString((byte[])this.publicKey)) + ", viewN:" + this.pbftMessage.getRawData().getViewN() + ", epoch:" + this.pbftMessage.getRawData().getEpoch() + ", data:" + this.getDataString() + ", " + super.toString();
    }

    public String getDataString() {
        return this.getDataType() == Protocol.PBFTMessage.DataType.SRL ? this.decode() : Hex.toHexString((byte[])this.pbftMessage.getRawData().getData().toByteArray());
    }

    private String decode() {
        try {
            Protocol.SRL srList = Protocol.SRL.parseFrom((byte[])this.pbftMessage.getRawData().getData().toByteArray());
            return "sr list = " + srList.getSrAddressList().stream().map(bytes -> StringUtil.encode58Check((byte[])bytes.toByteArray())).collect(Collectors.toList());
        }
        catch (InvalidProtocolBufferException invalidProtocolBufferException) {
            return "decode error";
        }
    }
}

