/*
 * Decompiled with CFR 0.152.
 */
package org.tron.consensus.pbft;

import com.google.protobuf.ByteString;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.consensus.base.Param;
import org.tron.consensus.dpos.MaintenanceManager;
import org.tron.consensus.pbft.PbftMessageHandle;
import org.tron.consensus.pbft.message.PbftBaseMessage;
import org.tron.consensus.pbft.message.PbftMessage;
import org.tron.core.ChainBaseManager;
import org.tron.core.capsule.BlockCapsule;

@Component
public class PbftManager {
    private static final Logger logger = LoggerFactory.getLogger((String)"pbft");
    @Autowired
    private PbftMessageHandle pbftMessageHandle;
    @Autowired
    private MaintenanceManager maintenanceManager;
    @Autowired
    private ChainBaseManager chainBaseManager;
    private ExecutorService executorService = Executors.newFixedThreadPool(10, r -> new Thread(r, "Pbft"));

    @PostConstruct
    public void init() {
        this.maintenanceManager.setPbftManager(this);
        this.pbftMessageHandle.setMaintenanceManager(this.maintenanceManager);
    }

    public void blockPrePrepare(BlockCapsule block, long epoch) {
        if (!this.chainBaseManager.getDynamicPropertiesStore().allowPBFT()) {
            return;
        }
        if (!this.pbftMessageHandle.isSyncing()) {
            if (Param.getInstance().isEnable()) {
                for (Param.Miner miner : this.pbftMessageHandle.getSrMinerList(epoch)) {
                    this.doAction(PbftMessage.prePrepareBlockMsg(block, epoch, miner));
                }
            } else {
                this.doAction(PbftMessage.fullNodePrePrepareBlockMsg(block, epoch));
            }
        }
    }

    public void srPrePrepare(BlockCapsule block, List<ByteString> currentWitness, long epoch) {
        if (!this.chainBaseManager.getDynamicPropertiesStore().allowPBFT()) {
            return;
        }
        if (!this.pbftMessageHandle.isSyncing()) {
            if (Param.getInstance().isEnable()) {
                for (Param.Miner miner : this.pbftMessageHandle.getSrMinerList(epoch)) {
                    this.doAction(PbftMessage.prePrepareSRLMsg(block, currentWitness, epoch, miner));
                }
            } else {
                this.doAction(PbftMessage.fullNodePrePrepareSRLMsg(block, currentWitness, epoch));
            }
        }
    }

    public void forwardMessage(PbftBaseMessage message) {
        this.pbftMessageHandle.forwardMessage(message);
    }

    public boolean doAction(PbftMessage msg) {
        this.executorService.submit(() -> {
            logger.info("receive pbft msg: {}", (Object)msg);
            switch (msg.getPbftMessage().getRawData().getMsgType()) {
                case PREPREPARE: {
                    this.pbftMessageHandle.onPrePrepare(msg);
                    break;
                }
                case PREPARE: {
                    this.pbftMessageHandle.onPrepare(msg);
                    break;
                }
                case COMMIT: {
                    this.pbftMessageHandle.onCommit(msg);
                    break;
                }
                case REQUEST: {
                    this.pbftMessageHandle.onRequestData(msg);
                    break;
                }
                case VIEW_CHANGE: {
                    this.pbftMessageHandle.onChangeView(msg);
                    break;
                }
            }
        });
        return true;
    }

    public boolean verifyMsg(PbftBaseMessage msg) {
        long epoch = msg.getPbftMessage().getRawData().getEpoch();
        List<ByteString> witnessList = epoch > this.maintenanceManager.getBeforeMaintenanceTime() ? this.maintenanceManager.getCurrentWitness() : this.maintenanceManager.getBeforeWitness();
        return witnessList.contains(ByteString.copyFrom((byte[])msg.getPublicKey()));
    }
}

