/*
 * Decompiled with CFR 0.152.
 */
package org.tron.consensus.dpos;

import com.google.protobuf.ByteString;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.consensus.ConsensusDelegate;
import org.tron.consensus.base.State;
import org.tron.consensus.dpos.DposService;
import org.tron.core.capsule.BlockCapsule;

@Component
public class StateManager {
    private static final Logger logger = LoggerFactory.getLogger((String)"consensus");
    @Autowired
    private ConsensusDelegate consensusDelegate;
    private DposService dposService;
    private volatile BlockCapsule.BlockId currentBlockId;
    private AtomicInteger dupBlockCount = new AtomicInteger(0);
    private AtomicLong dupBlockTime = new AtomicLong(0L);
    private long blockCycle = 81000L;

    public State getState() {
        int minParticipationRate;
        if (System.currentTimeMillis() < this.consensusDelegate.getLatestBlockHeaderTimestamp()) {
            return State.CLOCK_ERROR;
        }
        State status = this.dposService.getBlockHandle().getState();
        if (!State.OK.equals((Object)status)) {
            return status;
        }
        if (this.isDupWitness()) {
            return State.DUP_WITNESS;
        }
        int participation = this.consensusDelegate.calculateFilledSlotsCount();
        if (participation < (minParticipationRate = this.dposService.getMinParticipationRate())) {
            logger.warn("Participation:{} <  minParticipationRate:{}", (Object)participation, (Object)minParticipationRate);
            return State.LOW_PARTICIPATION;
        }
        return State.OK;
    }

    public void receiveBlock(BlockCapsule blockCapsule) {
        if (blockCapsule.generatedByMyself) {
            this.currentBlockId = blockCapsule.getBlockId();
            return;
        }
        if (blockCapsule.getBlockId().equals((Object)this.currentBlockId)) {
            return;
        }
        if (this.dposService.isNeedSyncCheck()) {
            return;
        }
        if (System.currentTimeMillis() - blockCapsule.getTimeStamp() > 3000L) {
            return;
        }
        ByteString witness = blockCapsule.getWitnessAddress();
        if (!this.dposService.getMiners().containsKey(witness)) {
            return;
        }
        if (this.dposService.getBlockHandle().getState() != State.OK) {
            this.dupBlockCount.set(1);
            return;
        }
        if (null != this.currentBlockId && this.currentBlockId.toString().compareTo(blockCapsule.getBlockId().toString()) > 0) {
            return;
        }
        this.dupBlockCount.set(1);
        this.dupBlockTime.set(System.currentTimeMillis());
        logger.warn("Dup block produced: {}", (Object)blockCapsule);
    }

    private boolean isDupWitness() {
        if (this.dupBlockCount.get() == 0) {
            return false;
        }
        if (System.currentTimeMillis() - this.dupBlockTime.get() > (long)this.dupBlockCount.get() * this.blockCycle) {
            this.dupBlockCount.set(0);
            return false;
        }
        return true;
    }

    public void setDposService(DposService dposService) {
        this.dposService = dposService;
    }

    public void setCurrentBlockId(BlockCapsule.BlockId currentBlockId) {
        this.currentBlockId = currentBlockId;
    }
}

