/*
 * Decompiled with CFR 0.152.
 */
package org.tron.consensus.dpos;

import com.google.protobuf.ByteString;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.tron.common.parameter.CommonParameter;
import org.tron.common.utils.ByteArray;
import org.tron.common.utils.Sha256Hash;
import org.tron.consensus.ConsensusDelegate;
import org.tron.consensus.base.Param;
import org.tron.consensus.base.State;
import org.tron.consensus.dpos.DposService;
import org.tron.consensus.dpos.DposSlot;
import org.tron.consensus.dpos.StateManager;
import org.tron.core.capsule.BlockCapsule;
import org.tron.protos.Protocol;

@Component
public class DposTask {
    private static final Logger logger = LoggerFactory.getLogger((String)"consensus");
    @Autowired
    private ConsensusDelegate consensusDelegate;
    @Autowired
    private DposSlot dposSlot;
    @Autowired
    private StateManager stateManager;
    private DposService dposService;
    private Thread produceThread;
    private volatile boolean isRunning = true;

    public void init() {
        if (!this.dposService.isEnable() || StringUtils.isEmpty(this.dposService.getMiners())) {
            return;
        }
        Runnable runnable = () -> {
            while (this.isRunning) {
                try {
                    if (this.dposService.isNeedSyncCheck()) {
                        Thread.sleep(1000L);
                        this.dposService.setNeedSyncCheck(this.dposSlot.getTime(1L) < System.currentTimeMillis());
                        continue;
                    }
                    long time = 3000L - System.currentTimeMillis() % 3000L;
                    Thread.sleep(time);
                    State state = this.produceBlock();
                    if (State.OK.equals((Object)state)) continue;
                    logger.info("Produce block failed: {}", (Object)state);
                }
                catch (InterruptedException e) {
                    logger.warn("Produce block task interrupted.");
                    Thread.currentThread().interrupt();
                }
                catch (Throwable throwable) {
                    logger.error("Produce block error.", throwable);
                }
            }
        };
        this.produceThread = new Thread(runnable, "DPosMiner");
        this.produceThread.start();
        logger.info("DPoS task started.");
    }

    public void stop() {
        this.isRunning = false;
        if (this.produceThread != null) {
            this.produceThread.interrupt();
        }
        logger.info("DPoS task stopped.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private State produceBlock() {
        Param.Miner miner;
        long slot;
        block12: {
            State state = this.stateManager.getState();
            if (!State.OK.equals((Object)state)) {
                return state;
            }
            this.dposService.getBlockHandle().setBlockWaitLock(true);
            Object object = this.dposService.getBlockHandle().getLock();
            // MONITORENTER : object
            slot = this.dposSlot.getSlot(System.currentTimeMillis() + 50L);
            if (slot == 0L) {
                State state2 = State.NOT_TIME_YET;
                // MONITOREXIT : object
                this.dposService.getBlockHandle().setBlockWaitLock(false);
                return state2;
            }
            ByteString pWitness = this.dposSlot.getScheduledWitness(slot);
            miner = this.dposService.getMiners().get(pWitness);
            if (miner != null) break block12;
            State state3 = State.NOT_MY_TURN;
            this.dposService.getBlockHandle().setBlockWaitLock(false);
            return state3;
        }
        long pTime = this.dposSlot.getTime(slot);
        long timeout = pTime + (long)(1500 * this.dposService.getBlockProduceTimeoutPercent() / 100);
        BlockCapsule blockCapsule = this.dposService.getBlockHandle().produce(miner, pTime, timeout);
        if (blockCapsule == null) {
            State state = State.PRODUCE_BLOCK_FAILED;
            // MONITOREXIT : object
            this.dposService.getBlockHandle().setBlockWaitLock(false);
            return state;
        }
        try {
            Protocol.BlockHeader.raw raw2 = blockCapsule.getInstance().getBlockHeader().getRawData();
            logger.info("Produce block successfully, num: {}, time: {}, witness: {}, ID:{}, parentID:{}", new Object[]{raw2.getNumber(), new DateTime(raw2.getTimestamp()), ByteArray.toHexString((byte[])raw2.getWitnessAddress().toByteArray()), new Sha256Hash(raw2.getNumber(), Sha256Hash.of((boolean)CommonParameter.getInstance().isECKeyCryptoEngine(), (byte[])raw2.toByteArray())), ByteArray.toHexString((byte[])raw2.getParentHash().toByteArray())});
            // MONITOREXIT : object
            return State.OK;
        }
        finally {
            this.dposService.getBlockHandle().setBlockWaitLock(false);
        }
    }

    public void setDposService(DposService dposService) {
        this.dposService = dposService;
    }
}

