/*
 * Decompiled with CFR 0.152.
 */
package org.tron.consensus;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.consensus.base.ConsensusInterface;
import org.tron.consensus.base.Param;
import org.tron.consensus.dpos.DposService;
import org.tron.core.capsule.BlockCapsule;

@Component
public class Consensus {
    private static final Logger logger = LoggerFactory.getLogger((String)"consensus");
    @Autowired
    private DposService dposService;
    private ConsensusInterface consensusInterface;

    public void start(Param param) {
        this.consensusInterface = this.dposService;
        this.consensusInterface.start(param);
    }

    public void stop() {
        this.consensusInterface = this.dposService;
        this.consensusInterface.stop();
    }

    public void receiveBlock(BlockCapsule blockCapsule) {
        this.consensusInterface.receiveBlock(blockCapsule);
    }

    public boolean validBlock(BlockCapsule blockCapsule) {
        return this.consensusInterface.validBlock(blockCapsule);
    }

    public boolean applyBlock(BlockCapsule blockCapsule) {
        return this.consensusInterface.applyBlock(blockCapsule);
    }
}

