/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.prometheus;

import io.prometheus.client.Gauge;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.prometheus.Metrics;

class MetricsGauge {
    private static final Logger logger = LoggerFactory.getLogger((String)"metrics");
    private static final Map<String, Gauge> container = new ConcurrentHashMap<String, Gauge>();

    private MetricsGauge() {
        throw new IllegalStateException("MetricsGauge");
    }

    private static void init(String name, String help, String ... labels) {
        container.put(name, (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name(name)).help(help)).labelNames(labels)).register());
    }

    static void inc(String key, double delta, String ... labels) {
        if (Metrics.enabled()) {
            Gauge gauge = container.get(key);
            if (gauge == null) {
                logger.info("{} not exist", (Object)key);
                return;
            }
            ((Gauge.Child)gauge.labels(labels)).inc(delta);
        }
    }

    static void set(String key, double v, String ... labels) {
        if (Metrics.enabled()) {
            Gauge gauge = container.get(key);
            if (gauge == null) {
                logger.info("{} not exist", (Object)key);
                return;
            }
            ((Gauge.Child)gauge.labels(labels)).set(v);
        }
    }

    static {
        MetricsGauge.init("tron:manager_queue_size", "tron  manager.queue.size .", "type");
        MetricsGauge.init("tron:header_height", "header  height .", new String[0]);
        MetricsGauge.init("tron:header_time", "header time .", new String[0]);
        MetricsGauge.init("tron:peers", "tron peers.size .", "type");
        MetricsGauge.init("tron:db_size_bytes", "tron  db  size .", "type", "db", "level");
        MetricsGauge.init("tron:db_sst_level", "tron  db  files .", "type", "db", "level");
        MetricsGauge.init("tron:tx_cache", "tron tx cache info.", "type");
    }
}

