/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.parameter;

import com.beust.jcommander.Parameter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.quartz.CronExpression;
import org.tron.common.args.GenesisBlock;
import org.tron.common.config.DbBackupConfig;
import org.tron.common.logsfilter.EventPluginConfig;
import org.tron.common.logsfilter.FilterQuery;
import org.tron.common.parameter.RateLimiterInitialization;
import org.tron.common.setting.RocksDbSettings;
import org.tron.core.config.args.Overlay;
import org.tron.core.config.args.SeedNode;
import org.tron.core.config.args.Storage;
import org.tron.p2p.P2pConfig;
import org.tron.p2p.dns.update.PublishConfig;

public class CommonParameter {
    public static final String IGNORE_WRONG_WITNESS_ADDRESS_FORMAT = "The localWitnessAccountAddress format is incorrect, ignored";
    public static CommonParameter PARAMETER = new CommonParameter();
    public static boolean ENERGY_LIMIT_HARD_FORK = false;
    @Parameter(names={"-c", "--config"}, description="Config file (default:config.conf)")
    public String shellConfFileName = "";
    @Parameter(names={"-d", "--output-directory"}, description="Data directory for the databases (default:output-directory)")
    public String outputDirectory = "output-directory";
    @Parameter(names={"--log-config"}, description="Logback config file")
    public String logbackPath = "";
    @Parameter(names={"-h", "--help"}, help=true, description="Show help message")
    public boolean help = false;
    @Parameter(names={"-w", "--witness"}, description="Is witness node")
    public boolean witness = false;
    @Parameter(names={"--support-constant"}, description="Support constant calling for TVM. (defalut: false)")
    public boolean supportConstant = false;
    @Parameter(names={"--max-energy-limit-for-constant"}, description="Max energy limit for constant calling. (default: 100,000,000)")
    public long maxEnergyLimitForConstant = 100000000L;
    @Parameter(names={"--lru-cache-size"}, description="Max LRU size for caching bytecode and result of JUMPDEST analysis. (default: 500)")
    public int lruCacheSize = 500;
    @Parameter(names={"--debug"}, description="Switch for TVM debug mode. In debug model, TVM will not check for timeout. (default: false)")
    public boolean debug = false;
    @Parameter(names={"--min-time-ratio"}, description="Maximum CPU tolerance when executing non-timeout transactions while synchronizing blocks. (default: 5.0)")
    public double minTimeRatio = 0.0;
    @Parameter(names={"--max-time-ratio"}, description="Maximum CPU tolerance when executing timeout transactions while synchronizing blocks. (default: 0.0)")
    public double maxTimeRatio = CommonParameter.calcMaxTimeRatio();
    @Parameter(names={"--save-internaltx"}, description="Save internal transactions generated during TVM execution, such as create, call and suicide. (default: false)")
    public boolean saveInternalTx;
    @Parameter(names={"--save-featured-internaltx"}, description="Save featured internal transactions generated during TVM execution, such as freeze, vote and so on. (default: false)")
    public boolean saveFeaturedInternalTx;
    @Parameter(names={"--long-running-time"})
    public int longRunningTime = 10;
    @Parameter(names={"--max-connect-number"}, description="Http server max connect number (default:50)")
    public int maxHttpConnectNumber = 50;
    @Parameter(description="--seed-nodes")
    public List<String> seedNodes = new ArrayList<String>();
    @Parameter(names={"-p", "--private-key"}, description="Witness private key")
    public String privateKey = "";
    @Parameter(names={"--witness-address"}, description="witness-address")
    public String witnessAddress = "";
    @Parameter(names={"--password"}, description="password")
    public String password;
    @Parameter(names={"--storage-db-directory"}, description="Storage db directory")
    public String storageDbDirectory = "";
    @Parameter(names={"--storage-db-engine"}, description="Storage db engine.(leveldb or rocksdb)")
    public String storageDbEngine = "";
    @Parameter(names={"--storage-db-synchronous"}, description="Storage db is synchronous or not.(true or false)")
    public String storageDbSynchronous = "";
    @Parameter(names={"--contract-parse-enable"}, description="Switch for contract parses in java-tron. (default: true)")
    public String contractParseEnable = "";
    @Parameter(names={"--storage-index-directory"}, description="Storage index directory")
    public String storageIndexDirectory = "";
    @Parameter(names={"--storage-index-switch"}, description="Storage index switch.(on or off)")
    public String storageIndexSwitch = "";
    @Parameter(names={"--storage-transactionHistory-switch"}, description="Storage transaction history switch.(on or off)")
    public String storageTransactionHistorySwitch = "";
    @Parameter(names={"--fast-forward"})
    public boolean fastForward = false;
    public String chainId;
    public boolean needSyncCheck;
    public boolean nodeDiscoveryEnable;
    public boolean nodeDiscoveryPersist;
    public boolean nodeEffectiveCheckEnable;
    public int nodeConnectionTimeout;
    public int fetchBlockTimeout;
    public int nodeChannelReadTimeout;
    public int maxConnections;
    public int minConnections;
    public int minActiveConnections;
    public int maxConnectionsWithSameIp;
    public int maxTps;
    public int minParticipationRate;
    public P2pConfig p2pConfig;
    public int nodeListenPort;
    public String nodeDiscoveryBindIp;
    public String nodeExternalIp;
    public int nodeP2pVersion;
    public boolean nodeEnableIpv6 = false;
    public List<String> dnsTreeUrls;
    public PublishConfig dnsPublishConfig;
    public long syncFetchBatchNum;
    public boolean solidityNode = false;
    public int rpcPort;
    public int rpcOnSolidityPort;
    public int fullNodeHttpPort;
    public int solidityHttpPort;
    public int jsonRpcHttpFullNodePort;
    public int jsonRpcHttpSolidityPort;
    public int jsonRpcHttpPBFTPort;
    @Parameter(names={"--rpc-thread"}, description="Num of gRPC thread")
    public int rpcThreadNum;
    @Parameter(names={"--solidity-thread"}, description="Num of solidity thread")
    public int solidityThreads;
    public int maxConcurrentCallsPerConnection;
    public int flowControlWindow;
    public long maxConnectionIdleInMillis;
    public int blockProducedTimeOut;
    public long netMaxTrxPerSecond;
    public long maxConnectionAgeInMillis;
    public int maxMessageSize;
    public int maxHeaderListSize;
    @Parameter(names={"--validate-sign-thread"}, description="Num of validate thread")
    public int validateSignThreadNum;
    public long maintenanceTimeInterval;
    public long proposalExpireTime;
    public int checkFrozenTime;
    public long allowCreationOfContracts;
    public long allowAdaptiveEnergy;
    public long allowDelegateResource;
    public long allowSameTokenName;
    public long allowTvmTransferTrc10;
    public long allowTvmConstantinople;
    public long allowTvmSolidity059;
    public long forbidTransferToContract;
    public int tcpNettyWorkThreadNum;
    public int udpNettyWorkThreadNum;
    @Parameter(names={"--trust-node"}, description="Trust node addr")
    public String trustNodeAddr;
    public boolean walletExtensionApi;
    public boolean estimateEnergy;
    public int estimateEnergyMaxRetry;
    public int backupPriority;
    public int backupPort;
    public int keepAliveInterval;
    public List<String> backupMembers;
    public long receiveTcpMinDataLength;
    public boolean isOpenFullTcpDisconnect;
    public boolean nodeDetectEnable;
    public int allowMultiSign;
    public boolean vmTrace;
    public boolean needToUpdateAsset;
    public String trxReferenceBlock;
    public int minEffectiveConnection;
    public boolean trxCacheEnable;
    public long allowMarketTransaction;
    public long allowTransactionFeePool;
    public long allowBlackHoleOptimization;
    public long allowNewResourceModel;
    public boolean fullNodeAllowShieldedTransactionArgs;
    public long blockNumForEnergyLimit;
    @Parameter(names={"--es"}, description="Start event subscribe server")
    public boolean eventSubscribe = false;
    public long trxExpirationTimeInMilliseconds;
    @Parameter(names={"-v", "--version"}, description="Output code version", help=true)
    public boolean version;
    public String zenTokenId;
    public long allowProtoFilterNum;
    public long allowAccountStateRoot;
    public int validContractProtoThreadNum = 1;
    public int shieldedTransInPendingMaxCounts;
    public long changedDelegation;
    public Set<String> actuatorSet;
    public RateLimiterInitialization rateLimiterInitialization;
    public int rateLimiterGlobalQps;
    public int rateLimiterGlobalIpQps;
    public DbBackupConfig dbBackupConfig;
    public RocksDbSettings rocksDBCustomSettings;
    public GenesisBlock genesisBlock;
    @Parameter(names={"--p2p-disable"}, description="Switch for p2p module initialization. (defalut: false)", arity=1)
    public boolean p2pDisable = false;
    public List<InetSocketAddress> activeNodes;
    public List<InetAddress> passiveNodes;
    public List<InetSocketAddress> fastForwardNodes;
    public int maxFastForwardNum;
    public Storage storage;
    public Overlay overlay;
    public SeedNode seedNode;
    public EventPluginConfig eventPluginConfig;
    public FilterQuery eventFilter;
    public String cryptoEngine = "ECKey";
    public boolean fullNodeHttpEnable = true;
    public boolean solidityNodeHttpEnable = true;
    public boolean jsonRpcHttpFullNodeEnable = false;
    public boolean jsonRpcHttpSolidityNodeEnable = false;
    public boolean jsonRpcHttpPBFTNodeEnable = false;
    public int maxTransactionPendingSize;
    public long pendingTransactionTimeout;
    public boolean nodeMetricsEnable = false;
    public boolean metricsStorageEnable = false;
    public String influxDbIp;
    public int influxDbPort;
    public String influxDbDatabase;
    public int metricsReportInterval = 10;
    public boolean metricsPrometheusEnable = false;
    public int metricsPrometheusPort;
    public int agreeNodeCount;
    public long allowPBFT;
    public int rpcOnPBFTPort;
    public int pBFTHttpPort;
    public long oldSolidityBlockNum = -1L;
    public long allowShieldedTRC20Transaction;
    public long allowTvmIstanbul;
    public long allowTvmFreeze;
    public long allowTvmVote;
    public long allowTvmLondon;
    public long allowTvmCompatibleEvm;
    public long allowHigherLimitForMaxCpuTimeOfOneTx;
    public boolean openHistoryQueryWhenLiteFN = false;
    @Parameter(names={"--history-balance-lookup"})
    public boolean historyBalanceLookup = false;
    public boolean openPrintLog = true;
    public boolean openTransactionSort = false;
    public long allowAccountAssetOptimization;
    public long allowAssetOptimization;
    public List<String> disabledApiList;
    public CronExpression shutdownBlockTime = null;
    public long shutdownBlockHeight = -1L;
    public long shutdownBlockCount = -1L;
    public long blockCacheTimeout = 60L;
    public long allowNewRewardAlgorithm;
    public long allowNewReward = 0L;
    public long memoFee = 0L;
    public long allowDelegateOptimization = 0L;
    public long unfreezeDelayDays = 0L;
    public long allowOptimizedReturnValueOfChainId = 0L;
    public long allowDynamicEnergy = 0L;
    public long dynamicEnergyThreshold = 0L;
    public long dynamicEnergyIncreaseFactor = 0L;
    public long dynamicEnergyMaxFactor = 0L;
    public boolean dynamicConfigEnable;
    public long dynamicConfigCheckInterval;
    public long allowTvmShangHai;
    public long allowCancelAllUnfreezeV2;

    private static double calcMaxTimeRatio() {
        return 5.0;
    }

    public static CommonParameter getInstance() {
        return PARAMETER;
    }

    public boolean isECKeyCryptoEngine() {
        return this.cryptoEngine.equalsIgnoreCase("ECKey");
    }

    public boolean isJsonRpcFilterEnabled() {
        return this.jsonRpcHttpFullNodeEnable || this.jsonRpcHttpSolidityNodeEnable;
    }

    public int getSafeLruCacheSize() {
        return this.lruCacheSize < 1 ? 500 : this.lruCacheSize;
    }

    public static void setENERGY_LIMIT_HARD_FORK(boolean ENERGY_LIMIT_HARD_FORK) {
        CommonParameter.ENERGY_LIMIT_HARD_FORK = ENERGY_LIMIT_HARD_FORK;
    }

    public String getShellConfFileName() {
        return this.shellConfFileName;
    }

    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    public String getLogbackPath() {
        return this.logbackPath;
    }

    public boolean isHelp() {
        return this.help;
    }

    public boolean isWitness() {
        return this.witness;
    }

    public void setWitness(boolean witness) {
        this.witness = witness;
    }

    public boolean isSupportConstant() {
        return this.supportConstant;
    }

    public void setSupportConstant(boolean supportConstant) {
        this.supportConstant = supportConstant;
    }

    public long getMaxEnergyLimitForConstant() {
        return this.maxEnergyLimitForConstant;
    }

    public void setMaxEnergyLimitForConstant(long maxEnergyLimitForConstant) {
        this.maxEnergyLimitForConstant = maxEnergyLimitForConstant;
    }

    public int getLruCacheSize() {
        return this.lruCacheSize;
    }

    public void setLruCacheSize(int lruCacheSize) {
        this.lruCacheSize = lruCacheSize;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public double getMinTimeRatio() {
        return this.minTimeRatio;
    }

    public void setMinTimeRatio(double minTimeRatio) {
        this.minTimeRatio = minTimeRatio;
    }

    public double getMaxTimeRatio() {
        return this.maxTimeRatio;
    }

    public void setMaxTimeRatio(double maxTimeRatio) {
        this.maxTimeRatio = maxTimeRatio;
    }

    public boolean isSaveInternalTx() {
        return this.saveInternalTx;
    }

    public void setSaveInternalTx(boolean saveInternalTx) {
        this.saveInternalTx = saveInternalTx;
    }

    public boolean isSaveFeaturedInternalTx() {
        return this.saveFeaturedInternalTx;
    }

    public void setSaveFeaturedInternalTx(boolean saveFeaturedInternalTx) {
        this.saveFeaturedInternalTx = saveFeaturedInternalTx;
    }

    public int getLongRunningTime() {
        return this.longRunningTime;
    }

    public void setLongRunningTime(int longRunningTime) {
        this.longRunningTime = longRunningTime;
    }

    public int getMaxHttpConnectNumber() {
        return this.maxHttpConnectNumber;
    }

    public void setMaxHttpConnectNumber(int maxHttpConnectNumber) {
        this.maxHttpConnectNumber = maxHttpConnectNumber;
    }

    public List<String> getSeedNodes() {
        return this.seedNodes;
    }

    public boolean isFastForward() {
        return this.fastForward;
    }

    public String getChainId() {
        return this.chainId;
    }

    public void setChainId(String chainId) {
        this.chainId = chainId;
    }

    public boolean isNeedSyncCheck() {
        return this.needSyncCheck;
    }

    public void setNeedSyncCheck(boolean needSyncCheck) {
        this.needSyncCheck = needSyncCheck;
    }

    public boolean isNodeDiscoveryEnable() {
        return this.nodeDiscoveryEnable;
    }

    public void setNodeDiscoveryEnable(boolean nodeDiscoveryEnable) {
        this.nodeDiscoveryEnable = nodeDiscoveryEnable;
    }

    public boolean isNodeDiscoveryPersist() {
        return this.nodeDiscoveryPersist;
    }

    public void setNodeDiscoveryPersist(boolean nodeDiscoveryPersist) {
        this.nodeDiscoveryPersist = nodeDiscoveryPersist;
    }

    public boolean isNodeEffectiveCheckEnable() {
        return this.nodeEffectiveCheckEnable;
    }

    public void setNodeEffectiveCheckEnable(boolean nodeEffectiveCheckEnable) {
        this.nodeEffectiveCheckEnable = nodeEffectiveCheckEnable;
    }

    public int getNodeConnectionTimeout() {
        return this.nodeConnectionTimeout;
    }

    public void setNodeConnectionTimeout(int nodeConnectionTimeout) {
        this.nodeConnectionTimeout = nodeConnectionTimeout;
    }

    public int getFetchBlockTimeout() {
        return this.fetchBlockTimeout;
    }

    public void setFetchBlockTimeout(int fetchBlockTimeout) {
        this.fetchBlockTimeout = fetchBlockTimeout;
    }

    public int getNodeChannelReadTimeout() {
        return this.nodeChannelReadTimeout;
    }

    public void setNodeChannelReadTimeout(int nodeChannelReadTimeout) {
        this.nodeChannelReadTimeout = nodeChannelReadTimeout;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public int getMinConnections() {
        return this.minConnections;
    }

    public void setMinConnections(int minConnections) {
        this.minConnections = minConnections;
    }

    public int getMinActiveConnections() {
        return this.minActiveConnections;
    }

    public void setMinActiveConnections(int minActiveConnections) {
        this.minActiveConnections = minActiveConnections;
    }

    public int getMaxConnectionsWithSameIp() {
        return this.maxConnectionsWithSameIp;
    }

    public void setMaxConnectionsWithSameIp(int maxConnectionsWithSameIp) {
        this.maxConnectionsWithSameIp = maxConnectionsWithSameIp;
    }

    public int getMaxTps() {
        return this.maxTps;
    }

    public void setMaxTps(int maxTps) {
        this.maxTps = maxTps;
    }

    public int getMinParticipationRate() {
        return this.minParticipationRate;
    }

    public void setMinParticipationRate(int minParticipationRate) {
        this.minParticipationRate = minParticipationRate;
    }

    public P2pConfig getP2pConfig() {
        return this.p2pConfig;
    }

    public int getNodeListenPort() {
        return this.nodeListenPort;
    }

    public void setNodeListenPort(int nodeListenPort) {
        this.nodeListenPort = nodeListenPort;
    }

    public String getNodeDiscoveryBindIp() {
        return this.nodeDiscoveryBindIp;
    }

    public void setNodeDiscoveryBindIp(String nodeDiscoveryBindIp) {
        this.nodeDiscoveryBindIp = nodeDiscoveryBindIp;
    }

    public String getNodeExternalIp() {
        return this.nodeExternalIp;
    }

    public void setNodeExternalIp(String nodeExternalIp) {
        this.nodeExternalIp = nodeExternalIp;
    }

    public int getNodeP2pVersion() {
        return this.nodeP2pVersion;
    }

    public void setNodeP2pVersion(int nodeP2pVersion) {
        this.nodeP2pVersion = nodeP2pVersion;
    }

    public boolean isNodeEnableIpv6() {
        return this.nodeEnableIpv6;
    }

    public void setNodeEnableIpv6(boolean nodeEnableIpv6) {
        this.nodeEnableIpv6 = nodeEnableIpv6;
    }

    public List<String> getDnsTreeUrls() {
        return this.dnsTreeUrls;
    }

    public void setDnsTreeUrls(List<String> dnsTreeUrls) {
        this.dnsTreeUrls = dnsTreeUrls;
    }

    public PublishConfig getDnsPublishConfig() {
        return this.dnsPublishConfig;
    }

    public void setDnsPublishConfig(PublishConfig dnsPublishConfig) {
        this.dnsPublishConfig = dnsPublishConfig;
    }

    public long getSyncFetchBatchNum() {
        return this.syncFetchBatchNum;
    }

    public void setSyncFetchBatchNum(long syncFetchBatchNum) {
        this.syncFetchBatchNum = syncFetchBatchNum;
    }

    public boolean isSolidityNode() {
        return this.solidityNode;
    }

    public void setSolidityNode(boolean solidityNode) {
        this.solidityNode = solidityNode;
    }

    public int getRpcPort() {
        return this.rpcPort;
    }

    public void setRpcPort(int rpcPort) {
        this.rpcPort = rpcPort;
    }

    public int getRpcOnSolidityPort() {
        return this.rpcOnSolidityPort;
    }

    public void setRpcOnSolidityPort(int rpcOnSolidityPort) {
        this.rpcOnSolidityPort = rpcOnSolidityPort;
    }

    public int getFullNodeHttpPort() {
        return this.fullNodeHttpPort;
    }

    public void setFullNodeHttpPort(int fullNodeHttpPort) {
        this.fullNodeHttpPort = fullNodeHttpPort;
    }

    public int getSolidityHttpPort() {
        return this.solidityHttpPort;
    }

    public void setSolidityHttpPort(int solidityHttpPort) {
        this.solidityHttpPort = solidityHttpPort;
    }

    public int getJsonRpcHttpFullNodePort() {
        return this.jsonRpcHttpFullNodePort;
    }

    public void setJsonRpcHttpFullNodePort(int jsonRpcHttpFullNodePort) {
        this.jsonRpcHttpFullNodePort = jsonRpcHttpFullNodePort;
    }

    public int getJsonRpcHttpSolidityPort() {
        return this.jsonRpcHttpSolidityPort;
    }

    public void setJsonRpcHttpSolidityPort(int jsonRpcHttpSolidityPort) {
        this.jsonRpcHttpSolidityPort = jsonRpcHttpSolidityPort;
    }

    public int getJsonRpcHttpPBFTPort() {
        return this.jsonRpcHttpPBFTPort;
    }

    public void setJsonRpcHttpPBFTPort(int jsonRpcHttpPBFTPort) {
        this.jsonRpcHttpPBFTPort = jsonRpcHttpPBFTPort;
    }

    public int getRpcThreadNum() {
        return this.rpcThreadNum;
    }

    public void setRpcThreadNum(int rpcThreadNum) {
        this.rpcThreadNum = rpcThreadNum;
    }

    public int getSolidityThreads() {
        return this.solidityThreads;
    }

    public void setSolidityThreads(int solidityThreads) {
        this.solidityThreads = solidityThreads;
    }

    public int getMaxConcurrentCallsPerConnection() {
        return this.maxConcurrentCallsPerConnection;
    }

    public void setMaxConcurrentCallsPerConnection(int maxConcurrentCallsPerConnection) {
        this.maxConcurrentCallsPerConnection = maxConcurrentCallsPerConnection;
    }

    public int getFlowControlWindow() {
        return this.flowControlWindow;
    }

    public void setFlowControlWindow(int flowControlWindow) {
        this.flowControlWindow = flowControlWindow;
    }

    public long getMaxConnectionIdleInMillis() {
        return this.maxConnectionIdleInMillis;
    }

    public void setMaxConnectionIdleInMillis(long maxConnectionIdleInMillis) {
        this.maxConnectionIdleInMillis = maxConnectionIdleInMillis;
    }

    public int getBlockProducedTimeOut() {
        return this.blockProducedTimeOut;
    }

    public void setBlockProducedTimeOut(int blockProducedTimeOut) {
        this.blockProducedTimeOut = blockProducedTimeOut;
    }

    public long getNetMaxTrxPerSecond() {
        return this.netMaxTrxPerSecond;
    }

    public void setNetMaxTrxPerSecond(long netMaxTrxPerSecond) {
        this.netMaxTrxPerSecond = netMaxTrxPerSecond;
    }

    public long getMaxConnectionAgeInMillis() {
        return this.maxConnectionAgeInMillis;
    }

    public void setMaxConnectionAgeInMillis(long maxConnectionAgeInMillis) {
        this.maxConnectionAgeInMillis = maxConnectionAgeInMillis;
    }

    public int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public void setMaxMessageSize(int maxMessageSize) {
        this.maxMessageSize = maxMessageSize;
    }

    public int getMaxHeaderListSize() {
        return this.maxHeaderListSize;
    }

    public void setMaxHeaderListSize(int maxHeaderListSize) {
        this.maxHeaderListSize = maxHeaderListSize;
    }

    public int getValidateSignThreadNum() {
        return this.validateSignThreadNum;
    }

    public void setValidateSignThreadNum(int validateSignThreadNum) {
        this.validateSignThreadNum = validateSignThreadNum;
    }

    public long getMaintenanceTimeInterval() {
        return this.maintenanceTimeInterval;
    }

    public void setMaintenanceTimeInterval(long maintenanceTimeInterval) {
        this.maintenanceTimeInterval = maintenanceTimeInterval;
    }

    public long getProposalExpireTime() {
        return this.proposalExpireTime;
    }

    public void setProposalExpireTime(long proposalExpireTime) {
        this.proposalExpireTime = proposalExpireTime;
    }

    public int getCheckFrozenTime() {
        return this.checkFrozenTime;
    }

    public void setCheckFrozenTime(int checkFrozenTime) {
        this.checkFrozenTime = checkFrozenTime;
    }

    public long getAllowCreationOfContracts() {
        return this.allowCreationOfContracts;
    }

    public void setAllowCreationOfContracts(long allowCreationOfContracts) {
        this.allowCreationOfContracts = allowCreationOfContracts;
    }

    public long getAllowAdaptiveEnergy() {
        return this.allowAdaptiveEnergy;
    }

    public void setAllowAdaptiveEnergy(long allowAdaptiveEnergy) {
        this.allowAdaptiveEnergy = allowAdaptiveEnergy;
    }

    public long getAllowDelegateResource() {
        return this.allowDelegateResource;
    }

    public void setAllowDelegateResource(long allowDelegateResource) {
        this.allowDelegateResource = allowDelegateResource;
    }

    public long getAllowSameTokenName() {
        return this.allowSameTokenName;
    }

    public void setAllowSameTokenName(long allowSameTokenName) {
        this.allowSameTokenName = allowSameTokenName;
    }

    public long getAllowTvmTransferTrc10() {
        return this.allowTvmTransferTrc10;
    }

    public void setAllowTvmTransferTrc10(long allowTvmTransferTrc10) {
        this.allowTvmTransferTrc10 = allowTvmTransferTrc10;
    }

    public long getAllowTvmConstantinople() {
        return this.allowTvmConstantinople;
    }

    public void setAllowTvmConstantinople(long allowTvmConstantinople) {
        this.allowTvmConstantinople = allowTvmConstantinople;
    }

    public long getAllowTvmSolidity059() {
        return this.allowTvmSolidity059;
    }

    public void setAllowTvmSolidity059(long allowTvmSolidity059) {
        this.allowTvmSolidity059 = allowTvmSolidity059;
    }

    public long getForbidTransferToContract() {
        return this.forbidTransferToContract;
    }

    public void setForbidTransferToContract(long forbidTransferToContract) {
        this.forbidTransferToContract = forbidTransferToContract;
    }

    public int getTcpNettyWorkThreadNum() {
        return this.tcpNettyWorkThreadNum;
    }

    public void setTcpNettyWorkThreadNum(int tcpNettyWorkThreadNum) {
        this.tcpNettyWorkThreadNum = tcpNettyWorkThreadNum;
    }

    public int getUdpNettyWorkThreadNum() {
        return this.udpNettyWorkThreadNum;
    }

    public void setUdpNettyWorkThreadNum(int udpNettyWorkThreadNum) {
        this.udpNettyWorkThreadNum = udpNettyWorkThreadNum;
    }

    public String getTrustNodeAddr() {
        return this.trustNodeAddr;
    }

    public void setTrustNodeAddr(String trustNodeAddr) {
        this.trustNodeAddr = trustNodeAddr;
    }

    public boolean isWalletExtensionApi() {
        return this.walletExtensionApi;
    }

    public void setWalletExtensionApi(boolean walletExtensionApi) {
        this.walletExtensionApi = walletExtensionApi;
    }

    public boolean isEstimateEnergy() {
        return this.estimateEnergy;
    }

    public void setEstimateEnergy(boolean estimateEnergy) {
        this.estimateEnergy = estimateEnergy;
    }

    public int getEstimateEnergyMaxRetry() {
        return this.estimateEnergyMaxRetry;
    }

    public void setEstimateEnergyMaxRetry(int estimateEnergyMaxRetry) {
        this.estimateEnergyMaxRetry = estimateEnergyMaxRetry;
    }

    public int getBackupPriority() {
        return this.backupPriority;
    }

    public void setBackupPriority(int backupPriority) {
        this.backupPriority = backupPriority;
    }

    public int getBackupPort() {
        return this.backupPort;
    }

    public void setBackupPort(int backupPort) {
        this.backupPort = backupPort;
    }

    public int getKeepAliveInterval() {
        return this.keepAliveInterval;
    }

    public void setKeepAliveInterval(int keepAliveInterval) {
        this.keepAliveInterval = keepAliveInterval;
    }

    public List<String> getBackupMembers() {
        return this.backupMembers;
    }

    public void setBackupMembers(List<String> backupMembers) {
        this.backupMembers = backupMembers;
    }

    public long getReceiveTcpMinDataLength() {
        return this.receiveTcpMinDataLength;
    }

    public void setReceiveTcpMinDataLength(long receiveTcpMinDataLength) {
        this.receiveTcpMinDataLength = receiveTcpMinDataLength;
    }

    public boolean isOpenFullTcpDisconnect() {
        return this.isOpenFullTcpDisconnect;
    }

    public void setOpenFullTcpDisconnect(boolean isOpenFullTcpDisconnect) {
        this.isOpenFullTcpDisconnect = isOpenFullTcpDisconnect;
    }

    public boolean isNodeDetectEnable() {
        return this.nodeDetectEnable;
    }

    public void setNodeDetectEnable(boolean nodeDetectEnable) {
        this.nodeDetectEnable = nodeDetectEnable;
    }

    public int getAllowMultiSign() {
        return this.allowMultiSign;
    }

    public void setAllowMultiSign(int allowMultiSign) {
        this.allowMultiSign = allowMultiSign;
    }

    public boolean isVmTrace() {
        return this.vmTrace;
    }

    public void setVmTrace(boolean vmTrace) {
        this.vmTrace = vmTrace;
    }

    public boolean isNeedToUpdateAsset() {
        return this.needToUpdateAsset;
    }

    public void setNeedToUpdateAsset(boolean needToUpdateAsset) {
        this.needToUpdateAsset = needToUpdateAsset;
    }

    public String getTrxReferenceBlock() {
        return this.trxReferenceBlock;
    }

    public void setTrxReferenceBlock(String trxReferenceBlock) {
        this.trxReferenceBlock = trxReferenceBlock;
    }

    public int getMinEffectiveConnection() {
        return this.minEffectiveConnection;
    }

    public void setMinEffectiveConnection(int minEffectiveConnection) {
        this.minEffectiveConnection = minEffectiveConnection;
    }

    public boolean isTrxCacheEnable() {
        return this.trxCacheEnable;
    }

    public void setTrxCacheEnable(boolean trxCacheEnable) {
        this.trxCacheEnable = trxCacheEnable;
    }

    public long getAllowMarketTransaction() {
        return this.allowMarketTransaction;
    }

    public void setAllowMarketTransaction(long allowMarketTransaction) {
        this.allowMarketTransaction = allowMarketTransaction;
    }

    public long getAllowTransactionFeePool() {
        return this.allowTransactionFeePool;
    }

    public void setAllowTransactionFeePool(long allowTransactionFeePool) {
        this.allowTransactionFeePool = allowTransactionFeePool;
    }

    public long getAllowBlackHoleOptimization() {
        return this.allowBlackHoleOptimization;
    }

    public void setAllowBlackHoleOptimization(long allowBlackHoleOptimization) {
        this.allowBlackHoleOptimization = allowBlackHoleOptimization;
    }

    public long getAllowNewResourceModel() {
        return this.allowNewResourceModel;
    }

    public void setAllowNewResourceModel(long allowNewResourceModel) {
        this.allowNewResourceModel = allowNewResourceModel;
    }

    public boolean isFullNodeAllowShieldedTransactionArgs() {
        return this.fullNodeAllowShieldedTransactionArgs;
    }

    public void setFullNodeAllowShieldedTransactionArgs(boolean fullNodeAllowShieldedTransactionArgs) {
        this.fullNodeAllowShieldedTransactionArgs = fullNodeAllowShieldedTransactionArgs;
    }

    public long getBlockNumForEnergyLimit() {
        return this.blockNumForEnergyLimit;
    }

    public void setBlockNumForEnergyLimit(long blockNumForEnergyLimit) {
        this.blockNumForEnergyLimit = blockNumForEnergyLimit;
    }

    public boolean isEventSubscribe() {
        return this.eventSubscribe;
    }

    public void setEventSubscribe(boolean eventSubscribe) {
        this.eventSubscribe = eventSubscribe;
    }

    public long getTrxExpirationTimeInMilliseconds() {
        return this.trxExpirationTimeInMilliseconds;
    }

    public void setTrxExpirationTimeInMilliseconds(long trxExpirationTimeInMilliseconds) {
        this.trxExpirationTimeInMilliseconds = trxExpirationTimeInMilliseconds;
    }

    public String getZenTokenId() {
        return this.zenTokenId;
    }

    public void setZenTokenId(String zenTokenId) {
        this.zenTokenId = zenTokenId;
    }

    public long getAllowProtoFilterNum() {
        return this.allowProtoFilterNum;
    }

    public void setAllowProtoFilterNum(long allowProtoFilterNum) {
        this.allowProtoFilterNum = allowProtoFilterNum;
    }

    public long getAllowAccountStateRoot() {
        return this.allowAccountStateRoot;
    }

    public void setAllowAccountStateRoot(long allowAccountStateRoot) {
        this.allowAccountStateRoot = allowAccountStateRoot;
    }

    public int getValidContractProtoThreadNum() {
        return this.validContractProtoThreadNum;
    }

    public void setValidContractProtoThreadNum(int validContractProtoThreadNum) {
        this.validContractProtoThreadNum = validContractProtoThreadNum;
    }

    public int getShieldedTransInPendingMaxCounts() {
        return this.shieldedTransInPendingMaxCounts;
    }

    public void setShieldedTransInPendingMaxCounts(int shieldedTransInPendingMaxCounts) {
        this.shieldedTransInPendingMaxCounts = shieldedTransInPendingMaxCounts;
    }

    public long getChangedDelegation() {
        return this.changedDelegation;
    }

    public void setChangedDelegation(long changedDelegation) {
        this.changedDelegation = changedDelegation;
    }

    public Set<String> getActuatorSet() {
        return this.actuatorSet;
    }

    public void setActuatorSet(Set<String> actuatorSet) {
        this.actuatorSet = actuatorSet;
    }

    public RateLimiterInitialization getRateLimiterInitialization() {
        return this.rateLimiterInitialization;
    }

    public void setRateLimiterInitialization(RateLimiterInitialization rateLimiterInitialization) {
        this.rateLimiterInitialization = rateLimiterInitialization;
    }

    public int getRateLimiterGlobalQps() {
        return this.rateLimiterGlobalQps;
    }

    public void setRateLimiterGlobalQps(int rateLimiterGlobalQps) {
        this.rateLimiterGlobalQps = rateLimiterGlobalQps;
    }

    public int getRateLimiterGlobalIpQps() {
        return this.rateLimiterGlobalIpQps;
    }

    public void setRateLimiterGlobalIpQps(int rateLimiterGlobalIpQps) {
        this.rateLimiterGlobalIpQps = rateLimiterGlobalIpQps;
    }

    public DbBackupConfig getDbBackupConfig() {
        return this.dbBackupConfig;
    }

    public RocksDbSettings getRocksDBCustomSettings() {
        return this.rocksDBCustomSettings;
    }

    public GenesisBlock getGenesisBlock() {
        return this.genesisBlock;
    }

    public boolean isP2pDisable() {
        return this.p2pDisable;
    }

    public void setP2pDisable(boolean p2pDisable) {
        this.p2pDisable = p2pDisable;
    }

    public List<InetSocketAddress> getActiveNodes() {
        return this.activeNodes;
    }

    public void setActiveNodes(List<InetSocketAddress> activeNodes) {
        this.activeNodes = activeNodes;
    }

    public List<InetAddress> getPassiveNodes() {
        return this.passiveNodes;
    }

    public void setPassiveNodes(List<InetAddress> passiveNodes) {
        this.passiveNodes = passiveNodes;
    }

    public List<InetSocketAddress> getFastForwardNodes() {
        return this.fastForwardNodes;
    }

    public int getMaxFastForwardNum() {
        return this.maxFastForwardNum;
    }

    public Storage getStorage() {
        return this.storage;
    }

    public Overlay getOverlay() {
        return this.overlay;
    }

    public SeedNode getSeedNode() {
        return this.seedNode;
    }

    public EventPluginConfig getEventPluginConfig() {
        return this.eventPluginConfig;
    }

    public FilterQuery getEventFilter() {
        return this.eventFilter;
    }

    public String getCryptoEngine() {
        return this.cryptoEngine;
    }

    public void setCryptoEngine(String cryptoEngine) {
        this.cryptoEngine = cryptoEngine;
    }

    public boolean isFullNodeHttpEnable() {
        return this.fullNodeHttpEnable;
    }

    public void setFullNodeHttpEnable(boolean fullNodeHttpEnable) {
        this.fullNodeHttpEnable = fullNodeHttpEnable;
    }

    public boolean isSolidityNodeHttpEnable() {
        return this.solidityNodeHttpEnable;
    }

    public void setSolidityNodeHttpEnable(boolean solidityNodeHttpEnable) {
        this.solidityNodeHttpEnable = solidityNodeHttpEnable;
    }

    public boolean isJsonRpcHttpFullNodeEnable() {
        return this.jsonRpcHttpFullNodeEnable;
    }

    public void setJsonRpcHttpFullNodeEnable(boolean jsonRpcHttpFullNodeEnable) {
        this.jsonRpcHttpFullNodeEnable = jsonRpcHttpFullNodeEnable;
    }

    public boolean isJsonRpcHttpSolidityNodeEnable() {
        return this.jsonRpcHttpSolidityNodeEnable;
    }

    public void setJsonRpcHttpSolidityNodeEnable(boolean jsonRpcHttpSolidityNodeEnable) {
        this.jsonRpcHttpSolidityNodeEnable = jsonRpcHttpSolidityNodeEnable;
    }

    public boolean isJsonRpcHttpPBFTNodeEnable() {
        return this.jsonRpcHttpPBFTNodeEnable;
    }

    public void setJsonRpcHttpPBFTNodeEnable(boolean jsonRpcHttpPBFTNodeEnable) {
        this.jsonRpcHttpPBFTNodeEnable = jsonRpcHttpPBFTNodeEnable;
    }

    public int getMaxTransactionPendingSize() {
        return this.maxTransactionPendingSize;
    }

    public void setMaxTransactionPendingSize(int maxTransactionPendingSize) {
        this.maxTransactionPendingSize = maxTransactionPendingSize;
    }

    public long getPendingTransactionTimeout() {
        return this.pendingTransactionTimeout;
    }

    public void setPendingTransactionTimeout(long pendingTransactionTimeout) {
        this.pendingTransactionTimeout = pendingTransactionTimeout;
    }

    public boolean isNodeMetricsEnable() {
        return this.nodeMetricsEnable;
    }

    public void setNodeMetricsEnable(boolean nodeMetricsEnable) {
        this.nodeMetricsEnable = nodeMetricsEnable;
    }

    public boolean isMetricsStorageEnable() {
        return this.metricsStorageEnable;
    }

    public void setMetricsStorageEnable(boolean metricsStorageEnable) {
        this.metricsStorageEnable = metricsStorageEnable;
    }

    public String getInfluxDbIp() {
        return this.influxDbIp;
    }

    public void setInfluxDbIp(String influxDbIp) {
        this.influxDbIp = influxDbIp;
    }

    public int getInfluxDbPort() {
        return this.influxDbPort;
    }

    public void setInfluxDbPort(int influxDbPort) {
        this.influxDbPort = influxDbPort;
    }

    public String getInfluxDbDatabase() {
        return this.influxDbDatabase;
    }

    public void setInfluxDbDatabase(String influxDbDatabase) {
        this.influxDbDatabase = influxDbDatabase;
    }

    public int getMetricsReportInterval() {
        return this.metricsReportInterval;
    }

    public void setMetricsReportInterval(int metricsReportInterval) {
        this.metricsReportInterval = metricsReportInterval;
    }

    public boolean isMetricsPrometheusEnable() {
        return this.metricsPrometheusEnable;
    }

    public void setMetricsPrometheusEnable(boolean metricsPrometheusEnable) {
        this.metricsPrometheusEnable = metricsPrometheusEnable;
    }

    public int getMetricsPrometheusPort() {
        return this.metricsPrometheusPort;
    }

    public void setMetricsPrometheusPort(int metricsPrometheusPort) {
        this.metricsPrometheusPort = metricsPrometheusPort;
    }

    public int getAgreeNodeCount() {
        return this.agreeNodeCount;
    }

    public void setAgreeNodeCount(int agreeNodeCount) {
        this.agreeNodeCount = agreeNodeCount;
    }

    public long getAllowPBFT() {
        return this.allowPBFT;
    }

    public void setAllowPBFT(long allowPBFT) {
        this.allowPBFT = allowPBFT;
    }

    public int getRpcOnPBFTPort() {
        return this.rpcOnPBFTPort;
    }

    public void setRpcOnPBFTPort(int rpcOnPBFTPort) {
        this.rpcOnPBFTPort = rpcOnPBFTPort;
    }

    public int getPBFTHttpPort() {
        return this.pBFTHttpPort;
    }

    public void setPBFTHttpPort(int pBFTHttpPort) {
        this.pBFTHttpPort = pBFTHttpPort;
    }

    public long getOldSolidityBlockNum() {
        return this.oldSolidityBlockNum;
    }

    public void setOldSolidityBlockNum(long oldSolidityBlockNum) {
        this.oldSolidityBlockNum = oldSolidityBlockNum;
    }

    public long getAllowShieldedTRC20Transaction() {
        return this.allowShieldedTRC20Transaction;
    }

    public void setAllowShieldedTRC20Transaction(long allowShieldedTRC20Transaction) {
        this.allowShieldedTRC20Transaction = allowShieldedTRC20Transaction;
    }

    public long getAllowTvmIstanbul() {
        return this.allowTvmIstanbul;
    }

    public void setAllowTvmIstanbul(long allowTvmIstanbul) {
        this.allowTvmIstanbul = allowTvmIstanbul;
    }

    public long getAllowTvmFreeze() {
        return this.allowTvmFreeze;
    }

    public void setAllowTvmFreeze(long allowTvmFreeze) {
        this.allowTvmFreeze = allowTvmFreeze;
    }

    public long getAllowTvmVote() {
        return this.allowTvmVote;
    }

    public void setAllowTvmVote(long allowTvmVote) {
        this.allowTvmVote = allowTvmVote;
    }

    public long getAllowTvmLondon() {
        return this.allowTvmLondon;
    }

    public void setAllowTvmLondon(long allowTvmLondon) {
        this.allowTvmLondon = allowTvmLondon;
    }

    public long getAllowTvmCompatibleEvm() {
        return this.allowTvmCompatibleEvm;
    }

    public void setAllowTvmCompatibleEvm(long allowTvmCompatibleEvm) {
        this.allowTvmCompatibleEvm = allowTvmCompatibleEvm;
    }

    public long getAllowHigherLimitForMaxCpuTimeOfOneTx() {
        return this.allowHigherLimitForMaxCpuTimeOfOneTx;
    }

    public void setAllowHigherLimitForMaxCpuTimeOfOneTx(long allowHigherLimitForMaxCpuTimeOfOneTx) {
        this.allowHigherLimitForMaxCpuTimeOfOneTx = allowHigherLimitForMaxCpuTimeOfOneTx;
    }

    public boolean isOpenHistoryQueryWhenLiteFN() {
        return this.openHistoryQueryWhenLiteFN;
    }

    public void setOpenHistoryQueryWhenLiteFN(boolean openHistoryQueryWhenLiteFN) {
        this.openHistoryQueryWhenLiteFN = openHistoryQueryWhenLiteFN;
    }

    public boolean isHistoryBalanceLookup() {
        return this.historyBalanceLookup;
    }

    public void setHistoryBalanceLookup(boolean historyBalanceLookup) {
        this.historyBalanceLookup = historyBalanceLookup;
    }

    public boolean isOpenPrintLog() {
        return this.openPrintLog;
    }

    public void setOpenPrintLog(boolean openPrintLog) {
        this.openPrintLog = openPrintLog;
    }

    public boolean isOpenTransactionSort() {
        return this.openTransactionSort;
    }

    public void setOpenTransactionSort(boolean openTransactionSort) {
        this.openTransactionSort = openTransactionSort;
    }

    public long getAllowAccountAssetOptimization() {
        return this.allowAccountAssetOptimization;
    }

    public void setAllowAccountAssetOptimization(long allowAccountAssetOptimization) {
        this.allowAccountAssetOptimization = allowAccountAssetOptimization;
    }

    public long getAllowAssetOptimization() {
        return this.allowAssetOptimization;
    }

    public void setAllowAssetOptimization(long allowAssetOptimization) {
        this.allowAssetOptimization = allowAssetOptimization;
    }

    public List<String> getDisabledApiList() {
        return this.disabledApiList;
    }

    public void setDisabledApiList(List<String> disabledApiList) {
        this.disabledApiList = disabledApiList;
    }

    public CronExpression getShutdownBlockTime() {
        return this.shutdownBlockTime;
    }

    public void setShutdownBlockTime(CronExpression shutdownBlockTime) {
        this.shutdownBlockTime = shutdownBlockTime;
    }

    public long getShutdownBlockHeight() {
        return this.shutdownBlockHeight;
    }

    public void setShutdownBlockHeight(long shutdownBlockHeight) {
        this.shutdownBlockHeight = shutdownBlockHeight;
    }

    public long getShutdownBlockCount() {
        return this.shutdownBlockCount;
    }

    public void setShutdownBlockCount(long shutdownBlockCount) {
        this.shutdownBlockCount = shutdownBlockCount;
    }

    public long getBlockCacheTimeout() {
        return this.blockCacheTimeout;
    }

    public void setBlockCacheTimeout(long blockCacheTimeout) {
        this.blockCacheTimeout = blockCacheTimeout;
    }

    public long getAllowNewRewardAlgorithm() {
        return this.allowNewRewardAlgorithm;
    }

    public void setAllowNewRewardAlgorithm(long allowNewRewardAlgorithm) {
        this.allowNewRewardAlgorithm = allowNewRewardAlgorithm;
    }

    public long getAllowNewReward() {
        return this.allowNewReward;
    }

    public void setAllowNewReward(long allowNewReward) {
        this.allowNewReward = allowNewReward;
    }

    public long getMemoFee() {
        return this.memoFee;
    }

    public void setMemoFee(long memoFee) {
        this.memoFee = memoFee;
    }

    public long getAllowDelegateOptimization() {
        return this.allowDelegateOptimization;
    }

    public void setAllowDelegateOptimization(long allowDelegateOptimization) {
        this.allowDelegateOptimization = allowDelegateOptimization;
    }

    public long getUnfreezeDelayDays() {
        return this.unfreezeDelayDays;
    }

    public void setUnfreezeDelayDays(long unfreezeDelayDays) {
        this.unfreezeDelayDays = unfreezeDelayDays;
    }

    public long getAllowOptimizedReturnValueOfChainId() {
        return this.allowOptimizedReturnValueOfChainId;
    }

    public void setAllowOptimizedReturnValueOfChainId(long allowOptimizedReturnValueOfChainId) {
        this.allowOptimizedReturnValueOfChainId = allowOptimizedReturnValueOfChainId;
    }

    public long getAllowDynamicEnergy() {
        return this.allowDynamicEnergy;
    }

    public void setAllowDynamicEnergy(long allowDynamicEnergy) {
        this.allowDynamicEnergy = allowDynamicEnergy;
    }

    public long getDynamicEnergyThreshold() {
        return this.dynamicEnergyThreshold;
    }

    public void setDynamicEnergyThreshold(long dynamicEnergyThreshold) {
        this.dynamicEnergyThreshold = dynamicEnergyThreshold;
    }

    public long getDynamicEnergyIncreaseFactor() {
        return this.dynamicEnergyIncreaseFactor;
    }

    public void setDynamicEnergyIncreaseFactor(long dynamicEnergyIncreaseFactor) {
        this.dynamicEnergyIncreaseFactor = dynamicEnergyIncreaseFactor;
    }

    public long getDynamicEnergyMaxFactor() {
        return this.dynamicEnergyMaxFactor;
    }

    public void setDynamicEnergyMaxFactor(long dynamicEnergyMaxFactor) {
        this.dynamicEnergyMaxFactor = dynamicEnergyMaxFactor;
    }

    public boolean isDynamicConfigEnable() {
        return this.dynamicConfigEnable;
    }

    public void setDynamicConfigEnable(boolean dynamicConfigEnable) {
        this.dynamicConfigEnable = dynamicConfigEnable;
    }

    public long getDynamicConfigCheckInterval() {
        return this.dynamicConfigCheckInterval;
    }

    public void setDynamicConfigCheckInterval(long dynamicConfigCheckInterval) {
        this.dynamicConfigCheckInterval = dynamicConfigCheckInterval;
    }

    public long getAllowTvmShangHai() {
        return this.allowTvmShangHai;
    }

    public void setAllowTvmShangHai(long allowTvmShangHai) {
        this.allowTvmShangHai = allowTvmShangHai;
    }

    public long getAllowCancelAllUnfreezeV2() {
        return this.allowCancelAllUnfreezeV2;
    }

    public void setAllowCancelAllUnfreezeV2(long allowCancelAllUnfreezeV2) {
        this.allowCancelAllUnfreezeV2 = allowCancelAllUnfreezeV2;
    }
}

