/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.utils;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Locale;

public class Bech32 {
    private static final String CHARSET = "qpzry9x8gf2tvdw0s3jn54khce6mua7l";
    private static final byte[] CHARSET_REV = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 15, -1, 10, 17, 21, 20, 26, 30, 7, 5, -1, -1, -1, -1, -1, -1, -1, 29, -1, 24, 13, 25, 9, 8, 23, -1, 18, 22, 31, 27, 19, -1, 1, 0, 3, 16, 11, 28, 12, 14, 6, 4, 2, -1, -1, -1, -1, -1, -1, 29, -1, 24, 13, 25, 9, 8, 23, -1, 18, 22, 31, 27, 19, -1, 1, 0, 3, 16, 11, 28, 12, 14, 6, 4, 2, -1, -1, -1, -1, -1};

    private static int polymod(byte[] values) {
        int c = 1;
        for (byte v_i : values) {
            int c0 = c >>> 25 & 0xFF;
            c = (c & 0x1FFFFFF) << 5 ^ v_i & 0xFF;
            if ((c0 & 1) != 0) {
                c ^= 0x3B6A57B2;
            }
            if ((c0 & 2) != 0) {
                c ^= 0x26508E6D;
            }
            if ((c0 & 4) != 0) {
                c ^= 0x1EA119FA;
            }
            if ((c0 & 8) != 0) {
                c ^= 0x3D4233DD;
            }
            if ((c0 & 0x10) == 0) continue;
            c ^= 0x2A1462B3;
        }
        return c;
    }

    private static byte[] expandHrp(String hrp) {
        int hrpLength = hrp.length();
        byte[] ret = new byte[hrpLength * 2 + 1];
        for (int i = 0; i < hrpLength; ++i) {
            int c = hrp.charAt(i) & 0x7F;
            ret[i] = (byte)(c >>> 5 & 7);
            ret[i + hrpLength + 1] = (byte)(c & 0x1F);
        }
        ret[hrpLength] = 0;
        return ret;
    }

    private static boolean verifyChecksum(String hrp, byte[] values) {
        byte[] hrpExpanded = Bech32.expandHrp(hrp);
        byte[] combined = new byte[hrpExpanded.length + values.length];
        System.arraycopy(hrpExpanded, 0, combined, 0, hrpExpanded.length);
        System.arraycopy(values, 0, combined, hrpExpanded.length, values.length);
        return Bech32.polymod(combined) == 1;
    }

    private static byte[] createChecksum(String hrp, byte[] values) {
        byte[] hrpExpanded = Bech32.expandHrp(hrp);
        byte[] enc = new byte[hrpExpanded.length + values.length + 6];
        System.arraycopy(hrpExpanded, 0, enc, 0, hrpExpanded.length);
        System.arraycopy(values, 0, enc, hrpExpanded.length, values.length);
        int mod = Bech32.polymod(enc) ^ 1;
        byte[] ret = new byte[6];
        for (int i = 0; i < 6; ++i) {
            ret[i] = (byte)(mod >>> 5 * (5 - i) & 0x1F);
        }
        return ret;
    }

    public static String encode(Bech32Data bech32) {
        return Bech32.encode(bech32.hrp, bech32.data);
    }

    public static String encode(String hrp, byte[] values) {
        Preconditions.checkArgument((hrp.length() >= 1 ? 1 : 0) != 0, (Object)"Human-readable part is too short");
        Preconditions.checkArgument((hrp.length() <= 83 ? 1 : 0) != 0, (Object)"Human-readable part is too long");
        hrp = hrp.toLowerCase(Locale.ROOT);
        byte[] checksum = Bech32.createChecksum(hrp, values);
        byte[] combined = new byte[values.length + checksum.length];
        System.arraycopy(values, 0, combined, 0, values.length);
        System.arraycopy(checksum, 0, combined, values.length, checksum.length);
        StringBuilder sb = new StringBuilder(hrp.length() + 1 + combined.length);
        sb.append(hrp);
        sb.append('1');
        for (byte b : combined) {
            sb.append(CHARSET.charAt(b));
        }
        return sb.toString();
    }

    public static Bech32Data decode(String str) throws IllegalArgumentException {
        boolean lower = false;
        boolean upper = false;
        if (str.length() < 8) {
            throw new IllegalArgumentException("Input too short: " + str.length());
        }
        if (str.length() > 90) {
            throw new IllegalArgumentException("Input too long: " + str.length());
        }
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            String exceptionMsg = "InvalidCharacter(" + c + ", " + i + ")";
            if (c < '!' || c > '~') {
                throw new IllegalArgumentException(exceptionMsg);
            }
            if (c >= 'a' && c <= 'z') {
                if (upper) {
                    throw new IllegalArgumentException(exceptionMsg);
                }
                lower = true;
            }
            if (c < 'A' || c > 'Z') continue;
            if (lower) {
                throw new IllegalArgumentException(exceptionMsg);
            }
            upper = true;
        }
        int pos = str.lastIndexOf(49);
        if (pos < 1) {
            throw new IllegalArgumentException("Missing human-readable part");
        }
        int dataPartLength = str.length() - 1 - pos;
        if (dataPartLength < 6) {
            throw new IllegalArgumentException("Data part too short: " + dataPartLength);
        }
        byte[] values = new byte[dataPartLength];
        for (int i = 0; i < dataPartLength; ++i) {
            char c = str.charAt(i + pos + 1);
            if (CHARSET_REV[c] == -1) {
                throw new IllegalArgumentException("InvalidCharacter(" + c + ", " + i + pos + 1 + ")");
            }
            values[i] = CHARSET_REV[c];
        }
        String hrp = str.substring(0, pos).toLowerCase(Locale.ROOT);
        if (!Bech32.verifyChecksum(hrp, values)) {
            throw new IllegalArgumentException("InvalidChecksum:");
        }
        return new Bech32Data(hrp, Arrays.copyOfRange(values, 0, values.length - 6));
    }

    public static class Bech32Data {
        public final String hrp;
        public final byte[] data;

        private Bech32Data(String hrp, byte[] data) {
            this.hrp = hrp;
            this.data = data;
        }
    }
}

