/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.runtime.vm;

import com.google.common.collect.Lists;
import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.bouncycastle.util.encoders.Hex;
import org.tron.common.runtime.vm.DataWord;
import org.tron.common.utils.ByteUtil;
import org.tron.protos.Protocol;

public class LogInfo {
    private byte[] address = new byte[0];
    private List<DataWord> topics = new ArrayList<DataWord>();
    private byte[] data = new byte[0];

    public LogInfo(byte[] address, List<DataWord> topics, byte[] data) {
        this.address = address != null ? address : new byte[]{};
        this.topics = topics != null ? topics : new ArrayList();
        this.data = data != null ? data : new byte[]{};
    }

    public static Protocol.TransactionInfo.Log buildLog(LogInfo logInfo) {
        ArrayList topics = Lists.newArrayList();
        logInfo.getTopics().forEach(topic -> topics.add(ByteString.copyFrom((byte[])topic.getData())));
        ByteString address = ByteString.copyFrom((byte[])logInfo.getAddress());
        ByteString data = ByteString.copyFrom((byte[])logInfo.getData());
        return Protocol.TransactionInfo.Log.newBuilder().setAddress(address).addAllTopics((Iterable)topics).setData(data).build();
    }

    public byte[] getAddress() {
        return this.address;
    }

    public List<DataWord> getTopics() {
        return this.topics;
    }

    public List<String> getHexTopics() {
        LinkedList<String> list = new LinkedList<String>();
        if (this.topics != null && !this.topics.isEmpty()) {
            for (DataWord bytes : this.topics) {
                list.add(bytes.toHexString());
            }
        }
        return list;
    }

    public List<byte[]> getClonedTopics() {
        LinkedList<byte[]> list = new LinkedList<byte[]>();
        if (this.topics != null && this.topics.size() > 0) {
            for (DataWord dataword : this.topics) {
                list.add(dataword.getClonedData());
            }
        }
        return list;
    }

    public String getHexData() {
        return Hex.toHexString((byte[])this.data);
    }

    public byte[] getClonedData() {
        return ByteUtil.cloneBytes(this.data);
    }

    public byte[] getData() {
        return this.data;
    }

    public String toString() {
        StringBuilder topicsStr = new StringBuilder();
        topicsStr.append("[");
        for (DataWord topic : this.topics) {
            String topicStr = Hex.toHexString((byte[])topic.getData());
            topicsStr.append(topicStr).append(" ");
        }
        topicsStr.append("]");
        return "LogInfo{address=" + Hex.toHexString((byte[])this.address) + ", topics=" + topicsStr + ", data=" + Hex.toHexString((byte[])this.data) + '}';
    }
}

