/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.prometheus;

import io.prometheus.client.Counter;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.prometheus.Metrics;

class MetricsCounter {
    private static final Logger logger = LoggerFactory.getLogger((String)"metrics");
    private static final Map<String, Counter> container = new ConcurrentHashMap<String, Counter>();

    private MetricsCounter() {
        throw new IllegalStateException("MetricsCounter");
    }

    private static void init(String name, String help, String ... labels) {
        container.put(name, (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name(name)).help(help)).labelNames(labels)).register());
    }

    static void inc(String key, double amt, String ... labels) {
        if (Metrics.enabled()) {
            Counter counter = container.get(key);
            if (counter == null) {
                logger.info("{} not exist", (Object)key);
                return;
            }
            ((Counter.Child)counter.labels(labels)).inc(amt);
        }
    }

    static {
        MetricsCounter.init("tron:txs", "tron  txs  info .", "type", "detail");
        MetricsCounter.init("tron:miner", "tron  miner info .", "miner", "type");
        MetricsCounter.init("tron:block_fork", "tron  block fork info .", "type");
        MetricsCounter.init("tron:p2p_error", "tron p2p error  info .", "type");
        MetricsCounter.init("tron:p2p_disconnect", "tron p2p disconnect .", "type");
        MetricsCounter.init("tron:internal_service_fail", "internal Service fail.", "class", "method");
    }
}

