/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.prometheus;

import io.prometheus.client.Histogram;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.stereotype.Component;
import org.tron.common.prometheus.MetricTime;
import org.tron.common.prometheus.Metrics;

@Aspect
@Component
public class MetricAspect {
    @Around(value="@annotation(metricTime)")
    public Object aroundAdviceMetricTime(ProceedingJoinPoint pjp, MetricTime metricTime) throws Throwable {
        Object result;
        Histogram.Timer requestTimer = Metrics.histogramStartTimer("tron:internal_service_latency_seconds", pjp.getSignature().getDeclaringType().getSimpleName(), metricTime.value().isEmpty() ? pjp.getSignature().getName() : metricTime.value());
        try {
            result = pjp.proceed();
        }
        catch (Throwable throwable) {
            Metrics.counterInc("tron:internal_service_fail", 1.0, pjp.getSignature().getDeclaringType().getSimpleName(), metricTime.value().isEmpty() ? pjp.getSignature().getName() : metricTime.value());
            throw throwable;
        }
        finally {
            Metrics.histogramObserve(requestTimer);
        }
        return result;
    }

    @Around(value="execution(public * org.tron.core.Wallet.*(..))")
    public Object walletAroundAdvice(ProceedingJoinPoint pjp) throws Throwable {
        Object result;
        Histogram.Timer requestTimer = Metrics.histogramStartTimer("tron:internal_service_latency_seconds", pjp.getSignature().getDeclaringType().getSimpleName(), pjp.getSignature().getName());
        try {
            result = pjp.proceed();
        }
        catch (Throwable throwable) {
            Metrics.counterInc("tron:internal_service_fail", 1.0, pjp.getSignature().getDeclaringType().getSimpleName(), pjp.getSignature().getName());
            throw throwable;
        }
        finally {
            Metrics.histogramObserve(requestTimer);
        }
        return result;
    }
}

