/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.prometheus;

import io.prometheus.client.Collector;
import io.prometheus.client.GaugeMetricFamily;
import io.prometheus.client.Predicate;
import io.prometheus.client.SampleNameFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.tron.common.cache.CacheManager;

public class GuavaCacheExports
extends Collector {
    private static final String TRON_GUAVA_CACHE_HIT_RATE = "tron:guava_cache_hit_rate";
    private static final String TRON_GUAVA_CACHE_REQUEST = "tron:guava_cache_request";
    private static final String TRON_GUAVA_CACHE_EVICTION_COUNT = "tron:guava_cache_eviction_count";

    void addHitRateMetrics(List<Collector.MetricFamilySamples> sampleFamilies, Predicate<String> nameFilter) {
        if (nameFilter.test((Object)TRON_GUAVA_CACHE_HIT_RATE)) {
            GaugeMetricFamily hitRate = new GaugeMetricFamily(TRON_GUAVA_CACHE_HIT_RATE, "Hit rate of a guava cache.", Collections.singletonList("type"));
            CacheManager.stats().forEach((k, v) -> hitRate.addMetric(Collections.singletonList(k), v.hitRate()));
            sampleFamilies.add((Collector.MetricFamilySamples)hitRate);
        }
    }

    void addRequestMetrics(List<Collector.MetricFamilySamples> sampleFamilies, Predicate<String> nameFilter) {
        if (nameFilter.test((Object)TRON_GUAVA_CACHE_REQUEST)) {
            GaugeMetricFamily request = new GaugeMetricFamily(TRON_GUAVA_CACHE_REQUEST, "Request of a guava cache.", Collections.singletonList("type"));
            CacheManager.stats().forEach((k, v) -> request.addMetric(Collections.singletonList(k), (double)v.requestCount()));
            sampleFamilies.add((Collector.MetricFamilySamples)request);
        }
    }

    void addEvictionCountMetrics(List<Collector.MetricFamilySamples> sampleFamilies, Predicate<String> nameFilter) {
        if (nameFilter.test((Object)TRON_GUAVA_CACHE_EVICTION_COUNT)) {
            GaugeMetricFamily request = new GaugeMetricFamily(TRON_GUAVA_CACHE_EVICTION_COUNT, "Eviction count of a guava cache.", Collections.singletonList("type"));
            CacheManager.stats().forEach((k, v) -> request.addMetric(Collections.singletonList(k), (double)v.evictionCount()));
            sampleFamilies.add((Collector.MetricFamilySamples)request);
        }
    }

    public List<Collector.MetricFamilySamples> collect() {
        return this.collect(null);
    }

    public List<Collector.MetricFamilySamples> collect(Predicate<String> nameFilter) {
        ArrayList<Collector.MetricFamilySamples> mfs = new ArrayList<Collector.MetricFamilySamples>();
        this.addHitRateMetrics(mfs, nameFilter == null ? SampleNameFilter.ALLOW_ALL : nameFilter);
        this.addRequestMetrics(mfs, nameFilter == null ? SampleNameFilter.ALLOW_ALL : nameFilter);
        this.addEvictionCountMetrics(mfs, nameFilter == null ? SampleNameFilter.ALLOW_ALL : nameFilter);
        return mfs;
    }
}

