/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.store;

import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.tron.core.capsule.IncrementalMerkleTreeCapsule;
import org.tron.core.db.TronStoreWithRevoking;

@Component
public class IncrementalMerkleTreeStore
extends TronStoreWithRevoking<IncrementalMerkleTreeCapsule> {
    private static final Logger logger = LoggerFactory.getLogger((String)"DB");

    @Autowired
    public IncrementalMerkleTreeStore(@Value(value="IncrementalMerkleTree") String dbName) {
        super(dbName);
    }

    @Override
    public IncrementalMerkleTreeCapsule get(byte[] key) {
        byte[] value = this.revokingDB.getUnchecked(key);
        return ArrayUtils.isEmpty((byte[])value) ? null : new IncrementalMerkleTreeCapsule(value);
    }

    public boolean contain(byte[] key) {
        byte[] value = this.revokingDB.getUnchecked(key);
        return !ArrayUtils.isEmpty((byte[])value);
    }
}

