/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.store;

import com.google.protobuf.ByteString;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.tron.core.capsule.DelegatedResourceCapsule;
import org.tron.core.db.TronStoreWithRevoking;

@Component
public class DelegatedResourceStore
extends TronStoreWithRevoking<DelegatedResourceCapsule> {
    @Autowired
    public DelegatedResourceStore(@Value(value="DelegatedResource") String dbName) {
        super(dbName);
    }

    @Override
    public DelegatedResourceCapsule get(byte[] key) {
        byte[] value = this.revokingDB.getUnchecked(key);
        return ArrayUtils.isEmpty((byte[])value) ? null : new DelegatedResourceCapsule(value);
    }

    @Deprecated
    public List<DelegatedResourceCapsule> getByFrom(byte[] key) {
        return this.revokingDB.getValuesNext(key, Long.MAX_VALUE).stream().map(DelegatedResourceCapsule::new).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public void unLockExpireResource(byte[] from, byte[] to, long now) {
        byte[] lockKey = DelegatedResourceCapsule.createDbKeyV2(from, to, true);
        DelegatedResourceCapsule lockResource = this.get(lockKey);
        if (lockResource == null) {
            return;
        }
        if (lockResource.getExpireTimeForEnergy() >= now && lockResource.getExpireTimeForBandwidth() >= now) {
            return;
        }
        byte[] unlockKey = DelegatedResourceCapsule.createDbKeyV2(from, to, false);
        DelegatedResourceCapsule unlockResource = this.get(unlockKey);
        if (unlockResource == null) {
            unlockResource = new DelegatedResourceCapsule(ByteString.copyFrom((byte[])from), ByteString.copyFrom((byte[])to));
        }
        if (lockResource.getExpireTimeForEnergy() < now) {
            unlockResource.addFrozenBalanceForEnergy(lockResource.getFrozenBalanceForEnergy(), 0L);
            lockResource.setFrozenBalanceForEnergy(0L, 0L);
        }
        if (lockResource.getExpireTimeForBandwidth() < now) {
            unlockResource.addFrozenBalanceForBandwidth(lockResource.getFrozenBalanceForBandwidth(), 0L);
            lockResource.setFrozenBalanceForBandwidth(0L, 0L);
        }
        if (lockResource.getFrozenBalanceForBandwidth() == 0L && lockResource.getFrozenBalanceForEnergy() == 0L) {
            this.delete(lockKey);
        } else {
            this.put(lockKey, lockResource);
        }
        this.put(unlockKey, unlockResource);
    }
}

