/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.db2.core;

import com.google.common.collect.Maps;
import com.google.common.collect.Streams;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.tron.common.cache.CacheManager;
import org.tron.common.cache.CacheType;
import org.tron.common.cache.TronCache;
import org.tron.common.parameter.CommonParameter;
import org.tron.common.utils.ByteArray;
import org.tron.core.ChainBaseManager;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.db2.common.DB;
import org.tron.core.db2.common.Flusher;
import org.tron.core.db2.common.Key;
import org.tron.core.db2.common.Value;
import org.tron.core.db2.common.WrappedByteArray;
import org.tron.core.db2.core.AbstractSnapshot;
import org.tron.core.db2.core.Snapshot;
import org.tron.core.db2.core.SnapshotImpl;
import org.tron.core.store.AccountAssetStore;

public class SnapshotRoot
extends AbstractSnapshot<byte[], byte[]> {
    private Snapshot solidity;
    private boolean isAccountDB;
    private TronCache<WrappedByteArray, WrappedByteArray> cache;
    private static final List<String> CACHE_DBS = CommonParameter.getInstance().getStorage().getCacheDbs();

    public SnapshotRoot(DB<byte[], byte[]> db) {
        this.db = db;
        this.solidity = this;
        this.isAccountDB = "account".equalsIgnoreCase(db.getDbName());
        if (CACHE_DBS.contains(this.db.getDbName())) {
            this.cache = CacheManager.allocate((CacheType)CacheType.findByType((String)this.db.getDbName()));
        }
        this.isOptimized = "properties".equalsIgnoreCase(db.getDbName());
    }

    private boolean needOptAsset() {
        return this.isAccountDB && ChainBaseManager.getInstance().getDynamicPropertiesStore().getAllowAccountAssetOptimizationFromRoot() == 1L;
    }

    @Override
    public byte[] get(byte[] key) {
        WrappedByteArray cache = this.getCache(key);
        if (cache != null) {
            return cache.getBytes();
        }
        byte[] value = (byte[])this.db.get(key);
        this.putCache(key, value);
        return value;
    }

    @Override
    public void put(byte[] key, byte[] value) {
        byte[] v = value;
        if (this.needOptAsset()) {
            if (ByteArray.isEmpty((byte[])value)) {
                this.remove(key);
                return;
            }
            AccountAssetStore assetStore = ChainBaseManager.getInstance().getAccountAssetStore();
            AccountCapsule item = new AccountCapsule(value);
            if (!item.getAssetOptimized()) {
                assetStore.deleteAccount(item.createDbKey());
                item.setAssetOptimized(true);
            }
            assetStore.putAccount(item.getInstance());
            item.clearAsset();
            v = item.getData();
        }
        this.db.put(key, v);
        this.putCache(key, v);
    }

    @Override
    public void remove(byte[] key) {
        if (this.needOptAsset()) {
            ChainBaseManager.getInstance().getAccountAssetStore().deleteAccount(key);
        }
        this.db.remove(key);
        this.putCache(key, null);
    }

    @Override
    public void merge(Snapshot from) {
        SnapshotImpl snapshot = (SnapshotImpl)from;
        Map<WrappedByteArray, WrappedByteArray> batch = Streams.stream((Iterable)snapshot.db).map(e -> Maps.immutableEntry((Object)WrappedByteArray.of(((Key)e.getKey()).getBytes()), (Object)WrappedByteArray.of(((Value)e.getValue()).getBytes()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        if (this.needOptAsset()) {
            this.processAccount(batch);
        } else {
            ((Flusher)((Object)this.db)).flush(batch);
            this.putCache(batch);
        }
    }

    public void merge(List<Snapshot> snapshots) {
        HashMap<WrappedByteArray, WrappedByteArray> batch = new HashMap<WrappedByteArray, WrappedByteArray>();
        for (Snapshot snapshot : snapshots) {
            SnapshotImpl from = (SnapshotImpl)snapshot;
            Streams.stream((Iterable)from.db).map(e -> Maps.immutableEntry((Object)WrappedByteArray.of(((Key)e.getKey()).getBytes()), (Object)WrappedByteArray.of(((Value)e.getValue()).getBytes()))).forEach(e -> {
                WrappedByteArray cfr_ignored_0 = (WrappedByteArray)batch.put((WrappedByteArray)e.getKey(), (WrappedByteArray)e.getValue());
            });
        }
        if (this.needOptAsset()) {
            this.processAccount(batch);
        } else {
            ((Flusher)((Object)this.db)).flush(batch);
            this.putCache(batch);
        }
    }

    private void processAccount(Map<WrappedByteArray, WrappedByteArray> batch) {
        AccountAssetStore assetStore = ChainBaseManager.getInstance().getAccountAssetStore();
        HashMap<WrappedByteArray, WrappedByteArray> accounts = new HashMap<WrappedByteArray, WrappedByteArray>();
        HashMap<WrappedByteArray, WrappedByteArray> assets = new HashMap<WrappedByteArray, WrappedByteArray>();
        batch.forEach((? super K k, ? super V v) -> {
            if (ByteArray.isEmpty((byte[])v.getBytes())) {
                accounts.put((WrappedByteArray)k, (WrappedByteArray)v);
                assets.putAll(assetStore.getDeletedAssets(k.getBytes()));
            } else {
                AccountCapsule item = new AccountCapsule(v.getBytes());
                if (!item.getAssetOptimized()) {
                    assets.putAll(assetStore.getDeletedAssets(k.getBytes()));
                    item.setAssetOptimized(true);
                }
                assets.putAll(assetStore.getAssets(item.getInstance()));
                item.clearAsset();
                accounts.put((WrappedByteArray)k, WrappedByteArray.of(item.getData()));
            }
        });
        ((Flusher)((Object)this.db)).flush(accounts);
        this.putCache(accounts);
        if (assets.size() > 0) {
            assetStore.updateByBatch(AccountAssetStore.convert(assets));
        }
    }

    private boolean cached() {
        return Objects.nonNull(this.cache);
    }

    private void putCache(byte[] key, byte[] value) {
        if (this.cached()) {
            this.cache.put((Object)WrappedByteArray.of(key), (Object)WrappedByteArray.of(value));
        }
    }

    private void putCache(Map<WrappedByteArray, WrappedByteArray> values) {
        if (this.cached()) {
            values.forEach((arg_0, arg_1) -> this.cache.put(arg_0, arg_1));
        }
    }

    private WrappedByteArray getCache(byte[] key) {
        if (this.cached()) {
            return (WrappedByteArray)this.cache.getIfPresent((Object)WrappedByteArray.of(key));
        }
        return null;
    }

    @Override
    public Snapshot retreat() {
        return this;
    }

    @Override
    public Snapshot getRoot() {
        return this;
    }

    @Override
    public Iterator<Map.Entry<byte[], byte[]>> iterator() {
        return this.db.iterator();
    }

    @Override
    public void close() {
        if (this.cached()) {
            CacheManager.release(this.cache);
        }
        ((Flusher)((Object)this.db)).close();
    }

    @Override
    public void reset() {
        if (this.cached()) {
            CacheManager.release(this.cache);
        }
        ((Flusher)((Object)this.db)).reset();
    }

    @Override
    public void resetSolidity() {
        this.solidity = this;
    }

    @Override
    public void updateSolidity() {
        this.solidity = this.solidity.getNext();
    }

    @Override
    public String getDbName() {
        return this.db.getDbName();
    }

    @Override
    public Snapshot newInstance() {
        return new SnapshotRoot((DB)this.db.newInstance());
    }

    @Override
    public void reloadToMem() {
    }

    @Override
    public Snapshot getSolidity() {
        return this.solidity;
    }
}

