/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.db2.core;

import com.google.common.collect.Maps;
import com.google.common.primitives.Bytes;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.tron.common.error.TronDBException;
import org.tron.common.es.ExecutorServiceManager;
import org.tron.common.parameter.CommonParameter;
import org.tron.common.storage.WriteOptionsWrapper;
import org.tron.common.utils.FileUtil;
import org.tron.common.utils.StorageUtils;
import org.tron.core.db.RevokingDatabase;
import org.tron.core.db.TronDatabase;
import org.tron.core.db2.ISession;
import org.tron.core.db2.common.DB;
import org.tron.core.db2.common.IRevokingDB;
import org.tron.core.db2.common.Key;
import org.tron.core.db2.common.Value;
import org.tron.core.db2.common.WrappedByteArray;
import org.tron.core.db2.core.Chainbase;
import org.tron.core.db2.core.Snapshot;
import org.tron.core.db2.core.SnapshotImpl;
import org.tron.core.db2.core.SnapshotRoot;
import org.tron.core.exception.RevokingStoreIllegalStateException;
import org.tron.core.store.CheckPointV2Store;
import org.tron.core.store.CheckTmpStore;

public class SnapshotManager
implements RevokingDatabase {
    private static final Logger logger = LoggerFactory.getLogger((String)"DB");
    public static final int DEFAULT_MIN_FLUSH_COUNT = 1;
    private static final int DEFAULT_STACK_MAX_SIZE = 256;
    private static final long ONE_MINUTE_MILLS = 60000L;
    private static final String CHECKPOINT_V2_DIR = "checkpoint";
    private List<Chainbase> dbs = new ArrayList<Chainbase>();
    private int size = 0;
    private AtomicInteger maxSize = new AtomicInteger(256);
    private boolean disabled = true;
    private int activeSession = 0;
    private boolean unChecked = true;
    private volatile int flushCount = 0;
    private Thread exitThread;
    private volatile boolean hitDown;
    private Map<String, ListeningExecutorService> flushServices = new HashMap<String, ListeningExecutorService>();
    private ScheduledExecutorService pruneCheckpointThread = null;
    private final String pruneName = "checkpoint-prune";
    @Autowired
    private CheckTmpStore checkTmpStore;
    private volatile int maxFlushCount = 1;
    private int checkpointVersion = 1;

    public SnapshotManager(String checkpointPath) {
    }

    @PostConstruct
    public void init() {
        this.checkpointVersion = CommonParameter.getInstance().getStorage().getCheckpointVersion();
        if (this.isV2Open()) {
            this.pruneCheckpointThread = ExecutorServiceManager.newSingleThreadScheduledExecutor((String)"checkpoint-prune");
            this.pruneCheckpointThread.scheduleWithFixedDelay(() -> {
                try {
                    if (!this.unChecked) {
                        this.pruneCheckpoint();
                    }
                }
                catch (Throwable t) {
                    logger.error("Exception in prune checkpoint", t);
                }
            }, 10000L, 3600L, TimeUnit.MILLISECONDS);
        }
        this.exitThread = new Thread(() -> {
            LockSupport.park();
            if (this.hitDown) {
                System.exit(1);
            }
        });
        this.exitThread.setName("exit-thread");
        this.exitThread.start();
    }

    public static String simpleDecode(byte[] bytes) {
        byte[] lengthBytes = Arrays.copyOf(bytes, 4);
        int length = Ints.fromByteArray((byte[])lengthBytes);
        byte[] value = Arrays.copyOfRange(bytes, 4, 4 + length);
        return new String(value);
    }

    @Override
    public ISession buildSession() {
        return this.buildSession(false);
    }

    @Override
    public synchronized ISession buildSession(boolean forceEnable) {
        boolean disableOnExit;
        if (this.disabled && !forceEnable) {
            return new Session(this);
        }
        boolean bl = disableOnExit = this.disabled && forceEnable;
        if (forceEnable) {
            this.disabled = false;
        }
        if (this.size > this.maxSize.get() && !this.hitDown) {
            this.flushCount += this.size - this.maxSize.get();
            this.updateSolidity(this.size - this.maxSize.get());
            this.size = this.maxSize.get();
            this.flush();
        }
        this.advance();
        ++this.activeSession;
        return new Session(this, disableOnExit);
    }

    @Override
    public void setCursor(Chainbase.Cursor cursor) {
        this.dbs.forEach(db -> db.setCursor(cursor));
    }

    @Override
    public void setCursor(Chainbase.Cursor cursor, long offset) {
        this.dbs.forEach(db -> db.setCursor(cursor, offset));
    }

    @Override
    public void add(IRevokingDB db) {
        Chainbase revokingDB = (Chainbase)db;
        this.dbs.add(revokingDB);
        this.flushServices.put(revokingDB.getDbName(), MoreExecutors.listeningDecorator((ExecutorService)ExecutorServiceManager.newSingleThreadExecutor((String)("flush-service-" + revokingDB.getDbName()))));
    }

    private void advance() {
        this.dbs.forEach(db -> db.setHead(db.getHead().advance()));
        ++this.size;
    }

    private void retreat() {
        this.dbs.forEach(db -> db.setHead(db.getHead().retreat()));
        --this.size;
    }

    @Override
    public void merge() {
        if (this.activeSession <= 0) {
            throw new RevokingStoreIllegalStateException(this.activeSession);
        }
        if (this.size < 2) {
            return;
        }
        this.dbs.forEach(db -> db.getHead().getPrevious().merge(db.getHead()));
        this.retreat();
        --this.activeSession;
    }

    @Override
    public synchronized void revoke() {
        if (this.disabled) {
            return;
        }
        if (this.activeSession <= 0) {
            throw new RevokingStoreIllegalStateException(this.activeSession);
        }
        if (this.size <= 0) {
            return;
        }
        this.disabled = true;
        try {
            this.retreat();
        }
        finally {
            this.disabled = false;
        }
        --this.activeSession;
    }

    @Override
    public synchronized void commit() {
        if (this.activeSession <= 0) {
            throw new RevokingStoreIllegalStateException(this.activeSession);
        }
        --this.activeSession;
        this.dbs.forEach(db -> {
            if (db.getHead().isOptimized()) {
                db.getHead().reloadToMem();
            }
        });
    }

    @Override
    public synchronized void pop() {
        if (this.activeSession != 0) {
            throw new RevokingStoreIllegalStateException(String.format("activeSession has to be equal 0, current %d", this.activeSession));
        }
        if (this.size <= 0) {
            throw new RevokingStoreIllegalStateException(String.format("there is not snapshot to be popped, current: %d", this.size));
        }
        this.disabled = true;
        try {
            this.retreat();
        }
        finally {
            this.disabled = false;
        }
    }

    @Override
    public void fastPop() {
        this.pop();
    }

    @Override
    public synchronized void enable() {
        this.disabled = false;
    }

    @Override
    public int size() {
        return this.size;
    }

    public int getMaxSize() {
        return this.maxSize.get();
    }

    @Override
    public void setMaxSize(int maxSize) {
        this.maxSize.set(maxSize);
    }

    @Override
    public synchronized void disable() {
        this.disabled = true;
    }

    @Override
    public void shutdown() {
        ExecutorServiceManager.shutdownAndAwaitTermination((ExecutorService)this.pruneCheckpointThread, (String)"checkpoint-prune");
        this.flushServices.forEach((key, value) -> ExecutorServiceManager.shutdownAndAwaitTermination((ExecutorService)value, (String)("flush-service-" + key)));
        try {
            this.exitThread.interrupt();
            this.exitThread = null;
        }
        catch (Exception e) {
            logger.warn("exitThread interrupt error", (Throwable)e);
        }
    }

    public void updateSolidity(int hops) {
        for (int i = 0; i < hops; ++i) {
            for (Chainbase db : this.dbs) {
                db.getHead().updateSolidity();
            }
        }
    }

    private boolean shouldBeRefreshed() {
        return this.flushCount >= this.maxFlushCount;
    }

    private void refresh() {
        ArrayList<ListenableFuture> futures = new ArrayList<ListenableFuture>(this.dbs.size());
        for (Chainbase db : this.dbs) {
            futures.add(this.flushServices.get(db.getDbName()).submit(() -> this.refreshOne(db)));
        }
        ListenableFuture future = Futures.allAsList(futures);
        try {
            future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new TronDBException(e);
        }
        catch (ExecutionException e) {
            throw new TronDBException(e);
        }
    }

    private void refreshOne(Chainbase db) {
        if (Snapshot.isRoot(db.getHead())) {
            return;
        }
        ArrayList<Snapshot> snapshots = new ArrayList<Snapshot>();
        SnapshotRoot root = (SnapshotRoot)db.getHead().getRoot();
        Snapshot next = root;
        for (int i = 0; i < this.flushCount; ++i) {
            next = next.getNext();
            snapshots.add(next);
        }
        root.merge(snapshots);
        root.resetSolidity();
        if (db.getHead() == next) {
            db.setHead(root);
        } else {
            next.getNext().setPrevious(root);
            root.setNext(next.getNext());
        }
    }

    public void flush() {
        if (this.unChecked) {
            return;
        }
        if (this.shouldBeRefreshed()) {
            try {
                long start = System.currentTimeMillis();
                if (!this.isV2Open()) {
                    this.deleteCheckpoint();
                }
                this.createCheckpoint();
                long checkPointEnd = System.currentTimeMillis();
                this.refresh();
                this.flushCount = 0;
                logger.info("Flush cost: {} ms, create checkpoint cost: {} ms, refresh cost: {} ms.", new Object[]{System.currentTimeMillis() - start, checkPointEnd - start, System.currentTimeMillis() - checkPointEnd});
            }
            catch (TronDBException e) {
                logger.error(" Find fatal error, program will be exited soon.", (Throwable)e);
                this.hitDown = true;
                LockSupport.unpark(this.exitThread);
            }
        }
    }

    private void createCheckpoint() {
        TronDatabase<byte[]> checkPointStore = null;
        try {
            boolean syncFlag;
            HashMap<WrappedByteArray, WrappedByteArray> batch = new HashMap<WrappedByteArray, WrappedByteArray>();
            for (Chainbase db : this.dbs) {
                Snapshot head = db.getHead();
                if (Snapshot.isRoot(head)) {
                    return;
                }
                String dbName = db.getDbName();
                if (Objects.equals(dbName, "trans-cache")) continue;
                Snapshot next = head.getRoot();
                for (int i = 0; i < this.flushCount; ++i) {
                    next = next.getNext();
                    SnapshotImpl snapshot = (SnapshotImpl)next;
                    DB keyValueDB = snapshot.getDb();
                    for (Map.Entry e2 : keyValueDB) {
                        Key k2 = (Key)e2.getKey();
                        Value v = (Value)e2.getValue();
                        batch.put(WrappedByteArray.of(Bytes.concat((byte[][])new byte[][]{this.simpleEncode(dbName), k2.getBytes()})), WrappedByteArray.of(v.encode()));
                    }
                }
            }
            if (this.isV2Open()) {
                String dbName = String.valueOf(System.currentTimeMillis());
                checkPointStore = this.getCheckpointDB(dbName);
                syncFlag = CommonParameter.getInstance().getStorage().isCheckpointSync();
            } else {
                checkPointStore = this.checkTmpStore;
                syncFlag = CommonParameter.getInstance().getStorage().isDbSync();
            }
            checkPointStore.getDbSource().updateByBatch(batch.entrySet().stream().map(e -> Maps.immutableEntry((Object)((WrappedByteArray)e.getKey()).getBytes(), (Object)((WrappedByteArray)e.getValue()).getBytes())).collect(HashMap::new, (m, k) -> {
                byte[] cfr_ignored_0 = (byte[])m.put(k.getKey(), k.getValue());
            }, HashMap::putAll), WriteOptionsWrapper.getInstance().sync(syncFlag));
        }
        catch (Exception e3) {
            throw new TronDBException(e3);
        }
        finally {
            if (this.isV2Open() && checkPointStore != null) {
                checkPointStore.close();
            }
        }
    }

    private TronDatabase<byte[]> getCheckpointDB(String dbName) {
        return new CheckPointV2Store("checkpoint/" + dbName);
    }

    private List<String> getCheckpointList() {
        String[] subDirs;
        String dbPath = Paths.get(StorageUtils.getOutputDirectoryByDbName(CHECKPOINT_V2_DIR), CommonParameter.getInstance().getStorage().getDbDirectory()).toString();
        File file = new File(Paths.get(dbPath, CHECKPOINT_V2_DIR).toString());
        if (file.exists() && file.isDirectory() && (subDirs = file.list()) != null) {
            return Arrays.stream(subDirs).sorted().collect(Collectors.toList());
        }
        return null;
    }

    private void deleteCheckpoint() {
        try {
            HashMap hmap = new HashMap();
            for (Map.Entry entry : this.checkTmpStore.getDbSource()) {
                hmap.put(entry.getKey(), null);
            }
            if (hmap.size() != 0) {
                this.checkTmpStore.getDbSource().updateByBatch(hmap);
            }
        }
        catch (Exception e) {
            throw new TronDBException(e);
        }
    }

    private void pruneCheckpoint() {
        String cp;
        long timestamp;
        if (this.unChecked) {
            return;
        }
        List<String> cpList = this.getCheckpointList();
        if (cpList == null) {
            return;
        }
        if (cpList.size() < 3) {
            return;
        }
        long latestTimestamp = Long.parseLong(cpList.get(cpList.size() - 1));
        Iterator<String> iterator = cpList.subList(0, cpList.size() - 3).iterator();
        while (iterator.hasNext() && latestTimestamp - (timestamp = Long.parseLong(cp = iterator.next())) > 120000L) {
            String checkpointPath = Paths.get(StorageUtils.getOutputDirectoryByDbName(CHECKPOINT_V2_DIR), CommonParameter.getInstance().getStorage().getDbDirectory(), CHECKPOINT_V2_DIR).toString();
            if (!FileUtil.recursiveDelete((String)Paths.get(checkpointPath, cp).toString())) {
                logger.error("checkpoint prune failed, timestamp: {}", (Object)timestamp);
                return;
            }
            logger.debug("checkpoint prune success, timestamp: {}", (Object)timestamp);
        }
    }

    @Override
    public void check() {
        if (!this.isV2Open()) {
            List<String> cpList = this.getCheckpointList();
            if (cpList != null && cpList.size() != 0) {
                logger.error("checkpoint check failed, the checkpoint version of database not match your config file, please set storage.checkpoint.version = 2 in your config file and restart the node.");
                System.exit(-1);
            }
            this.checkV1();
        } else {
            this.checkV2();
        }
    }

    private void checkV1() {
        for (Chainbase db : this.dbs) {
            if (Snapshot.isRoot(db.getHead())) continue;
            throw new IllegalStateException("First check.");
        }
        this.recover(this.checkTmpStore);
        logger.info("checkpoint v1 recover success");
        this.unChecked = false;
    }

    private void checkV2() {
        logger.info("checkpoint version: {}", (Object)CommonParameter.getInstance().getStorage().getCheckpointVersion());
        logger.info("checkpoint sync: {}", (Object)CommonParameter.getInstance().getStorage().isCheckpointSync());
        List<String> cpList = this.getCheckpointList();
        if (cpList == null || cpList.size() == 0) {
            logger.info("checkpoint size is 0, using v1 recover");
            this.checkV1();
            this.deleteCheckpoint();
            return;
        }
        long latestTimestamp = Long.parseLong(cpList.get(cpList.size() - 1));
        for (String cp : cpList) {
            long timestamp = Long.parseLong(cp);
            if (latestTimestamp - timestamp > 120000L) continue;
            TronDatabase<byte[]> checkPointV2Store = this.getCheckpointDB(cp);
            this.recover(checkPointV2Store);
            checkPointV2Store.close();
        }
        logger.info("checkpoint v2 recover success");
        this.unChecked = false;
    }

    private void recover(TronDatabase<byte[]> tronDatabase) {
        Map<String, Chainbase> dbMap = this.dbs.stream().map(db -> Maps.immutableEntry((Object)db.getDbName(), (Object)db)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        this.advance();
        for (Map.Entry entry : tronDatabase.getDbSource()) {
            byte[] realValue;
            byte[] key = (byte[])entry.getKey();
            byte[] value = (byte[])entry.getValue();
            String db2 = SnapshotManager.simpleDecode(key);
            if (dbMap.get(db2) == null) continue;
            byte[] realKey = Arrays.copyOfRange(key, db2.getBytes().length + 4, key.length);
            byte[] byArray = realValue = value.length == 1 ? null : Arrays.copyOfRange(value, 1, value.length);
            if (realValue != null) {
                dbMap.get(db2).getHead().put(realKey, realValue);
                continue;
            }
            byte op = value[0];
            if (Value.Operator.DELETE.getValue() == op) {
                dbMap.get(db2).getHead().remove(realKey);
                continue;
            }
            dbMap.get(db2).getHead().put(realKey, new byte[0]);
        }
        this.dbs.forEach(db -> db.getHead().getRoot().merge(db.getHead()));
        this.retreat();
    }

    private boolean isV2Open() {
        return this.checkpointVersion == 2;
    }

    private byte[] simpleEncode(String s) {
        byte[] bytes = s.getBytes();
        byte[] length = Ints.toByteArray((int)bytes.length);
        byte[] r = new byte[4 + bytes.length];
        System.arraycopy(length, 0, r, 0, 4);
        System.arraycopy(bytes, 0, r, 4, bytes.length);
        return r;
    }

    public List<Chainbase> getDbs() {
        return this.dbs;
    }

    public int getSize() {
        return this.size;
    }

    public int getActiveSession() {
        return this.activeSession;
    }

    public void setUnChecked(boolean unChecked) {
        this.unChecked = unChecked;
    }

    public void setCheckTmpStore(CheckTmpStore checkTmpStore) {
        this.checkTmpStore = checkTmpStore;
    }

    public CheckTmpStore getCheckTmpStore() {
        return this.checkTmpStore;
    }

    @Override
    public void setMaxFlushCount(int maxFlushCount) {
        this.maxFlushCount = maxFlushCount;
    }

    public static class Session
    implements ISession {
        private static final Logger logger = LoggerFactory.getLogger((String)"DB");
        private SnapshotManager snapshotManager;
        private boolean applySnapshot = true;
        private boolean disableOnExit = false;

        public Session(SnapshotManager snapshotManager) {
            this(snapshotManager, false);
        }

        public Session(SnapshotManager snapshotManager, boolean disableOnExit) {
            this.snapshotManager = snapshotManager;
            this.disableOnExit = disableOnExit;
        }

        public void commit() {
            this.applySnapshot = false;
            this.snapshotManager.commit();
        }

        public void revoke() {
            if (this.applySnapshot) {
                this.snapshotManager.revoke();
            }
            this.applySnapshot = false;
        }

        public void merge() {
            if (this.applySnapshot) {
                this.snapshotManager.merge();
            }
            this.applySnapshot = false;
        }

        public void destroy() {
            try {
                if (this.applySnapshot) {
                    this.snapshotManager.revoke();
                }
            }
            catch (Exception e) {
                logger.error("Revoke database error.", (Throwable)e);
            }
            if (this.disableOnExit) {
                this.snapshotManager.disable();
            }
        }

        public void close() {
            try {
                if (this.applySnapshot) {
                    this.snapshotManager.revoke();
                }
            }
            catch (Exception e) {
                logger.error("Revoke database error.", (Throwable)e);
                throw new RevokingStoreIllegalStateException((Throwable)e);
            }
            if (this.disableOnExit) {
                this.snapshotManager.disable();
            }
        }

        public SnapshotManager getSnapshotManager() {
            return this.snapshotManager;
        }

        public boolean isApplySnapshot() {
            return this.applySnapshot;
        }

        public boolean isDisableOnExit() {
            return this.disableOnExit;
        }
    }
}

