/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.db2.common;

import com.google.common.hash.BloomFilter;
import com.google.common.hash.Funnel;
import com.google.common.hash.Funnels;
import com.google.common.primitives.Longs;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.ArrayUtils;
import org.bouncycastle.util.encoders.Hex;
import org.iq80.leveldb.WriteOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.parameter.CommonParameter;
import org.tron.common.prometheus.Metrics;
import org.tron.common.storage.leveldb.LevelDbDataSourceImpl;
import org.tron.common.storage.rocksdb.RocksDbDataSourceImpl;
import org.tron.common.utils.ByteArray;
import org.tron.common.utils.FileUtil;
import org.tron.common.utils.JsonUtil;
import org.tron.common.utils.StorageUtils;
import org.tron.core.capsule.BytesCapsule;
import org.tron.core.db.RecentTransactionItem;
import org.tron.core.db.RecentTransactionStore;
import org.tron.core.db.common.iterator.DBIterator;
import org.tron.core.db2.common.DB;
import org.tron.core.db2.common.Flusher;
import org.tron.core.db2.common.LevelDB;
import org.tron.core.db2.common.RocksDB;
import org.tron.core.db2.common.WrappedByteArray;

public class TxCacheDB
implements DB<byte[], byte[]>,
Flusher {
    private static final Logger logger = LoggerFactory.getLogger((String)"DB");
    private static final long MAX_BLOCK_SIZE = 65536L;
    private final int TRANSACTION_COUNT;
    private static final long INVALID_BLOCK = -1L;
    private final byte[] FAKE_TRANSACTION = ByteArray.fromLong((long)0L);
    private BloomFilter<byte[]>[] bloomFilters = new BloomFilter[2];
    private volatile long filterStartBlock = -1L;
    private volatile long currentBlockNum = -1L;
    private volatile int currentFilterIndex = 0;
    private long lastMetricBlock = 0L;
    private final String name;
    private DB<byte[], byte[]> persistentStore;
    private RecentTransactionStore recentTransactionStore;
    private final Path cacheFile0;
    private final Path cacheFile1;
    private final Path cacheProperties;
    private final Path cacheDir;
    private AtomicBoolean isValid = new AtomicBoolean(false);
    private volatile boolean alive;

    public TxCacheDB(String name, RecentTransactionStore recentTransactionStore) {
        this.name = name;
        this.TRANSACTION_COUNT = CommonParameter.getInstance().getStorage().getEstimatedBlockTransactions();
        this.recentTransactionStore = recentTransactionStore;
        String dbEngine = CommonParameter.getInstance().getStorage().getDbEngine();
        if ("LEVELDB".equals(dbEngine.toUpperCase())) {
            this.persistentStore = new LevelDB(new LevelDbDataSourceImpl(StorageUtils.getOutputDirectoryByDbName(name), name, StorageUtils.getOptionsByDbName(name), new WriteOptions().sync(CommonParameter.getInstance().getStorage().isDbSync())));
        } else if ("ROCKSDB".equals(dbEngine.toUpperCase())) {
            String parentPath = Paths.get(StorageUtils.getOutputDirectoryByDbName(name), CommonParameter.getInstance().getStorage().getDbDirectory()).toString();
            this.persistentStore = new RocksDB(new RocksDbDataSourceImpl(parentPath, name, CommonParameter.getInstance().getRocksDBCustomSettings()));
        } else {
            throw new RuntimeException(String.format("db type: %s is not supported", dbEngine));
        }
        this.bloomFilters[0] = BloomFilter.create((Funnel)Funnels.byteArrayFunnel(), (long)(65536L * (long)this.TRANSACTION_COUNT));
        this.bloomFilters[1] = BloomFilter.create((Funnel)Funnels.byteArrayFunnel(), (long)(65536L * (long)this.TRANSACTION_COUNT));
        this.cacheDir = Paths.get(CommonParameter.getInstance().getOutputDirectory(), ".cache");
        this.cacheFile0 = Paths.get(this.cacheDir.toString(), "bloomFilters_0");
        this.cacheFile1 = Paths.get(this.cacheDir.toString(), "bloomFilters_1");
        this.cacheProperties = Paths.get(this.cacheDir.toString(), "txCache.properties");
    }

    private void initCache() {
        long start = System.currentTimeMillis();
        DBIterator iterator = (DBIterator)this.persistentStore.iterator();
        long persistentSize = 0L;
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            if (ArrayUtils.isEmpty((byte[])((byte[])entry.getKey())) || ArrayUtils.isEmpty((byte[])((byte[])entry.getValue()))) {
                return;
            }
            this.bloomFilters[1].put(entry.getKey());
            ++persistentSize;
        }
        logger.info("Load cache from persistentStore, db: {}, filter: {}, filter-fpp: {}, cost: {} ms.", new Object[]{persistentSize, this.bloomFilters[1].approximateElementCount(), this.bloomFilters[1].expectedFpp(), System.currentTimeMillis() - start});
    }

    public void init() {
        if (this.recovery()) {
            this.isValid.set(true);
            this.setAlive(true);
            return;
        }
        long size = this.recentTransactionStore.size();
        if (size != 65536L) {
            this.initCache();
        }
        long start = System.currentTimeMillis();
        for (Map.Entry bytesCapsuleEntry : this.recentTransactionStore) {
            byte[] data = ((BytesCapsule)bytesCapsuleEntry.getValue()).getData();
            RecentTransactionItem trx = (RecentTransactionItem)JsonUtil.json2Obj((String)new String(data), RecentTransactionItem.class);
            trx.getTransactionIds().forEach(tid -> this.bloomFilters[1].put((Object)Hex.decode((String)tid)));
        }
        logger.info("Load cache from recentTransactionStore, filter: {}, filter-fpp: {}, cost: {} ms.", new Object[]{this.bloomFilters[1].approximateElementCount(), this.bloomFilters[1].expectedFpp(), System.currentTimeMillis() - start});
        this.isValid.set(true);
        this.setAlive(true);
    }

    @Override
    public byte[] get(byte[] key) {
        if (!this.bloomFilters[0].mightContain((Object)key) && !this.bloomFilters[1].mightContain((Object)key)) {
            return null;
        }
        return this.FAKE_TRANSACTION;
    }

    @Override
    public void put(byte[] key, byte[] value) {
        if (key == null || value == null) {
            return;
        }
        long blockNum = Longs.fromByteArray((byte[])value);
        if (this.filterStartBlock == -1L) {
            this.filterStartBlock = blockNum;
            this.currentFilterIndex = 0;
            logger.info("Init tx cache bloomFilters at {}.", (Object)blockNum);
        } else if (blockNum - this.filterStartBlock > 65536L) {
            logger.info("Active bloomFilters is full (size = {} fpp = {}), create a new one (start = {}).", new Object[]{this.bloomFilters[this.currentFilterIndex].approximateElementCount(), this.bloomFilters[this.currentFilterIndex].expectedFpp(), blockNum});
            this.currentFilterIndex = this.currentFilterIndex == 0 ? 1 : 0;
            this.filterStartBlock = blockNum;
            this.bloomFilters[this.currentFilterIndex] = BloomFilter.create((Funnel)Funnels.byteArrayFunnel(), (long)(65536L * (long)this.TRANSACTION_COUNT));
        }
        this.bloomFilters[this.currentFilterIndex].put((Object)key);
        this.currentBlockNum = blockNum;
        if (this.lastMetricBlock != blockNum) {
            this.lastMetricBlock = blockNum;
            Metrics.gaugeSet((String)"tron:tx_cache", (double)this.bloomFilters[this.currentFilterIndex].approximateElementCount(), (String[])new String[]{"count"});
            Metrics.gaugeSet((String)"tron:tx_cache", (double)this.bloomFilters[this.currentFilterIndex].expectedFpp(), (String[])new String[]{"fpp"});
        }
    }

    @Override
    public long size() {
        throw new UnsupportedOperationException("TxCacheDB size");
    }

    @Override
    public boolean isEmpty() {
        throw new UnsupportedOperationException("TxCacheDB isEmpty");
    }

    @Override
    public void remove(byte[] key) {
        throw new UnsupportedOperationException("TxCacheDB remove");
    }

    @Override
    public String getDbName() {
        return this.name;
    }

    @Override
    public Iterator<Map.Entry<byte[], byte[]>> iterator() {
        throw new UnsupportedOperationException("TxCacheDB iterator");
    }

    @Override
    public synchronized void flush(Map<WrappedByteArray, WrappedByteArray> batch) {
        this.isValid.set(false);
        batch.forEach((? super K k, ? super V v) -> this.put(k.getBytes(), v.getBytes()));
        this.isValid.set(true);
    }

    @Override
    public void close() {
        if (!this.isAlive()) {
            return;
        }
        this.dump();
        this.bloomFilters[0] = null;
        this.bloomFilters[1] = null;
        this.persistentStore.close();
        this.setAlive(false);
    }

    @Override
    public void reset() {
    }

    private boolean recovery() {
        FileUtil.createDirIfNotExists((String)this.cacheDir.toString());
        logger.info("recovery bloomFilters start.");
        CompletableFuture<Boolean> loadProperties = CompletableFuture.supplyAsync(this::loadProperties);
        CompletionStage tk0 = loadProperties.thenApplyAsync(v -> this.recovery(0, this.cacheFile0));
        CompletionStage tk1 = loadProperties.thenApplyAsync(v -> this.recovery(1, this.cacheFile1));
        return (Boolean)((CompletableFuture)((CompletableFuture)CompletableFuture.allOf(new CompletableFuture[]{tk0, tk1}).thenApply(v -> {
            logger.info("recovery bloomFilters success.");
            return true;
        })).exceptionally(this::handleException)).join();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean recovery(int index, Path file) {
        try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(file, StandardOpenOption.READ, StandardOpenOption.DELETE_ON_CLOSE));){
            logger.info("recovery bloomFilter[{}] from file.", (Object)index);
            long start = System.currentTimeMillis();
            this.bloomFilters[index] = BloomFilter.readFrom((InputStream)in, (Funnel)Funnels.byteArrayFunnel());
            logger.info("recovery bloomFilter[{}] from file done,filter: {}, filter-fpp: {}, cost {} ms.", new Object[]{index, this.bloomFilters[index].approximateElementCount(), this.bloomFilters[index].expectedFpp(), System.currentTimeMillis() - start});
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private boolean handleException(Throwable e) {
        this.bloomFilters[0] = BloomFilter.create((Funnel)Funnels.byteArrayFunnel(), (long)(65536L * (long)this.TRANSACTION_COUNT));
        this.bloomFilters[1] = BloomFilter.create((Funnel)Funnels.byteArrayFunnel(), (long)(65536L * (long)this.TRANSACTION_COUNT));
        try {
            Files.deleteIfExists(this.cacheFile0);
            Files.deleteIfExists(this.cacheFile1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        logger.info("recovery bloomFilters failed. {}", (Object)e.getMessage());
        logger.info("rollback to previous mode.");
        return false;
    }

    private void dump() {
        if (!this.isValid.get()) {
            logger.info("bloomFilters is not valid.");
            return;
        }
        FileUtil.createDirIfNotExists((String)this.cacheDir.toString());
        logger.info("dump bloomFilters start.");
        CompletableFuture<Void> task0 = CompletableFuture.runAsync(() -> this.dump(0, this.cacheFile0));
        CompletableFuture<Void> task1 = CompletableFuture.runAsync(() -> this.dump(1, this.cacheFile1));
        ((CompletableFuture)((CompletableFuture)CompletableFuture.allOf(task0, task1).thenRun(() -> {
            this.writeProperties();
            logger.info("dump bloomFilters done.");
        })).exceptionally(e -> {
            logger.info("dump bloomFilters to file failed. {}", (Object)e.getMessage());
            return null;
        })).join();
    }

    private void dump(int index, Path file) {
        try (BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(file, new OpenOption[0]));){
            logger.info("dump bloomFilters[{}] to file.", (Object)index);
            long start = System.currentTimeMillis();
            this.bloomFilters[index].writeTo((OutputStream)out);
            logger.info("dump bloomFilters[{}] to file done,filter: {}, filter-fpp: {}, cost {} ms.", new Object[]{index, this.bloomFilters[index].approximateElementCount(), this.bloomFilters[index].expectedFpp(), System.currentTimeMillis() - start});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean loadProperties() {
        try (InputStreamReader r = new InputStreamReader((InputStream)new BufferedInputStream(Files.newInputStream(this.cacheProperties, StandardOpenOption.READ, StandardOpenOption.DELETE_ON_CLOSE)), StandardCharsets.UTF_8);){
            Properties properties = new Properties();
            properties.load(r);
            this.filterStartBlock = Long.parseLong(properties.getProperty("filterStartBlock"));
            this.currentBlockNum = Long.parseLong(properties.getProperty("currentBlockNum"));
            this.currentFilterIndex = Integer.parseInt(properties.getProperty("currentFilterIndex"));
            logger.info("filterStartBlock: {}, currentBlockNum: {}, currentFilterIndex: {}, load done.", new Object[]{this.filterStartBlock, this.currentBlockNum, this.currentFilterIndex});
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void writeProperties() {
        try (BufferedWriter w = Files.newBufferedWriter(this.cacheProperties, StandardCharsets.UTF_8, new OpenOption[0]);){
            Properties properties = new Properties();
            properties.setProperty("filterStartBlock", String.valueOf(this.filterStartBlock));
            properties.setProperty("currentBlockNum", String.valueOf(this.currentBlockNum));
            properties.setProperty("currentFilterIndex", String.valueOf(this.currentFilterIndex));
            properties.store(w, "Generated by the application.  PLEASE DO NOT EDIT! ");
            logger.info("filterStartBlock: {}, currentBlockNum: {}, currentFilterIndex: {}, write done.", new Object[]{this.filterStartBlock, this.currentBlockNum, this.currentFilterIndex});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public TxCacheDB newInstance() {
        return new TxCacheDB(this.name, this.recentTransactionStore);
    }

    @Override
    public void stat() {
    }

    public boolean isAlive() {
        return this.alive;
    }

    public void setAlive(boolean alive) {
        this.alive = alive;
    }
}

