/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.capsule;

import java.util.Objects;
import org.tron.common.parameter.CommonParameter;
import org.tron.common.utils.Commons;
import org.tron.common.utils.ForkController;
import org.tron.common.utils.Sha256Hash;
import org.tron.common.utils.StringUtil;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.config.Parameter;
import org.tron.core.db.EnergyProcessor;
import org.tron.core.exception.BalanceInsufficientException;
import org.tron.core.store.AccountStore;
import org.tron.core.store.DynamicPropertiesStore;
import org.tron.protos.Protocol;

public class ReceiptCapsule {
    private Protocol.ResourceReceipt receipt;
    private long multiSignFee;
    private long memoFee;
    private long originEnergyLeft;
    private long callerEnergyLeft;
    private long callerEnergyUsage;
    private long callerEnergyMergedUsage;
    private long originEnergyMergedUsage;
    private long callerEnergyWindowSize;
    private long callerEnergyWindowSizeV2;
    private long callerEnergyMergedWindowSize;
    private long originEnergyWindowSize;
    private long originEnergyWindowSizeV2;
    private long originEnergyMergedWindowSize;
    private Sha256Hash receiptAddress;

    public ReceiptCapsule(Protocol.ResourceReceipt data, Sha256Hash receiptAddress) {
        this.receipt = data;
        this.receiptAddress = receiptAddress;
    }

    public ReceiptCapsule(Sha256Hash receiptAddress) {
        this.receipt = Protocol.ResourceReceipt.newBuilder().build();
        this.receiptAddress = receiptAddress;
    }

    public static Protocol.ResourceReceipt copyReceipt(ReceiptCapsule origin) {
        return origin.getReceipt().toBuilder().build();
    }

    public static boolean checkForEnergyLimit(DynamicPropertiesStore ds) {
        long blockNum = ds.getLatestBlockHeaderNumber();
        return blockNum >= CommonParameter.getInstance().getBlockNumForEnergyLimit();
    }

    public Protocol.ResourceReceipt getReceipt() {
        return this.receipt;
    }

    public void setReceipt(Protocol.ResourceReceipt receipt) {
        this.receipt = receipt;
    }

    public Sha256Hash getReceiptAddress() {
        return this.receiptAddress;
    }

    public void addNetFee(long netFee) {
        this.receipt = this.receipt.toBuilder().setNetFee(this.getNetFee() + netFee).build();
    }

    public long getEnergyUsage() {
        return this.receipt.getEnergyUsage();
    }

    public void setEnergyUsage(long energyUsage) {
        this.receipt = this.receipt.toBuilder().setEnergyUsage(energyUsage).build();
    }

    public long getEnergyFee() {
        return this.receipt.getEnergyFee();
    }

    public void setEnergyFee(long energyFee) {
        this.receipt = this.receipt.toBuilder().setEnergyFee(energyFee).build();
    }

    public long getOriginEnergyUsage() {
        return this.receipt.getOriginEnergyUsage();
    }

    public void setOriginEnergyUsage(long energyUsage) {
        this.receipt = this.receipt.toBuilder().setOriginEnergyUsage(energyUsage).build();
    }

    public long getEnergyUsageTotal() {
        return this.receipt.getEnergyUsageTotal();
    }

    public void setEnergyUsageTotal(long energyUsage) {
        this.receipt = this.receipt.toBuilder().setEnergyUsageTotal(energyUsage).build();
    }

    public long getEnergyPenaltyTotal() {
        return this.receipt.getEnergyPenaltyTotal();
    }

    public void setEnergyPenaltyTotal(long penalty) {
        this.receipt = this.receipt.toBuilder().setEnergyPenaltyTotal(penalty).build();
    }

    public long getNetUsage() {
        return this.receipt.getNetUsage();
    }

    public void setNetUsage(long netUsage) {
        this.receipt = this.receipt.toBuilder().setNetUsage(netUsage).build();
    }

    public long getNetFee() {
        return this.receipt.getNetFee();
    }

    public void setNetFee(long netFee) {
        this.receipt = this.receipt.toBuilder().setNetFee(netFee).build();
    }

    public void payEnergyBill(DynamicPropertiesStore dynamicPropertiesStore, AccountStore accountStore, ForkController forkController, AccountCapsule origin, AccountCapsule caller, long percent, long originEnergyLimit, EnergyProcessor energyProcessor, long now) throws BalanceInsufficientException {
        this.setOriginEnergyUsage(0L);
        if (this.receipt.getEnergyUsageTotal() <= 0L) {
            return;
        }
        if (Objects.isNull(origin) && dynamicPropertiesStore.getAllowTvmConstantinople() == 1L) {
            this.payEnergyBill(dynamicPropertiesStore, accountStore, forkController, caller, this.receipt.getEnergyUsageTotal(), this.receipt.getResult(), energyProcessor, now);
            return;
        }
        if (!Objects.isNull(origin) && caller.getAddress().equals((Object)origin.getAddress())) {
            this.payEnergyBill(dynamicPropertiesStore, accountStore, forkController, caller, this.receipt.getEnergyUsageTotal(), this.receipt.getResult(), energyProcessor, now);
        } else {
            long originUsage = Math.multiplyExact(this.receipt.getEnergyUsageTotal(), percent) / 100L;
            originUsage = this.getOriginUsage(dynamicPropertiesStore, origin, originEnergyLimit, energyProcessor, originUsage);
            long callerUsage = this.receipt.getEnergyUsageTotal() - originUsage;
            energyProcessor.useEnergy(origin, originUsage, now);
            this.setOriginEnergyUsage(originUsage);
            this.payEnergyBill(dynamicPropertiesStore, accountStore, forkController, caller, callerUsage, this.receipt.getResult(), energyProcessor, now);
        }
    }

    private long getOriginUsage(DynamicPropertiesStore dynamicPropertiesStore, AccountCapsule origin, long originEnergyLimit, EnergyProcessor energyProcessor, long originUsage) {
        if (dynamicPropertiesStore.getAllowTvmFreeze() == 1L || dynamicPropertiesStore.supportUnfreezeDelay()) {
            return Math.min(originUsage, Math.min(this.originEnergyLeft, originEnergyLimit));
        }
        if (ReceiptCapsule.checkForEnergyLimit(dynamicPropertiesStore)) {
            return Math.min(originUsage, Math.min(energyProcessor.getAccountLeftEnergyFromFreeze(origin), originEnergyLimit));
        }
        return Math.min(originUsage, energyProcessor.getAccountLeftEnergyFromFreeze(origin));
    }

    /*
     * Unable to fully structure code
     */
    private void payEnergyBill(DynamicPropertiesStore dynamicPropertiesStore, AccountStore accountStore, ForkController forkController, AccountCapsule account, long usage, Protocol.Transaction.Result.contractResult contractResult, EnergyProcessor energyProcessor, long now) throws BalanceInsufficientException {
        block8: {
            block7: {
                accountEnergyLeft = dynamicPropertiesStore.getAllowTvmFreeze() == 1L || dynamicPropertiesStore.supportUnfreezeDelay() != false ? this.callerEnergyLeft : energyProcessor.getAccountLeftEnergyFromFreeze(account);
                if (accountEnergyLeft < usage) break block7;
                energyProcessor.useEnergy(account, usage, now);
                this.setEnergyUsage(usage);
                break block8;
            }
            energyProcessor.useEnergy(account, accountEnergyLeft, now);
            if (forkController.pass(Parameter.ForkBlockVersionEnum.VERSION_3_6_5) && dynamicPropertiesStore.getAllowAdaptiveEnergy() == 1L) {
                blockEnergyUsage = dynamicPropertiesStore.getBlockEnergyUsage() + (usage - accountEnergyLeft);
                dynamicPropertiesStore.saveBlockEnergyUsage(blockEnergyUsage);
            }
            sunPerEnergy = 100L;
            dynamicEnergyFee = dynamicPropertiesStore.getEnergyFee();
            if (dynamicEnergyFee > 0L) {
                sunPerEnergy = dynamicEnergyFee;
            }
            energyFee = (usage - accountEnergyLeft) * sunPerEnergy;
            this.setEnergyUsage(accountEnergyLeft);
            this.setEnergyFee(energyFee);
            balance = account.getBalance();
            if (balance < energyFee) {
                throw new BalanceInsufficientException(StringUtil.createReadableString((byte[])account.createDbKey()) + " insufficient balance");
            }
            account.setBalance(balance - energyFee);
            if (!dynamicPropertiesStore.supportTransactionFeePool()) ** GOTO lbl-1000
            if (!contractResult.equals((Object)Protocol.Transaction.Result.contractResult.OUT_OF_TIME)) {
                dynamicPropertiesStore.addTransactionFeePool(energyFee);
            } else if (dynamicPropertiesStore.supportBlackHoleOptimization()) {
                dynamicPropertiesStore.burnTrx(energyFee);
            } else {
                Commons.adjustBalance(accountStore, accountStore.getBlackhole(), energyFee);
            }
        }
        accountStore.put(account.getAddress().toByteArray(), account);
    }

    public Protocol.Transaction.Result.contractResult getResult() {
        return this.receipt.getResult();
    }

    public void setResult(Protocol.Transaction.Result.contractResult success) {
        this.receipt = this.receipt.toBuilder().setResult(success).build();
    }

    public long getMultiSignFee() {
        return this.multiSignFee;
    }

    public void setMultiSignFee(long multiSignFee) {
        this.multiSignFee = multiSignFee;
    }

    public long getMemoFee() {
        return this.memoFee;
    }

    public void setMemoFee(long memoFee) {
        this.memoFee = memoFee;
    }

    public void setOriginEnergyLeft(long originEnergyLeft) {
        this.originEnergyLeft = originEnergyLeft;
    }

    public void setCallerEnergyLeft(long callerEnergyLeft) {
        this.callerEnergyLeft = callerEnergyLeft;
    }

    public long getCallerEnergyUsage() {
        return this.callerEnergyUsage;
    }

    public void setCallerEnergyUsage(long callerEnergyUsage) {
        this.callerEnergyUsage = callerEnergyUsage;
    }

    public long getCallerEnergyMergedUsage() {
        return this.callerEnergyMergedUsage;
    }

    public void setCallerEnergyMergedUsage(long callerEnergyMergedUsage) {
        this.callerEnergyMergedUsage = callerEnergyMergedUsage;
    }

    public long getOriginEnergyMergedUsage() {
        return this.originEnergyMergedUsage;
    }

    public void setOriginEnergyMergedUsage(long originEnergyMergedUsage) {
        this.originEnergyMergedUsage = originEnergyMergedUsage;
    }

    public long getCallerEnergyWindowSize() {
        return this.callerEnergyWindowSize;
    }

    public void setCallerEnergyWindowSize(long callerEnergyWindowSize) {
        this.callerEnergyWindowSize = callerEnergyWindowSize;
    }

    public long getCallerEnergyWindowSizeV2() {
        return this.callerEnergyWindowSizeV2;
    }

    public void setCallerEnergyWindowSizeV2(long callerEnergyWindowSizeV2) {
        this.callerEnergyWindowSizeV2 = callerEnergyWindowSizeV2;
    }

    public long getCallerEnergyMergedWindowSize() {
        return this.callerEnergyMergedWindowSize;
    }

    public void setCallerEnergyMergedWindowSize(long callerEnergyMergedWindowSize) {
        this.callerEnergyMergedWindowSize = callerEnergyMergedWindowSize;
    }

    public long getOriginEnergyWindowSize() {
        return this.originEnergyWindowSize;
    }

    public void setOriginEnergyWindowSize(long originEnergyWindowSize) {
        this.originEnergyWindowSize = originEnergyWindowSize;
    }

    public long getOriginEnergyWindowSizeV2() {
        return this.originEnergyWindowSizeV2;
    }

    public void setOriginEnergyWindowSizeV2(long originEnergyWindowSizeV2) {
        this.originEnergyWindowSizeV2 = originEnergyWindowSizeV2;
    }

    public long getOriginEnergyMergedWindowSize() {
        return this.originEnergyMergedWindowSize;
    }

    public void setOriginEnergyMergedWindowSize(long originEnergyMergedWindowSize) {
        this.originEnergyMergedWindowSize = originEnergyMergedWindowSize;
    }
}

