/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.capsule;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.utils.ByteArray;
import org.tron.core.capsule.ExchangeProcessor;
import org.tron.core.capsule.ProtoCapsule;
import org.tron.core.config.Parameter;
import org.tron.core.store.AssetIssueStore;
import org.tron.core.store.DynamicPropertiesStore;
import org.tron.protos.Protocol;

public class ExchangeCapsule
implements ProtoCapsule<Protocol.Exchange> {
    private static final Logger logger = LoggerFactory.getLogger((String)"capsule");
    private Protocol.Exchange exchange;

    public ExchangeCapsule(Protocol.Exchange exchange) {
        this.exchange = exchange;
    }

    public ExchangeCapsule(byte[] data) {
        try {
            this.exchange = Protocol.Exchange.parseFrom((byte[])data);
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
        }
    }

    public ExchangeCapsule(ByteString address, long id, long createTime, byte[] firstTokenID, byte[] secondTokenID) {
        this.exchange = Protocol.Exchange.newBuilder().setExchangeId(id).setCreatorAddress(address).setCreateTime(createTime).setFirstTokenId(ByteString.copyFrom((byte[])firstTokenID)).setSecondTokenId(ByteString.copyFrom((byte[])secondTokenID)).build();
    }

    public static byte[] calculateDbKey(long number) {
        return ByteArray.fromLong((long)number);
    }

    public long getID() {
        return this.exchange.getExchangeId();
    }

    public void setID(long id) {
        this.exchange = this.exchange.toBuilder().setExchangeId(id).build();
    }

    public ByteString getCreatorAddress() {
        return this.exchange.getCreatorAddress();
    }

    public void setExchangeAddress(ByteString address) {
        this.exchange = this.exchange.toBuilder().setCreatorAddress(address).build();
    }

    public void setBalance(long firstTokenBalance, long secondTokenBalance) {
        this.exchange = this.exchange.toBuilder().setFirstTokenBalance(firstTokenBalance).setSecondTokenBalance(secondTokenBalance).build();
    }

    public long getCreateTime() {
        return this.exchange.getCreateTime();
    }

    public void setCreateTime(long time) {
        this.exchange = this.exchange.toBuilder().setCreateTime(time).build();
    }

    public byte[] getFirstTokenId() {
        return this.exchange.getFirstTokenId().toByteArray();
    }

    public void setFirstTokenId(byte[] id) {
        this.exchange = this.exchange.toBuilder().setFirstTokenId(ByteString.copyFrom((byte[])id)).build();
    }

    public byte[] getSecondTokenId() {
        return this.exchange.getSecondTokenId().toByteArray();
    }

    public void setSecondTokenId(byte[] id) {
        this.exchange = this.exchange.toBuilder().setSecondTokenId(ByteString.copyFrom((byte[])id)).build();
    }

    public long getFirstTokenBalance() {
        return this.exchange.getFirstTokenBalance();
    }

    public long getSecondTokenBalance() {
        return this.exchange.getSecondTokenBalance();
    }

    public byte[] createDbKey() {
        return ExchangeCapsule.calculateDbKey(this.getID());
    }

    public long transaction(byte[] sellTokenID, long sellTokenQuant) {
        long supply = 1000000000000000000L;
        ExchangeProcessor processor = new ExchangeProcessor(supply);
        long buyTokenQuant = 0L;
        long firstTokenBalance = this.exchange.getFirstTokenBalance();
        long secondTokenBalance = this.exchange.getSecondTokenBalance();
        if (this.exchange.getFirstTokenId().equals((Object)ByteString.copyFrom((byte[])sellTokenID))) {
            buyTokenQuant = processor.exchange(firstTokenBalance, secondTokenBalance, sellTokenQuant);
            this.exchange = this.exchange.toBuilder().setFirstTokenBalance(firstTokenBalance + sellTokenQuant).setSecondTokenBalance(secondTokenBalance - buyTokenQuant).build();
        } else {
            buyTokenQuant = processor.exchange(secondTokenBalance, firstTokenBalance, sellTokenQuant);
            this.exchange = this.exchange.toBuilder().setFirstTokenBalance(firstTokenBalance - buyTokenQuant).setSecondTokenBalance(secondTokenBalance + sellTokenQuant).build();
        }
        return buyTokenQuant;
    }

    public void resetTokenWithID(AssetIssueStore assetIssueStore, DynamicPropertiesStore dynamicPropertiesStore) {
        if (dynamicPropertiesStore.getAllowSameTokenName() == 0L) {
            byte[] firstTokenName = this.exchange.getFirstTokenId().toByteArray();
            byte[] secondTokenName = this.exchange.getSecondTokenId().toByteArray();
            byte[] firstTokenID = firstTokenName;
            byte[] secondTokenID = secondTokenName;
            if (!Arrays.equals(firstTokenName, Parameter.ChainSymbol.TRX_SYMBOL_BYTES)) {
                firstTokenID = assetIssueStore.get(firstTokenName).getId().getBytes();
            }
            if (!Arrays.equals(secondTokenName, Parameter.ChainSymbol.TRX_SYMBOL_BYTES)) {
                secondTokenID = assetIssueStore.get(secondTokenName).getId().getBytes();
            }
            this.exchange = this.exchange.toBuilder().setFirstTokenId(ByteString.copyFrom((byte[])firstTokenID)).setSecondTokenId(ByteString.copyFrom((byte[])secondTokenID)).build();
        }
    }

    @Override
    public byte[] getData() {
        return this.exchange.toByteArray();
    }

    @Override
    public Protocol.Exchange getInstance() {
        return this.exchange;
    }
}

