/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.db2.common;

import com.google.common.hash.BloomFilter;
import com.google.common.hash.Funnel;
import com.google.common.hash.Funnels;
import com.google.common.primitives.Longs;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.bouncycastle.util.encoders.Hex;
import org.iq80.leveldb.WriteOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.parameter.CommonParameter;
import org.tron.common.prometheus.Metrics;
import org.tron.common.storage.leveldb.LevelDbDataSourceImpl;
import org.tron.common.storage.rocksdb.RocksDbDataSourceImpl;
import org.tron.common.utils.ByteArray;
import org.tron.common.utils.JsonUtil;
import org.tron.common.utils.StorageUtils;
import org.tron.core.capsule.BytesCapsule;
import org.tron.core.db.RecentTransactionItem;
import org.tron.core.db.RecentTransactionStore;
import org.tron.core.db.common.iterator.DBIterator;
import org.tron.core.db2.common.DB;
import org.tron.core.db2.common.Flusher;
import org.tron.core.db2.common.LevelDB;
import org.tron.core.db2.common.RocksDB;
import org.tron.core.db2.common.WrappedByteArray;

public class TxCacheDB
implements DB<byte[], byte[]>,
Flusher {
    private static final Logger logger = LoggerFactory.getLogger((String)"DB");
    private static final long MAX_BLOCK_SIZE = 65536L;
    private final int TRANSACTION_COUNT;
    private static final long INVALID_BLOCK = -1L;
    private final byte[] FAKE_TRANSACTION = ByteArray.fromLong((long)0L);
    private BloomFilter<byte[]>[] bloomFilters = new BloomFilter[2];
    private volatile long filterStartBlock = -1L;
    private volatile int currentFilterIndex = 0;
    private long lastMetricBlock = 0L;
    private final String name;
    private DB<byte[], byte[]> persistentStore;
    private RecentTransactionStore recentTransactionStore;

    public TxCacheDB(String name, RecentTransactionStore recentTransactionStore) {
        this.name = name;
        this.TRANSACTION_COUNT = CommonParameter.getInstance().getStorage().getEstimatedBlockTransactions();
        this.recentTransactionStore = recentTransactionStore;
        String dbEngine = CommonParameter.getInstance().getStorage().getDbEngine();
        if ("LEVELDB".equals(dbEngine.toUpperCase())) {
            this.persistentStore = new LevelDB(new LevelDbDataSourceImpl(StorageUtils.getOutputDirectoryByDbName(name), name, StorageUtils.getOptionsByDbName(name), new WriteOptions().sync(CommonParameter.getInstance().getStorage().isDbSync())));
        } else if ("ROCKSDB".equals(dbEngine.toUpperCase())) {
            String parentPath = Paths.get(StorageUtils.getOutputDirectoryByDbName(name), CommonParameter.getInstance().getStorage().getDbDirectory()).toString();
            this.persistentStore = new RocksDB(new RocksDbDataSourceImpl(parentPath, name, CommonParameter.getInstance().getRocksDBCustomSettings()));
        } else {
            throw new RuntimeException(String.format("db type: %s is not supported", dbEngine));
        }
        this.bloomFilters[0] = BloomFilter.create((Funnel)Funnels.byteArrayFunnel(), (long)(65536L * (long)this.TRANSACTION_COUNT));
        this.bloomFilters[1] = BloomFilter.create((Funnel)Funnels.byteArrayFunnel(), (long)(65536L * (long)this.TRANSACTION_COUNT));
    }

    private void initCache() {
        long start = System.currentTimeMillis();
        DBIterator iterator = (DBIterator)this.persistentStore.iterator();
        long persistentSize = 0L;
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            if (ArrayUtils.isEmpty((byte[])((byte[])entry.getKey())) || ArrayUtils.isEmpty((byte[])((byte[])entry.getValue()))) {
                return;
            }
            this.bloomFilters[1].put(entry.getKey());
            ++persistentSize;
        }
        logger.info("Load cache from persistentStore, db: {}, filter: {}, filter-fpp: {}, cost: {} ms.", new Object[]{persistentSize, this.bloomFilters[1].approximateElementCount(), this.bloomFilters[1].expectedFpp(), System.currentTimeMillis() - start});
    }

    public void init() {
        long size = this.recentTransactionStore.size();
        if (size != 65536L) {
            this.initCache();
        }
        long start = System.currentTimeMillis();
        for (Map.Entry bytesCapsuleEntry : this.recentTransactionStore) {
            byte[] data = ((BytesCapsule)bytesCapsuleEntry.getValue()).getData();
            RecentTransactionItem trx = (RecentTransactionItem)JsonUtil.json2Obj((String)new String(data), RecentTransactionItem.class);
            trx.getTransactionIds().forEach(tid -> this.bloomFilters[1].put((Object)Hex.decode((String)tid)));
        }
        logger.info("Load cache from recentTransactionStore, filter: {}, filter-fpp: {}, cost: {} ms.", new Object[]{this.bloomFilters[1].approximateElementCount(), this.bloomFilters[1].expectedFpp(), System.currentTimeMillis() - start});
    }

    @Override
    public byte[] get(byte[] key) {
        if (!this.bloomFilters[0].mightContain((Object)key) && !this.bloomFilters[1].mightContain((Object)key)) {
            return null;
        }
        return this.FAKE_TRANSACTION;
    }

    @Override
    public void put(byte[] key, byte[] value) {
        if (key == null || value == null) {
            return;
        }
        long blockNum = Longs.fromByteArray((byte[])value);
        if (this.filterStartBlock == -1L) {
            this.filterStartBlock = blockNum;
            this.currentFilterIndex = 0;
            logger.info("Init tx cache bloomFilters at {}.", (Object)blockNum);
        } else if (blockNum - this.filterStartBlock > 65536L) {
            logger.info("Active bloomFilters is full (size = {} fpp = {}), create a new one (start = {}).", new Object[]{this.bloomFilters[this.currentFilterIndex].approximateElementCount(), this.bloomFilters[this.currentFilterIndex].expectedFpp(), blockNum});
            this.currentFilterIndex = this.currentFilterIndex == 0 ? 1 : 0;
            this.filterStartBlock = blockNum;
            this.bloomFilters[this.currentFilterIndex] = BloomFilter.create((Funnel)Funnels.byteArrayFunnel(), (long)(65536L * (long)this.TRANSACTION_COUNT));
        }
        this.bloomFilters[this.currentFilterIndex].put((Object)key);
        if (this.lastMetricBlock != blockNum) {
            this.lastMetricBlock = blockNum;
            Metrics.gaugeSet((String)"tron:tx_cache", (double)this.bloomFilters[this.currentFilterIndex].approximateElementCount(), (String[])new String[]{"count"});
            Metrics.gaugeSet((String)"tron:tx_cache", (double)this.bloomFilters[this.currentFilterIndex].expectedFpp(), (String[])new String[]{"fpp"});
        }
    }

    @Override
    public long size() {
        throw new UnsupportedOperationException("TxCacheDB size");
    }

    @Override
    public boolean isEmpty() {
        throw new UnsupportedOperationException("TxCacheDB isEmpty");
    }

    @Override
    public void remove(byte[] key) {
        throw new UnsupportedOperationException("TxCacheDB remove");
    }

    @Override
    public String getDbName() {
        return this.name;
    }

    @Override
    public Iterator<Map.Entry<byte[], byte[]>> iterator() {
        throw new UnsupportedOperationException("TxCacheDB iterator");
    }

    @Override
    public void flush(Map<WrappedByteArray, WrappedByteArray> batch) {
        batch.forEach((? super K k, ? super V v) -> this.put(k.getBytes(), v.getBytes()));
    }

    @Override
    public void close() {
        this.reset();
        this.bloomFilters[0] = null;
        this.bloomFilters[1] = null;
        this.persistentStore.close();
    }

    @Override
    public void reset() {
    }

    @Override
    public TxCacheDB newInstance() {
        return new TxCacheDB(this.name, this.recentTransactionStore);
    }

    @Override
    public void stat() {
    }
}

