/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.db;

import com.google.protobuf.InvalidProtocolBufferException;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.iq80.leveldb.Options;
import org.iq80.leveldb.WriteOptions;
import org.rocksdb.DirectComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.tron.common.parameter.CommonParameter;
import org.tron.common.storage.WriteOptionsWrapper;
import org.tron.common.storage.leveldb.LevelDbDataSourceImpl;
import org.tron.common.storage.metric.DbStatService;
import org.tron.common.storage.rocksdb.RocksDbDataSourceImpl;
import org.tron.common.utils.StorageUtils;
import org.tron.core.db.common.DbSourceInter;
import org.tron.core.db2.common.WrappedByteArray;
import org.tron.core.db2.core.ITronChainBase;
import org.tron.core.exception.BadItemException;
import org.tron.core.exception.ItemNotFoundException;

public abstract class TronDatabase<T>
implements ITronChainBase<T> {
    private static final Logger logger = LoggerFactory.getLogger((String)"DB");
    protected DbSourceInter<byte[]> dbSource;
    private String dbName;
    private WriteOptionsWrapper writeOptions = WriteOptionsWrapper.getInstance().sync(CommonParameter.getInstance().getStorage().isDbSync());
    @Autowired
    private DbStatService dbStatService;

    protected TronDatabase(String dbName) {
        this.dbName = dbName;
        if ("LEVELDB".equals(CommonParameter.getInstance().getStorage().getDbEngine().toUpperCase())) {
            this.dbSource = new LevelDbDataSourceImpl(StorageUtils.getOutputDirectoryByDbName(dbName), dbName, this.getOptionsByDbNameForLevelDB(dbName), new WriteOptions().sync(CommonParameter.getInstance().getStorage().isDbSync()));
        } else if ("ROCKSDB".equals(CommonParameter.getInstance().getStorage().getDbEngine().toUpperCase())) {
            String parentName = Paths.get(StorageUtils.getOutputDirectoryByDbName(dbName), CommonParameter.getInstance().getStorage().getDbDirectory()).toString();
            this.dbSource = new RocksDbDataSourceImpl(parentName, dbName, CommonParameter.getInstance().getRocksDBCustomSettings(), this.getDirectComparator());
        }
        this.dbSource.initDB();
    }

    @PostConstruct
    protected void init() {
        this.dbStatService.register(this.dbSource);
    }

    protected TronDatabase() {
    }

    protected Options getOptionsByDbNameForLevelDB(String dbName) {
        return StorageUtils.getOptionsByDbName(dbName);
    }

    protected DirectComparator getDirectComparator() {
        return null;
    }

    public DbSourceInter<byte[]> getDbSource() {
        return this.dbSource;
    }

    public void updateByBatch(Map<byte[], byte[]> rows) {
        this.dbSource.updateByBatch(rows, this.writeOptions);
    }

    @Override
    public void reset() {
        this.dbSource.resetDb();
    }

    @Override
    public void close() {
        this.dbSource.closeDB();
    }

    @Override
    public abstract void put(byte[] var1, T var2);

    @Override
    public abstract void delete(byte[] var1);

    @Override
    public abstract T get(byte[] var1) throws InvalidProtocolBufferException, ItemNotFoundException, BadItemException;

    @Override
    public T getFromRoot(byte[] key) throws InvalidProtocolBufferException, BadItemException, ItemNotFoundException {
        return this.get(key);
    }

    @Override
    public T getUnchecked(byte[] key) {
        return null;
    }

    public Map<WrappedByteArray, byte[]> prefixQuery(byte[] key) {
        return this.dbSource.prefixQuery(key);
    }

    @Override
    public abstract boolean has(byte[] var1);

    @Override
    public boolean isNotEmpty() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public Iterator<Map.Entry<byte[], T>> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getDbName() {
        return this.dbName;
    }
}

